/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.UndeliverableReturnCode;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.AORequested;
import com.ibm.ws.sib.processor.impl.AOStream;
import com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.AOValue;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AOProtocolItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPReceivedMessageRequestInfo;
import com.ibm.ws.sib.processor.runtime.SIMPTransmitMessageRequestControllable;
import com.ibm.ws.sib.processor.runtime.anycast.ReceivedMessageRequestInfo;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;

public class TransmitMessageRequest
extends AbstractControlAdapter
implements SIMPTransmitMessageRequestControllable {
    private long tick;
    private SIMPItemStream itemStream;
    private AOStream aoStream;
    private MessageProcessor messageProcessor;
    private DestinationHandler destination;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static TraceComponent tc = SibTr.register(TransmitMessageRequest.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public TransmitMessageRequest(long tick, AOProtocolItemStream itemStream, AOStream aoStream, MessageProcessor messageProcessor, DestinationHandler destination) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"TransmitMessageRequest", (Object)new Object[]{new Long(tick), itemStream, aoStream, messageProcessor, destination});
        }
        this.tick = tick;
        this.itemStream = itemStream;
        this.aoStream = aoStream;
        this.messageProcessor = messageProcessor;
        this.destination = destination;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"TransmitMessageRequest");
        }
    }

    private long getMessageID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageID");
        }
        long msgId = -1L;
        TickRange r = this.getTickRange();
        if (r.value instanceof AOValue) {
            msgId = ((AOValue)r.value).getMsgId();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageID", (Object)new Long(msgId));
        }
        return msgId;
    }

    private TickRange getTickRange() {
        return this.aoStream.getTickRange(this.tick);
    }

    public JsMessage getJsMessage() throws SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getJsMessage");
        }
        this.assertValidControllable();
        SIMPMessage message = null;
        try {
            message = this.getSIMPMessage();
            if (message == null) {
                SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"TransmitMessageRequest.assertValidControllable", "1:169:1.48", this.aoStream.getID()}, null));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
                }
                throw finalE;
            }
        }
        catch (SIResourceException e) {
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"TransmitMessageRequest.getJsMessage", "1:187:1.48", e}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getJsMessage", (Object)message.getMessage());
        }
        return message.getMessage();
    }

    public String getState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        String state = null;
        TickRange r = this.getTickRange();
        byte tickState = r.type;
        switch (tickState) {
            case 1: {
                state = SIMPTransmitMessageRequestControllable.State.REQUEST.toString();
                break;
            }
            case 5: {
                state = SIMPTransmitMessageRequestControllable.State.ACKNOWLEDGED.toString();
                break;
            }
            case 7: {
                state = SIMPTransmitMessageRequestControllable.State.ACKNOWLEDGED.toString();
                break;
            }
            case 6: {
                state = SIMPTransmitMessageRequestControllable.State.REJECT.toString();
                break;
            }
            case 3: {
                state = ((AOValue)r.value).removing ? SIMPTransmitMessageRequestControllable.State.REMOVING.toString() : SIMPTransmitMessageRequestControllable.State.PENDING_ACKNOWLEDGEMENT.toString();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getState", (Object)state);
        }
        return state;
    }

    public long getStartTick() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStateTick");
        }
        long startTick = this.getTickRange().startstamp;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStartTick", (Object)new Long(startTick));
        }
        return startTick;
    }

    public long getEndTick() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEndTick");
        }
        long endTick = this.getTickRange().endstamp;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEndTick", (Object)new Long(endTick));
        }
        return endTick;
    }

    public void moveMessage(boolean discard) throws SIMPControllableNotFoundException, SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveMessage");
        }
        this.assertValidControllable();
        SIMPTransactionManager txManager = this.messageProcessor.getTXManager();
        LocalTransaction tran = txManager.createLocalTransaction(false);
        long msgID = this.getMessageID();
        try {
            SIMPMessage msg = this.getSIMPMessage();
            if (!discard) {
                ExceptionDestinationHandlerImpl edh = new ExceptionDestinationHandlerImpl(this.destination);
                UndeliverableReturnCode code = edh.handleUndeliverableMessage((SIBusMessage)msg.getMessage(), null, (TransactionCommon)tran, 36, new String[]{"" + msgID, this.destination.toString(), this.messageProcessor.getMessagingEngineName()});
                if (code == UndeliverableReturnCode.OK || code == UndeliverableReturnCode.DISCARD) {
                    discard = true;
                } else {
                    SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"TransmitMessageRequest.moveMessage", "1:328:1.48", code}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"moveMessage", (Object)((Object)finalE));
                    }
                    throw finalE;
                }
            }
            if (discard) {
                Transaction msTran = this.messageProcessor.resolveAndEnlistMsgStoreTransaction((TransactionCommon)tran);
                this.aoStream.syncRemoveValueTick(this.tick, msTran, msg);
            }
            tran.commit();
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.TransmitMessageRequest.moveMessage", (String)"1:353:1.48", (Object)this);
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"TransmitMessageRequest.moveMessage", "1:361:1.48", e, new Long(msgID)}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"moveMessage", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveMessage");
        }
    }

    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)("" + this.aoStream.getID()));
        }
        return "" + this.aoStream.getID() + ":" + this.tick;
    }

    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName");
        }
        return null;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this.aoStream.itemStream == null || this.tick < 0L) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"QueuedMessage.assertValidControllable", "1:416:1.48", new Long(this.aoStream.getID())}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    @Override
    public void deregisterControlAdapterMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
            SibTr.exit((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"runtimeEventOccurred", (Object)event);
            SibTr.exit((TraceComponent)tc, (String)"runtimeEventOccurred");
        }
    }

    public String getTransactionId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionId");
        }
        String tranID = null;
        PersistentTranId pTranID = this.itemStream.getTransactionId();
        if (pTranID != null) {
            tranID = pTranID.toTMString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransactionId", (Object)tranID);
        }
        return tranID;
    }

    private SIMPMessage getSIMPMessage() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIMPMessage");
        }
        SIMPMessage message = null;
        try {
            message = (SIMPMessage)this.itemStream.findById(this.getMessageID());
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.TransmitMessageRequest.getSIMPMessage", (String)"1:519:1.48", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getSIMPMessage", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIMPMessage", (Object)message);
        }
        return message;
    }

    public long getTick() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTick");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTick", (Object)new Long(this.tick));
        }
        return this.tick;
    }

    public SIMPReceivedMessageRequestInfo getRequestMessageInfo() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRequestMessageInfo");
        }
        ReceivedMessageRequestInfo requestInfo = null;
        Object tickValue = this.aoStream.getTickRange((long)this.tick).value;
        if (tickValue instanceof AORequested) {
            AORequested aoReqValue = (AORequested)tickValue;
            requestInfo = new ReceivedMessageRequestInfo(aoReqValue.startTime, aoReqValue.expiryInterval, aoReqValue.aock.getSelectionCriterias(), this.aoStream.getDMEVersion(), aoReqValue.tick);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRequestMessageInfo", requestInfo);
        }
        return requestInfo;
    }

    public synchronized void cancelMessageRequest(boolean discard) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cancelMessageRequest", (Object)new Boolean(discard));
        }
        SIMPTransactionManager txManager = this.messageProcessor.getTXManager();
        LocalTransaction tran = null;
        try {
            MessageItem msg = (MessageItem)this.getSIMPMessage();
            if (discard) {
                if (msg != null) {
                    tran = txManager.createLocalTransaction(false);
                    Transaction msTran = this.messageProcessor.resolveAndEnlistMsgStoreTransaction((TransactionCommon)tran);
                    this.aoStream.syncRemoveValueTick(this.tick, msTran, msg);
                    tran.commit();
                } else {
                    this.aoStream.expiredRequest(this.tick, true);
                }
            } else if (msg != null) {
                long lockID;
                tran = txManager.createLocalTransaction(false);
                Transaction msTran = this.messageProcessor.resolveAndEnlistMsgStoreTransaction((TransactionCommon)tran);
                this.aoStream.syncRemoveValueTick(this.tick, msTran, null);
                if (msg.isInStore() && (lockID = msg.getLockID()) != -2L) {
                    msg.unlockMsg(lockID, msTran, true);
                }
                tran.commit();
            } else {
                this.aoStream.expiredRequest(this.tick, true);
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.TransmitMessageRequest.cancelMessageRequest", (String)"1:644:1.48", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.TransmitMessageRequest.cancelMessageRequest", "1:649:1.48", SIMPUtils.getStackTrace(e)});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            try {
                if (tran != null) {
                    tran.rollback();
                }
            }
            catch (SIException ee) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.TransmitMessageRequest.cancelMessageRequest", (String)"1:669:1.48", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.TransmitMessageRequest.cancelMessageRequest", "1:674:1.48", SIMPUtils.getStackTrace(e)});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            try {
                if (tran != null) {
                    tran.rollback();
                }
            }
            catch (SIException ee) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cancelMessageRequest");
        }
    }

    public long getMEArrivalTimestamp() throws SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMEArrivalTimestamp");
        }
        long timestamp = this.getJsMessage().getCurrentMEArrivalTimestamp();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMEArrivalTimestamp", (Object)new Long(timestamp));
        }
        return timestamp;
    }
}

