/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.ClosedException;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdate;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;

public class AsyncUpdateThread
implements AlarmListener {
    private static final TraceComponent tc = SibTr.register(AsyncUpdateThread.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private final SIMPTransactionManager tranManager;
    private final MessageProcessor mp;
    private ArrayList enqueuedUnits;
    private boolean executing;
    private ArrayList executingUnits;
    private final int batchThreshold;
    private final long maxCommitInterval;
    private boolean executeSinceExpiry;
    private boolean closed;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public AsyncUpdateThread(MessageProcessor mp, SIMPTransactionManager tranManager, int batchThreshold, long maxCommitInterval) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AsyncUpdateThread", (Object)new Object[]{mp, tranManager, batchThreshold, maxCommitInterval});
        }
        this.mp = mp;
        this.tranManager = tranManager;
        this.batchThreshold = batchThreshold;
        this.maxCommitInterval = maxCommitInterval;
        this.closed = false;
        this.enqueuedUnits = new ArrayList(10);
        this.executingUnits = new ArrayList(10);
        this.executing = false;
        this.executeSinceExpiry = false;
        if (maxCommitInterval > 0L) {
            mp.getAlarmManager().create(maxCommitInterval, this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AsyncUpdateThread", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueWork(AsyncUpdate unit) throws ClosedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"enqueueWork", (Object)unit);
        }
        AsyncUpdateThread asyncUpdateThread = this;
        synchronized (asyncUpdateThread) {
            if (this.closed) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"enqueueWork", (Object)"ClosedException");
                }
                throw new ClosedException();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Enqueueing update: " + unit));
            }
            this.enqueuedUnits.add(unit);
            if (this.executing) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"enqueueWork", (Object)"AsyncUpdateThread executing");
                }
                return;
            }
            if (this.enqueuedUnits.size() > this.batchThreshold) {
                this.executeSinceExpiry = true;
                try {
                    this.startExecutingUpdates();
                }
                catch (ClosedException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"enqueueWork", (Object)e);
                    }
                    throw e;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"enqueueWork");
        }
    }

    private void startExecutingUpdates() throws ClosedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startExecutingUpdates");
        }
        ArrayList temp = this.executingUnits;
        this.executingUnits = this.enqueuedUnits;
        this.enqueuedUnits = temp;
        this.enqueuedUnits.clear();
        this.executing = true;
        try {
            LocalTransaction tran = this.tranManager.createLocalTransaction(false);
            ExecutionThread thread = new ExecutionThread(this.executingUnits, tran);
            this.mp.startNewSystemThread(thread);
        }
        catch (InterruptedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.startExecutingUpdates", (String)"1:222:1.28", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"startExecutingUpdates", (Object)e);
            }
            this.closed = true;
            throw new ClosedException(e.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startExecutingUpdates");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object thandle) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)new Object[]{this, this.mp.getMessagingEngineUuid()});
        }
        AsyncUpdateThread asyncUpdateThread = this;
        synchronized (asyncUpdateThread) {
            if (!this.closed) {
                if (this.executeSinceExpiry || this.executing) {
                    this.executeSinceExpiry = false;
                } else {
                    try {
                        if (this.enqueuedUnits.size() > 0) {
                            this.startExecutingUpdates();
                        }
                    }
                    catch (ClosedException closedException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.maxCommitInterval > 0L) {
            this.mp.getAlarmManager().create(this.maxCommitInterval, this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close");
        }
        AsyncUpdateThread asyncUpdateThread = this;
        synchronized (asyncUpdateThread) {
            this.closed = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillAllUpdatesExecuted() throws InterruptedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"waitTillAllUpdatesExecuted");
        }
        AsyncUpdateThread asyncUpdateThread = this;
        synchronized (asyncUpdateThread) {
            while (this.enqueuedUnits.size() > 0 || this.executing) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"waitTillAllUpdatesExecuted", (Object)e);
                    }
                    throw e;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"waitTillAllUpdatesExecuted");
        }
    }

    class ExecutionThread
    implements Runnable {
        private List _list;
        private LocalTransaction _tran;

        ExecutionThread(List list, LocalTransaction tran) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"ExecutionThread", (Object)new Object[]{list, tran});
            }
            this._list = list;
            this._tran = tran;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ExecutionThread", (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"run", (Object)this);
            }
            try {
                Throwable ex = null;
                boolean keepRunning = true;
                do {
                    AsyncUpdate unit;
                    int length = this._list.size();
                    for (int i = 0; i < length; ++i) {
                        unit = (AsyncUpdate)this._list.get(i);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Executing update: " + unit));
                        }
                        try {
                            unit.execute((TransactionCommon)this._tran);
                            continue;
                        }
                        catch (Throwable e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:286:1.28", (Object)this);
                            ex = e;
                            break;
                        }
                    }
                    if (ex == null) {
                        try {
                            this._tran.commit();
                        }
                        catch (SIException x) {
                            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:307:1.28", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)x));
                            ex = x;
                        }
                        catch (SIErrorException x) {
                            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:319:1.28", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)x));
                            ex = x;
                        }
                        catch (Throwable x) {
                            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:331:1.28", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Throwable)x);
                            ex = x;
                        }
                    } else {
                        try {
                            this._tran.rollback();
                        }
                        catch (SIException x) {
                            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:352:1.28", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)x));
                        }
                        catch (SIErrorException x) {
                            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:362:1.28", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)x));
                        }
                        catch (Throwable x) {
                            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:372:1.28", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Throwable)x);
                        }
                    }
                    for (int i = 0; i < length; ++i) {
                        unit = (AsyncUpdate)this._list.get(i);
                        if (ex == null) {
                            try {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Committing update: " + unit));
                                }
                                unit.committed();
                            }
                            catch (SIException e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:396:1.28", (Object)this);
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            }
                            continue;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Rolling back update: " + unit));
                        }
                        unit.rolledback(ex);
                    }
                    AsyncUpdateThread asyncUpdateThread = AsyncUpdateThread.this;
                    synchronized (asyncUpdateThread) {
                        if (!AsyncUpdateThread.this.closed) {
                            AsyncUpdateThread.this.executing = false;
                            if (ex == null && AsyncUpdateThread.this.enqueuedUnits.size() > AsyncUpdateThread.this.batchThreshold) {
                                AsyncUpdateThread.this.executeSinceExpiry = true;
                                ArrayList temp = AsyncUpdateThread.this.executingUnits;
                                AsyncUpdateThread.this.executingUnits = AsyncUpdateThread.this.enqueuedUnits;
                                AsyncUpdateThread.this.enqueuedUnits = temp;
                                AsyncUpdateThread.this.enqueuedUnits.clear();
                                AsyncUpdateThread.this.executing = true;
                                this._list = AsyncUpdateThread.this.executingUnits;
                                this._tran = AsyncUpdateThread.this.tranManager.createLocalTransaction(false);
                            }
                        }
                        AsyncUpdateThread.this.notify();
                        keepRunning = AsyncUpdateThread.this.executing;
                    }
                } while (keepRunning);
            }
            catch (RuntimeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:451:1.28", (Object)this);
                AsyncUpdateThread asyncUpdateThread = AsyncUpdateThread.this;
                synchronized (asyncUpdateThread) {
                    AsyncUpdateThread.this.closed = true;
                }
                SibTr.error((TraceComponent)tc, (String)nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", "1:462:1.28", e}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                    SibTr.exit((TraceComponent)tc, (String)"run", (Object)e);
                }
                throw e;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"run");
            }
        }
    }
}

