/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIApiConstants;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.processor.exceptions.SIMPNoLocalisationsException;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.util.Iterator;
import java.util.List;

public class ReportHandler {
    private static final TraceComponent tc = SibTr.register(ReportHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private final MessageProcessor _messageProcessor;

    public ReportHandler(MessageProcessor messageProcessor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ReportHandler", (Object)messageProcessor);
        }
        this._messageProcessor = messageProcessor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ReportHandler", (Object)this);
        }
    }

    public void handleMessage(SIMPMessage msg, TransactionCommon tran, Integer reportType) throws SIIncorrectCallException, SITemporaryDestinationNotFoundException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleMessage", (Object)new Object[]{msg, tran, reportType});
        }
        JsMessage message = null;
        try {
            message = msg.getMessage().getReceived();
        }
        catch (MessageCopyFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ReportHandler.handleMessage", (String)"1:139:1.40", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"handleMessage", (Object)"SIErrorException");
            }
            throw new SIErrorException((Throwable)e);
        }
        Byte reportContent = null;
        if (reportType == SIApiConstants.REPORT_COA) {
            reportContent = message.getReportCOA();
        } else if (reportType == SIApiConstants.REPORT_COD) {
            reportContent = msg.getReportCOD();
        } else if (reportType == SIApiConstants.REPORT_EXCEPTION) {
            reportContent = message.getReportException();
        } else if (reportType == SIApiConstants.REPORT_EXPIRY) {
            reportContent = message.getReportExpiry();
        }
        if (reportContent.equals(SIApiConstants.REPORT_NO_DATA)) {
            message.clearMessagePayload();
            message.clearMessageProperties();
        }
        message.setReportFeedback(reportType);
        message.setReportCOA(null);
        message.setReportCOD(null);
        message.setReportException(null);
        message.setReportExpiry(null);
        message.setReportNAN(null);
        message.setReportPAN(null);
        message.setReportDiscardMsg(Boolean.FALSE);
        message.setTimeToLive(0L);
        message.setRemainingTimeToLive(-1L);
        message.setMessageWaitTime(0L);
        message.setTimestamp(System.currentTimeMillis());
        message.setRedeliveredCount(0);
        message.setMediated(false);
        message.setDeliveryDelay(0L);
        if (msg.getMessage().getReplyPriority() != null) {
            message.setPriority(msg.getMessage().getReplyPriority().intValue());
        }
        if (msg.getMessage().getReplyReliability() != null) {
            message.setReliability(msg.getMessage().getReplyReliability());
        }
        if (msg.getMessage().getReplyTimeToLive() != null) {
            message.setTimeToLive(msg.getMessage().getReplyTimeToLive().longValue());
        } else {
            message.setTimeToLive(0L);
        }
        if (msg.getMessage().getReplyDiscriminator() != null) {
            message.setDiscriminator(msg.getMessage().getReplyDiscriminator());
        } else {
            message.setDiscriminator(null);
        }
        if (Boolean.FALSE.equals(msg.getMessage().getReportPassCorrelId())) {
            message.setCorrelationIdAsBytes(message.getApiMessageIdAsBytes());
        }
        if (Boolean.FALSE.equals(msg.getMessage().getReportPassMsgId())) {
            byte[] newId;
            byte[] oldId = message.getApiMessageIdAsBytes();
            if (oldId != null) {
                newId = new byte[oldId.length + 1];
                for (int i = 0; i < oldId.length; ++i) {
                    newId[i] = oldId[i];
                }
                newId[oldId.length] = reportType.byteValue();
            } else {
                newId = new byte[]{reportType.byteValue()};
            }
            message.setApiMessageIdAsBytes(newId);
        }
        if (!msg.getMessage().isReverseRoutingPathEmpty()) {
            List rrp = msg.getMessage().getReverseRoutingPath();
            JsDestinationAddress destinationAddress = null;
            Iterator it = rrp.iterator();
            destinationAddress = (JsDestinationAddress)it.next();
            rrp.remove(destinationAddress);
            message.setForwardRoutingPath(rrp);
            message.setRoutingDestination(destinationAddress);
            DestinationHandler destination = this._messageProcessor.getDestinationManager().getDestination(destinationAddress, true);
            InputHandler inputHandler = destination.getInputHandler();
            try {
                inputHandler.handleMessage(new MessageItem(message), tran, this._messageProcessor.getMessagingEngineUuid());
            }
            catch (SIMPNoLocalisationsException e) {
                destination.handleUndeliverableMessage(msg, 26, new String[]{destination.getName()}, null);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleMessage");
        }
    }
}

