/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.archive;

import com.ibm.ws.kernel.boot.archive.Archive;
import com.ibm.ws.kernel.boot.archive.DirEntryConfig;
import com.ibm.ws.kernel.boot.archive.DirPattern;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class FilteredDirEntryConfig
extends DirEntryConfig {
    final String FILTER_REGEX = "\"(\\{aes\\}|\\{xor\\}).*\"";
    final String WLP_PASSWORD_ENCYRPTION_STRING = "wlp.password.encryption.key";
    final String WLP_AES_ENCRYPTION_STRING = "wlp.aes.encryption.key";
    final String WLP_PASSWORD_ENCRYPTION_REGEX = "wlp.password.encryption.key=.*$";
    final String WLP_AES_ENCRYPTION_REGEX = "wlp.aes.encryption.key=.*$";
    final String OBSCURED_VALUE = "\"*****\"";
    final Pattern obscuredValuePattern = Pattern.compile("\"(\\{aes\\}|\\{xor\\}).*\"");
    final Pattern wlpPasswordEncryptionPattern = Pattern.compile("wlp.password.encryption.key=.*$", 8);
    final Pattern wlpAesEncryptionPattern = Pattern.compile("wlp.aes.encryption.key=.*$", 8);

    public FilteredDirEntryConfig(File source, boolean includeByDefault, DirPattern.PatternStrategy strategy) throws IOException {
        super("", source, includeByDefault, strategy);
    }

    @Override
    public void configure(Archive archive) throws IOException {
        ArrayList<String> dirContent = new ArrayList<String>();
        this.filterDirectory(dirContent, this.dirPattern, "");
        for (String file : dirContent) {
            Path originalPath = new File(this.source, file).toPath();
            if (originalPath.toFile().isDirectory()) continue;
            Path tempFile = Files.createTempFile(null, null, new FileAttribute[0]);
            String originalFile = new String(Files.readAllBytes(originalPath));
            String newFile = this.obscuredValuePattern.matcher(originalFile).replaceAll("\"*****\"");
            newFile = this.wlpPasswordEncryptionPattern.matcher(newFile).replaceAll("wlp.password.encryption.key=*****");
            newFile = this.wlpAesEncryptionPattern.matcher(newFile).replaceAll("wlp.aes.encryption.key=*****");
            Files.write(tempFile, newFile.getBytes(), new OpenOption[0]);
            archive.addFileEntry(file, tempFile.toFile());
        }
    }
}

