/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JavaInfo {
    public static final String CONDITION_ID = "io.openliberty.java.version";
    private static JavaInfo instance;
    private final int MAJOR;
    private final int MINOR;
    private final int MICRO;
    private final int SERVICE_RELEASE;
    private final int FIXPACK;
    private final Vendor VENDOR;
    private static final Map<String, Boolean> systemClassAvailability;
    private static final SystemClassAccessor systemClassAccessor;
    static final long serialVersionUID = 4030879351740265700L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private JavaInfo() {
        String version = JavaInfo.getSystemProperty("java.version");
        String[] versionElements = version.split("\\D");
        int i = Integer.valueOf(versionElements[0]) == 1 ? 1 : 0;
        this.MAJOR = Integer.valueOf(versionElements[i++]);
        this.MINOR = i < versionElements.length ? JavaInfo.parseIntSafe(versionElements[i++]) : 0;
        this.MICRO = i < versionElements.length ? JavaInfo.parseIntSafe(versionElements[i]) : 0;
        String vendor = JavaInfo.getSystemProperty("java.vendor").toLowerCase();
        this.VENDOR = vendor.contains("openj9") ? Vendor.OPENJ9 : (vendor.contains("ibm") || vendor.contains("j9") ? Vendor.IBM : (vendor.contains("oracle") ? Vendor.ORACLE : ((vendor = JavaInfo.getSystemProperty("java.vm.name", "unknown").toLowerCase()).contains("openj9") ? Vendor.OPENJ9 : (vendor.contains("ibm") || vendor.contains("j9") ? Vendor.IBM : (vendor.contains("oracle") || vendor.contains("openjdk") ? Vendor.ORACLE : Vendor.UNKNOWN)))));
        String runtimeVersion = JavaInfo.getSystemProperty("java.runtime.version").toLowerCase();
        int sr = 0;
        int srloc = runtimeVersion.indexOf("sr");
        if (srloc > -1 && (srloc += 2) < runtimeVersion.length()) {
            int len = 0;
            while (srloc + len < runtimeVersion.length() && Character.isDigit(runtimeVersion.charAt(srloc + len))) {
                ++len;
            }
            if (len > 0) {
                sr = JavaInfo.parseIntSafe(runtimeVersion.substring(srloc, srloc + len));
            }
        }
        this.SERVICE_RELEASE = sr;
        int fp = 0;
        int fploc = runtimeVersion.indexOf("fp");
        if (fploc > -1 && (fploc += 2) < runtimeVersion.length()) {
            int len = 0;
            while (fploc + len < runtimeVersion.length() && Character.isDigit(runtimeVersion.charAt(fploc + len))) {
                ++len;
            }
            if (len > 0) {
                fp = JavaInfo.parseIntSafe(runtimeVersion.substring(fploc, fploc + len));
            }
        }
        this.FIXPACK = fp;
    }

    private static final String getSystemProperty(final String propName, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -711096860540306369L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty(propName, defaultValue);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.JavaInfo$1", 1.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
            }
        });
    }

    private static final String getSystemProperty(final String propName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 3620127931986235410L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty(propName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.JavaInfo$2", 2.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
            }
        });
    }

    private static JavaInfo instance() {
        if (instance == null) {
            instance = new JavaInfo();
        }
        return instance;
    }

    public static int majorVersion() {
        return JavaInfo.instance().MAJOR;
    }

    public static int minorVersion() {
        return JavaInfo.instance().MINOR;
    }

    public static int microVersion() {
        return JavaInfo.instance().MICRO;
    }

    public static boolean isSystemClassAvailable(final String className) {
        return systemClassAvailability.computeIfAbsent(className, k -> AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = -9007827319826886569L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @FFDCIgnore(value={ClassNotFoundException.class})
            public Boolean run() {
                try {
                    systemClassAccessor.getSystemClass(className);
                    return true;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.JavaInfo$3", 3.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
            }
        }));
    }

    @Deprecated
    public static Vendor vendor() {
        return JavaInfo.instance().VENDOR;
    }

    public static int serviceRelease() {
        return JavaInfo.instance().SERVICE_RELEASE;
    }

    public static int fixPack() {
        return JavaInfo.instance().FIXPACK;
    }

    public static String debugString() {
        return "Vendor = " + (Object)((Object)JavaInfo.vendor()) + ", Version = " + JavaInfo.majorVersion() + "." + JavaInfo.minorVersion();
    }

    private static int parseIntSafe(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.kernel.service.util.JavaInfo", (String)"242", null, (Object[])new Object[]{str});
            return 0;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.JavaInfo", JavaInfo.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        systemClassAvailability = new ConcurrentHashMap<String, Boolean>();
        systemClassAccessor = new SystemClassAccessor();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class SystemClassAccessor
    extends ClassLoader {
        static final long serialVersionUID = 6596606273951747930L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private SystemClassAccessor() {
        }

        public Class<?> getSystemClass(String className) throws ClassNotFoundException {
            return this.findSystemClass(className);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.JavaInfo$SystemClassAccessor", SystemClassAccessor.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }

    public static enum Vendor {
        IBM,
        OPENJ9,
        ORACLE,
        UNKNOWN;

    }
}

