/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.registry.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.SearchResult;
import com.ibm.ws.security.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.security.wim.registry.util.BridgeUtils;
import com.ibm.ws.security.wim.registry.util.TypeMappings;
import com.ibm.ws.security.wim.util.UniqueNameHelper;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.EntityNotInRealmScopeException;
import com.ibm.wsspi.security.wim.exception.InvalidUniqueNameException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Context;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.Root;
import com.ibm.wsspi.security.wim.model.SearchControl;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SearchBridge {
    private static final TraceComponent tc = Tr.register(SearchBridge.class, (String)"registyUtil", (String)"com.ibm.ws.security.wim.registry.util.resources.RegistryUtilMessages");
    private TypeMappings propertyMap;
    private BridgeUtils mappingUtils;
    private String groupRDN;
    static final long serialVersionUID = -8274377172336292275L;

    @FFDCIgnore(value={Exception.class})
    public SearchBridge(BridgeUtils mappingUtil) {
        block3: {
            this.propertyMap = null;
            this.mappingUtils = null;
            this.groupRDN = "cn";
            String methodName = "SearchBridge";
            this.mappingUtils = mappingUtil;
            this.propertyMap = new TypeMappings(mappingUtil);
            try {
                String[] groupRDNList = this.mappingUtils.getCoreConfiguration().getRDNProperties("Group");
                if (groupRDNList != null && groupRDNList.length > 0) {
                    this.groupRDN = groupRDNList[0];
                }
            }
            catch (Exception excp) {
                if (!tc.isEventEnabled()) break block3;
                Tr.event((TraceComponent)tc, (String)(methodName + " " + excp.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={WIMException.class})
    public SearchResult getUsers(String inputPattern, int inputLimit) throws RegistryException {
        String methodName = "getUsers";
        SearchResult returnValue = new SearchResult();
        try {
            String inputAttrName;
            boolean isInputAttrIdentifier;
            this.mappingUtils.validateId(inputPattern);
            IDAndRealm idAndRealm = this.mappingUtils.separateIDAndRealm(inputPattern);
            Root root = this.mappingUtils.getWimService().createRootObject();
            if (idAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
            }
            if (isInputAttrIdentifier = this.mappingUtils.isIdentifierTypeProperty(inputAttrName = this.propertyMap.getInputUserSecurityName(idAndRealm.getRealm()))) {
                inputAttrName = "principalName";
            }
            String outputAttrName = this.propertyMap.getOutputUserSecurityName(idAndRealm.getRealm());
            List controls = root.getControls();
            SearchControl searchControl = new SearchControl();
            if (controls != null) {
                controls.add(searchControl);
            }
            if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName)) {
                searchControl.getProperties().add(outputAttrName);
            }
            String quote = "'";
            String id = idAndRealm.getId();
            if (id.indexOf("'") != -1) {
                quote = "\"";
            }
            searchControl.setExpression("//entities[@xsi:type='LoginAccount' and " + inputAttrName + "=" + quote + id + quote + "]");
            if (inputLimit > 0) {
                searchControl.setCountLimit(inputLimit + 1);
            } else {
                searchControl.setCountLimit(inputLimit);
            }
            Context context = new Context();
            context.set("key", (Object)"useUserFilterForSearch");
            context.set("value", (Object)id);
            root.getContexts().add(context);
            root = this.mappingUtils.getWimService().search(root);
            List returnedList = root.getEntities();
            if (!returnedList.isEmpty()) {
                ArrayList<String> people = new ArrayList<String>();
                for (int count = 0; count < returnedList.size() && (inputLimit <= 0 || count != inputLimit); ++count) {
                    Entity loginAccount = (Entity)returnedList.get(count);
                    String sName = this.getSecurityNameFromEntity(methodName, outputAttrName, loginAccount);
                    if (sName == null) continue;
                    people.add(sName);
                }
                returnValue = new SearchResult(people, true);
            } else {
                returnValue = new SearchResult(new ArrayList(), false);
            }
        }
        catch (WIMException toCatch) {
            if (toCatch instanceof EntityNotFoundException || toCatch instanceof InvalidUniqueNameException || toCatch instanceof EntityNotInRealmScopeException) {
                returnValue = new SearchResult(new ArrayList(), false);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " " + toCatch.getMessage()), (Object[])new Object[]{toCatch});
            }
            if (tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)toCatch.getMessage(), (Object[])new Object[]{toCatch});
            }
            throw new RegistryException(toCatch.getMessage(), (Throwable)toCatch);
        }
        return returnValue;
    }

    @FFDCIgnore(value={WIMException.class, InvalidNameException.class})
    public SearchResult getGroups(String inputPattern, int inputLimit) throws RegistryException {
        String methodName = "getGroups";
        SearchResult returnValue = new SearchResult();
        try {
            String inputAttrName;
            this.mappingUtils.validateId(inputPattern);
            IDAndRealm idAndRealm = this.mappingUtils.separateIDAndRealm(inputPattern);
            Root root = this.mappingUtils.getWimService().createRootObject();
            if (idAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
            }
            String groupSecNameAttr = inputAttrName = this.propertyMap.getInputGroupSecurityName(idAndRealm.getRealm());
            boolean isInputAttrIdentifier = this.mappingUtils.isIdentifierTypeProperty(inputAttrName);
            if (isInputAttrIdentifier) {
                inputAttrName = this.groupRDN;
            }
            String outputAttrName = this.propertyMap.getOutputGroupSecurityName(idAndRealm.getRealm());
            String quote = "'";
            String id = idAndRealm.getId();
            if (id.indexOf("'") != -1) {
                quote = "\"";
            }
            boolean callGetAPI = false;
            if (UniqueNameHelper.isDN((String)id) != null && groupSecNameAttr.equals("uniqueName")) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)(methodName + " Group Security name mapped to uniqueName. Invoking get instead of search"), (Object[])new Object[]{methodName});
                }
                callGetAPI = true;
                List entities = root.getEntities();
                Group entity = new Group();
                if (entities != null) {
                    entities.add(entity);
                }
                IdentifierType idfType = new IdentifierType();
                idfType.setUniqueName(id);
                entity.setIdentifier(idfType);
                root = this.mappingUtils.getWimService().get(root);
            } else {
                List controls = root.getControls();
                SearchControl searchControl = new SearchControl();
                if (controls != null) {
                    controls.add(searchControl);
                }
                if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName)) {
                    searchControl.getProperties().add(outputAttrName);
                }
                LdapName dnName = null;
                try {
                    dnName = new LdapName(inputPattern);
                }
                catch (InvalidNameException invalidNameException) {
                    // empty catch block
                }
                if (dnName != null) {
                    int index = inputPattern.indexOf("=");
                    int endIndex = inputPattern.indexOf(",", index);
                    String attrName = inputAttrName;
                    String value = null;
                    if (index > 0) {
                        attrName = inputPattern.substring(0, index);
                        value = inputPattern.substring(index + 1, endIndex);
                        List propList = Group.getPropertyNames(null);
                        for (String prop : propList) {
                            if (!prop.equalsIgnoreCase(attrName)) continue;
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)(methodName + " equalsIgnoreCase match on " + prop + ", swapping out " + attrName), (Object[])new Object[0]);
                            }
                            attrName = prop;
                        }
                    }
                    String searchBase = null;
                    if (endIndex + 1 < inputPattern.length()) {
                        searchBase = inputPattern.substring(endIndex + 1);
                        searchControl.getSearchBases().add(searchBase);
                    }
                    searchControl.setExpression("//entities[@xsi:type='Group' and " + attrName + "=" + quote + value + quote + "]");
                } else {
                    searchControl.setExpression("//entities[@xsi:type='Group' and " + inputAttrName + "=" + quote + id + quote + "]");
                }
                if (inputLimit > 0) {
                    searchControl.setCountLimit(inputLimit + 1);
                } else {
                    searchControl.setCountLimit(inputLimit);
                }
                Context context = new Context();
                context.set("key", (Object)"useGroupFilterForSearch");
                context.set("value", (Object)id);
                root.getContexts().add(context);
                root = this.mappingUtils.getWimService().search(root);
            }
            List returnedList = root.getEntities();
            if (!returnedList.isEmpty()) {
                ArrayList<String> groups = new ArrayList<String>();
                for (int count = 0; count < returnedList.size() && (inputLimit <= 0 || count != inputLimit); ++count) {
                    Entity group = (Entity)returnedList.get(count);
                    boolean isEntityTypeGrp = false;
                    isEntityTypeGrp = callGetAPI ? group.isSubType("Group") : true;
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)(methodName + " Value of isEntityTypGrp :" + isEntityTypeGrp), (Object[])new Object[]{methodName});
                    }
                    if (isEntityTypeGrp) {
                        String sName = this.getSecurityNameFromEntity(methodName, outputAttrName, group);
                        if (sName == null) continue;
                        groups.add(sName);
                        continue;
                    }
                    if (!tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)(methodName + " The Entity type was not compatible with Group. The entityType is : " + group.getTypeName()), (Object[])new Object[0]);
                }
                returnValue = new SearchResult(groups, true);
            } else {
                returnValue = new SearchResult(new ArrayList(), false);
            }
        }
        catch (WIMException toCatch) {
            if (toCatch instanceof EntityNotFoundException || toCatch instanceof InvalidUniqueNameException || toCatch instanceof EntityNotInRealmScopeException) {
                returnValue = new SearchResult(new ArrayList(), false);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " " + toCatch.getMessage()), (Object[])new Object[]{toCatch});
            }
            if (tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)toCatch.getMessage(), (Object[])new Object[]{toCatch});
            }
            throw new RegistryException(toCatch.getMessage(), (Throwable)toCatch);
        }
        return returnValue;
    }

    private String getSecurityNameFromEntity(String methodName, String securityNameAttr, Entity entity) {
        String entityName = null;
        if (!this.mappingUtils.isIdentifierTypeProperty(securityNameAttr)) {
            Object value = entity.get(securityNameAttr);
            if (value instanceof String) {
                entityName = (String)value;
            } else if (value instanceof List && !((List)value).isEmpty()) {
                entityName = BridgeUtils.getStringValue(((List)value).get(0));
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " Excluding the following entity from results as it does not contain the specified output attribute {0}.\n\n{1}"), (Object[])new Object[]{securityNameAttr, entity});
            }
        } else {
            entityName = BridgeUtils.getStringValue(entity.getIdentifier().get(securityNameAttr));
        }
        return entityName;
    }
}

