/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.internal.ContextServiceImpl;
import com.ibm.ws.concurrent.internal.ManagedCompletableFuture;
import com.ibm.ws.concurrent.internal.ManagedCompletionStage;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.enterprise.concurrent.ContextService;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ContextServiceWithExecutor
implements ContextService {
    private static final TraceComponent tc = Tr.register(ContextServiceWithExecutor.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
    private final Executor managedExecutor;
    private final ContextServiceImpl sharedContextSvc;
    static final long serialVersionUID = 2022755431268387333L;

    @Trivial
    public ContextServiceWithExecutor(ContextServiceImpl sharedContextSvc, Executor managedExecutor) {
        this.managedExecutor = managedExecutor;
        this.sharedContextSvc = sharedContextSvc;
    }

    @Trivial
    public <R> Callable<R> contextualCallable(Callable<R> callable) {
        return this.sharedContextSvc.contextualCallable(callable);
    }

    @Trivial
    public <T, U> BiConsumer<T, U> contextualConsumer(BiConsumer<T, U> consumer) {
        return this.sharedContextSvc.contextualConsumer(consumer);
    }

    @Trivial
    public <T> Consumer<T> contextualConsumer(Consumer<T> consumer) {
        return this.sharedContextSvc.contextualConsumer(consumer);
    }

    @Trivial
    public <T, U, R> BiFunction<T, U, R> contextualFunction(BiFunction<T, U, R> function) {
        return this.sharedContextSvc.contextualFunction(function);
    }

    @Trivial
    public <T, R> Function<T, R> contextualFunction(Function<T, R> function) {
        return this.sharedContextSvc.contextualFunction(function);
    }

    @Trivial
    public Runnable contextualRunnable(Runnable runnable) {
        return this.sharedContextSvc.contextualRunnable(runnable);
    }

    @Trivial
    public <R> Supplier<R> contextualSupplier(Supplier<R> supplier) {
        return this.sharedContextSvc.contextualSupplier(supplier);
    }

    @Trivial
    public Object createContextualProxy(Object instance, Class<?> ... interfaces) {
        return this.sharedContextSvc.createContextualProxy(instance, interfaces);
    }

    @Trivial
    public Object createContextualProxy(Object instance, Map<String, String> executionProperties, Class<?> ... interfaces) {
        return this.sharedContextSvc.createContextualProxy(instance, executionProperties, interfaces);
    }

    @Trivial
    public <T> T createContextualProxy(T instance, Class<T> intf) {
        return this.sharedContextSvc.createContextualProxy(instance, intf);
    }

    @Trivial
    public <T> T createContextualProxy(T instance, Map<String, String> executionProperties, Class<T> intf) {
        return this.sharedContextSvc.createContextualProxy(instance, executionProperties, intf);
    }

    @Trivial
    public Executor currentContextExecutor() {
        return this.sharedContextSvc.currentContextExecutor();
    }

    @Trivial
    public Map<String, String> getExecutionProperties(Object contextualProxy) {
        return this.sharedContextSvc.getExecutionProperties(contextualProxy);
    }

    @Trivial
    public final int hashCode() {
        return this.managedExecutor.hashCode();
    }

    @Trivial
    public String toString() {
        return new StringBuilder(48).append("ContextServiceWithExecutor@").append(Integer.toHexString(this.hashCode())).append("(id=").append(Integer.toHexString(System.identityHashCode(this))).append(')').toString();
    }

    public <T> CompletableFuture<T> withContextCapture(CompletableFuture<T> stage) {
        ManagedCompletableFuture newCompletableFuture = ManagedCompletableFuture.JAVA8 ? new ManagedCompletableFuture(new CompletableFuture(), this.managedExecutor, null) : new ManagedCompletableFuture(this.managedExecutor, null);
        stage.whenComplete((result, failure) -> {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"whenComplete", (Object[])new Object[]{result, failure});
            }
            if (failure == null) {
                newCompletableFuture.complete(result);
            } else {
                newCompletableFuture.completeExceptionally((Throwable)failure);
            }
        });
        return newCompletableFuture;
    }

    public <T> CompletionStage<T> withContextCapture(CompletionStage<T> stage) {
        ManagedCompletionStage newStage = ManagedCompletableFuture.JAVA8 ? new ManagedCompletionStage(new CompletableFuture(), this.managedExecutor, null) : new ManagedCompletionStage(this.managedExecutor);
        stage.whenComplete((result, failure) -> {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"whenComplete", (Object[])new Object[]{result, failure});
            }
            if (failure == null) {
                newStage.super_complete(result);
            } else {
                newStage.super_completeExceptionally((Throwable)failure);
            }
        });
        return newStage;
    }
}

