/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.JFapConnectionBrokenException;
import com.ibm.ws.sib.jfapchannel.framework.FrameworkException;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionContext;
import com.ibm.ws.sib.jfapchannel.impl.CommsOutboundChain;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.IdTableFullException;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionData;
import com.ibm.ws.sib.jfapchannel.impl.octracker.OutboundConnectionTracker;
import com.ibm.ws.sib.utils.ras.SibTr;

public class OutboundConnection
extends Connection {
    private static final TraceComponent tc = SibTr.register(OutboundConnection.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    public static final String $sccsid = "@(#) 1.44 SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/OutboundConnection.java, SIB.comms, WASX.SIB, uu1215.01 11/09/22 03:41:21 [4/12/12 22:14:14]";
    private OutboundConnectionTracker tracker = null;
    private boolean handshakeComplete = false;
    private final Object handshakeMonitor = new Object();
    private ConnectionData connectionData;
    private boolean beingPurged = false;
    private int handshakersWaiting = 0;
    private final String eyeCatcher;

    public OutboundConnection(NetworkConnectionContext connLink, NetworkConnection vc, OutboundConnectionTracker connTracker, int heartbeatInterval, int heartbeatTimeout, ConnectionData connectionData) throws FrameworkException {
        super(connLink, vc, heartbeatInterval, heartbeatTimeout, CommsOutboundChain.getChainDetails(connLink.getMetaData().getChainName()) == null ? false : CommsOutboundChain.getChainDetails(connLink.getMetaData().getChainName()).useNetty());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{connLink, vc, connTracker, "" + heartbeatInterval, "" + heartbeatTimeout});
        }
        this.connectionData = connectionData;
        this.tracker = connTracker;
        this.description = "OUT " + this.tcpCtx.getLocalAddress().getHostAddress() + ":" + this.tcpCtx.getLocalPort() + "->" + this.tcpCtx.getRemoteAddress().getHostAddress() + ":" + this.tcpCtx.getRemotePort();
        this.eyeCatcher = this.tcpCtx.getLocalAddress().getHostAddress() + ":" + this.tcpCtx.getLocalPort() + ":" + this.tcpCtx.getRemoteAddress().getHostAddress() + ":" + this.tcpCtx.getRemotePort();
        this.remoteHostAddress = this.tcpCtx.getRemoteAddress().getHostAddress();
        this.chainName = this.getMetaData().getChainName();
        if (TraceComponent.isAnyTracingEnabled()) {
            JFapUtils.debugSummaryMessage(tc, this, null, "New outbound connection established");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationImpl startNewConversation(ConversationReceiveListener defaultReceiveListener, boolean handshakeRequired) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"startNewClientConversation", (Object)new Object[]{defaultReceiveListener, handshakeRequired});
        }
        if (handshakeRequired) {
            Object object = this.handshakeMonitor;
            synchronized (object) {
                if (!this.handshakeComplete) {
                    if (this.handshakersWaiting == 0) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"first conversation on connection");
                        }
                        ++this.handshakersWaiting;
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"waiting for handshaking to be complete");
                        }
                        boolean interrupted = false;
                        do {
                            ++this.handshakersWaiting;
                            interrupted = false;
                            try {
                                this.handshakeMonitor.wait();
                            }
                            catch (InterruptedException e) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"interrupted whilst waiting for handshaking");
                                }
                                interrupted = true;
                            }
                        } while (interrupted);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"finsihed waiting for handshaking");
                        }
                    }
                }
            }
        }
        int conversationId = 0;
        try {
            conversationId = this.conversationTable.reserveId();
        }
        catch (IdTableFullException e) {
            throw new SIResourceException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"OUTBOUNDCONN_IDTABLEFULL_SICJ0055", null, (String)"OUTBOUNDCONN_IDTABLEFULL_SICJ0055"), (Throwable)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("connection table allocated conversation id: " + conversationId));
        }
        ConversationImpl c = new ConversationImpl((short)conversationId, !this.handshakeComplete, this, defaultReceiveListener);
        ConversationImpl retValue = this.startNewConversationGeneric(c, true, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"startNewClientConversation", (Object)retValue);
        }
        return retValue;
    }

    @Override
    public void closeNotification(Conversation c) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"closeNotification", (Object)c);
        }
        this.tracker.closeConversation(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"closeNotification");
        }
    }

    @Override
    public void invalidateImpl(boolean notifyPeer, Throwable throwable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"invalidateImpl", (Object)new Object[]{"" + notifyPeer, throwable});
        }
        if (throwable != null && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            SibTr.exception((TraceComponent)tc, (Throwable)throwable);
        }
        JFapConnectionBrokenException exception = new JFapConnectionBrokenException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"OUTBOUNDCONV_INVALIDATE_SICJ0056", (Object[])new Object[]{this.remoteHostAddress, "" + this.getMetaData().getRemotePort(), this.chainName}, null));
        if (throwable != null) {
            exception.initCause(throwable);
        }
        this.wakeupAllConversationsWithException((SIException)((Object)exception), true);
        this.tracker.purgeFromInvalidateImpl(this, notifyPeer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"invalidateImpl");
        }
    }

    @Override
    protected void connectionClosedByPeer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connectionClosedByPeer");
        }
        this.tracker.purgeClosedConnection(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connectionClosedByPeer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handshakeComplete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"handshakeComplete");
        }
        Object object = this.handshakeMonitor;
        synchronized (object) {
            if (!this.handshakeComplete) {
                this.handshakeComplete = true;
                this.handshakersWaiting = 0;
                this.handshakeMonitor.notifyAll();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"handshakeComplete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handshakeFailed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"handshakeFailed");
        }
        this.invalidate(true, null, null);
        this.tracker.removeConnectionDataFromGroup(this);
        Object object = this.handshakeMonitor;
        synchronized (object) {
            if (!this.handshakeComplete) {
                this.handshakersWaiting = 0;
                this.handshakeMonitor.notifyAll();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"handshakeFailed");
        }
    }

    public void setConnectionData(ConnectionData connectionData) {
        this.connectionData = connectionData;
    }

    public ConnectionData getConnectionData() {
        return this.connectionData;
    }

    public boolean isBeingPurged() {
        return this.beingPurged;
    }

    public void beingPurged() {
        this.beingPurged = true;
    }

    @Override
    protected Conversation cloneConversation(ConversationReceiveListener receiveListener) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cloneConnection", (Object)receiveListener);
        }
        Conversation returnConversation = this.tracker.cloneConversation(this, receiveListener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cloneConnection", (Object)returnConversation);
        }
        return returnConversation;
    }

    @Override
    protected ConversationMetaData getMetaData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMetaData");
        }
        ConversationMetaData retValue = this.connChannel.getMetaData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)retValue);
        }
        return retValue;
    }

    @Override
    protected boolean isInbound() {
        return false;
    }

    @Override
    protected ConversationImpl startNewConversation(ConversationImpl conv) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"startNewConversation", (Object)conv);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"startNewConversation");
        }
        throw new SIErrorException();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("OutboundConnection@").append(Integer.toHexString(System.identityHashCode(this)));
        buf.append(": {");
        buf.append("Remote Address: ");
        buf.append(this.remoteHostAddress);
        buf.append(", Chain: ");
        buf.append(this.chainName);
        buf.append(", Heartbeat Timeout: ");
        buf.append(this.getHeartbeatTimeoutForToString());
        buf.append(", Heartbeat Interval: ");
        buf.append(this.getHeartbeatIntervalForToString());
        buf.append(", Handshake Complete: ");
        buf.append(this.handshakeComplete);
        buf.append(", Handshakers Waiting: ");
        buf.append(this.handshakersWaiting);
        buf.append(", Using Netty Framework: ");
        buf.append(this.isUsingNetty());
        buf.append("}\nEvents follow:\n");
        buf.append(this.getDiagnostics(false));
        return buf.toString();
    }

    @Override
    public String getEyeCatcher() {
        return this.eyeCatcher;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source Info: @(#) 1.44 SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/OutboundConnection.java, SIB.comms, WASX.SIB, uu1215.01 11/09/22 03:41:21 [4/12/12 22:14:14]");
        }
    }
}

