/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel;

import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.jfapchannel.ConnectionClosedListener;
import com.ibm.ws.sib.jfapchannel.ConnectionInterface;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.ConversationUsageType;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.jfapchannel.ReceivedData;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.mfp.ConnectionSchemaSet;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;

public interface Conversation {
    public static final int PRIORITY_LOWEST = -1;
    public static final int PRIORITY_HIGHEST = 12;
    public static final int PRIORITY_LOW = 2;
    public static final int PRIORITY_HIGH = 11;
    public static final int PRIORITY_MEDIUM = 7;
    public static final int PRIORITY_HEARTBEAT = 15;
    public static final ConversationType CLIENT = new ConversationType("CLIENT");
    public static final ConversationType ME = new ConversationType("ME");
    public static final ConversationType UNKNOWN = new ConversationType("UNKNOWN");

    public void fastClose();

    public void close() throws SIConnectionLostException;

    public ReceivedData exchange(JFapByteBuffer var1, int var2, int var3, int var4, boolean var5) throws SIConnectionLostException, SIConnectionDroppedException;

    public long send(JFapByteBuffer var1, int var2, int var3, int var4, boolean var5, ThrottlingPolicy var6, SendListener var7) throws SIConnectionLostException, SIConnectionDroppedException;

    public boolean isFirst();

    public void handshakeComplete();

    public void handshakeFailed();

    public void setAttachment(Object var1);

    public Object getAttachment();

    public void setLinkLevelAttachment(Object var1);

    public Object getLinkLevelAttachment();

    public boolean sharesSameLinkAs(Conversation var1);

    public Conversation cloneConversation(ConversationReceiveListener var1) throws SIResourceException;

    public Conversation[] getConversationsSharingSameLink();

    public int getId();

    public void setHeartbeatInterval(int var1);

    public int getHeartbeatInterval();

    public void setHeartbeatTimeout(int var1);

    public int getHeartbeatTimeout();

    public void setMaxTransmissionSize(int var1);

    public int getMaxTransmissionSize();

    public ConversationMetaData getMetaData();

    public void setConversationType(ConversationType var1);

    public boolean isClosed();

    public void addConnectionClosedListener(ConnectionClosedListener var1, ConversationUsageType var2);

    public ConnectionClosedListener getConnectionClosedListener(ConversationUsageType var1);

    public void setHandshakeProperties(HandshakeProperties var1);

    public HandshakeProperties getHandshakeProperties();

    public ConnectionInterface getConnectionReference();

    public String getFullSummary();

    public void setDefaultReceiveListener(ConversationReceiveListener var1);

    public void setSchemaSet(ConnectionSchemaSet var1);

    public ConnectionSchemaSet getSchemaSet() throws SIConnectionDroppedException;

    public boolean checkRequestNumberIsFree(int var1);

    public static final class ConversationType {
        private String type;

        private ConversationType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }

    public static enum ThrottlingPolicy {
        BLOCK_THREAD,
        DISCARD_TRANSMISSION,
        DO_NOT_THROTTLE;

    }
}

