/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.AsyncCallbackSynchronizer;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.ConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.DestinationSessionProxy;
import com.ibm.ws.sib.comms.client.OrderingContextProxy;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.asynch.AsynchConsumerThreadPool;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ConversationHelper;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ConversationHelperImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ProxyQueueConversationGroupImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.AsynchConsumerQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.Queue;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.QueueData;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.ReadAheadQueue;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AsynchConsumerProxyQueueImpl
implements AsynchConsumerProxyQueue {
    private static final String CLASS_NAME = AsynchConsumerProxyQueueImpl.class.getName();
    private static final TraceComponent tc = SibTr.register(AsynchConsumerProxyQueueImpl.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    public static final String $sccsid = "@(#) 1.82 SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/impl/AsynchConsumerProxyQueueImpl.java, SIB.comms, WASX.SIB, uu1215.01 09/06/16 11:25:27 [4/12/12 22:14:07]";
    private OrderingContext currentOrderContext = null;
    private volatile AsynchConsumerCallback asynchConsumerCallback = null;
    private volatile int maxBatchSize;
    private int maxSequentialFailures;
    private long hiddenMessageDelay;
    protected boolean stoppable;
    private volatile ConversationHelper convHelper;
    private volatile Queue queue;
    private volatile boolean readAhead = false;
    protected volatile ConsumerSessionProxy consumerSession;
    private volatile short id;
    private volatile ProxyQueueConversationGroupImpl owningGroup;
    private ArrayList<Throwable> exceptionQueue = new ArrayList();
    private volatile short currentBatchNumber = 0;
    static final int READAHEAD = 1;
    static final int ASYNCH = 2;
    static final int ORDERED = 3;
    private volatile int type;
    private volatile Thread asynchConsumerThread;
    private volatile boolean _closed = false;
    private volatile boolean _started;
    private volatile boolean connectionDropped = false;
    private final StashSynchronizer stashSynchronizer = new StashSynchronizer();
    private final List<StashQueueEntry> stashQueue = Collections.synchronizedList(new LinkedList());
    private final ProxyQueueSynchronizer proxyQueueSynchronizerLock = new ProxyQueueSynchronizer();
    private volatile boolean stopping = false;
    private static final TraceComponent tc1;
    private static final TraceComponent tc2;
    private static final TraceComponent tc3;

    AsynchConsumerProxyQueueImpl(ProxyQueueConversationGroupImpl group, short id, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("group=" + group + ", id=" + id + ", conversation=" + conversation));
        }
        this.owningGroup = group;
        if (conversation != null) {
            this.convHelper = new ConversationHelperImpl(conversation, id);
        }
        this.id = id;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public JsMessage receiveNoWait(SITransaction transaction) throws MessageDecodeFailedException, SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receiveNoWait", (Object)("transaction=" + transaction));
        }
        throw new SIErrorException();
    }

    @Override
    public synchronized JsMessage receiveWithWait(long timeout, SITransaction transaction) throws MessageDecodeFailedException, SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receiveWithWait", (Object)("timeout=" + timeout + ", transaction=" + transaction));
        }
        throw new SIErrorException();
    }

    void setReadAhead(boolean b) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReadAhead", (Object)("b=" + b));
        }
        this.readAhead = b;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReadAhead");
        }
    }

    @Override
    public void setAsynchConsumerThread(Thread t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setAsynchConsumerThread", (Object)t);
        }
        this.asynchConsumerThread = t;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAsynchConsumerThread");
        }
    }

    void setConversationHelper(ConversationHelper h) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setConversationHelper", (Object)("convHelper=" + h));
        }
        this.convHelper = h;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setConversationHelper");
        }
    }

    void setQueue(Queue q) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setQueue", (Object)("q=" + q));
        }
        this.queue = q;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setQueue");
        }
    }

    void setId(short i) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setId", (Object)("i=" + i));
        }
        this.id = i;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setId");
        }
    }

    void setOwningGroup(ProxyQueueConversationGroupImpl g) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setOwningGroup", (Object)("g=" + g));
        }
        this.owningGroup = g;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setOwningGroup");
        }
    }

    void setType(int t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setType", (Object)("t=" + t));
        }
        this.type = t;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setType");
        }
    }

    @Override
    public int getBatchSize() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBatchSize");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBatchSize", (Object)this.maxBatchSize);
        }
        return this.maxBatchSize;
    }

    @Override
    public AsynchConsumerCallback getAsynchConsumerCallback() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAsynchConsumerCallback");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAsynchConsumerCallback", (Object)this.asynchConsumerCallback);
        }
        return this.asynchConsumerCallback;
    }

    @Override
    public Thread getAsynchConsumerThread() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAsynchConsumerThread");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAsynchConsumerThread", (Object)this.asynchConsumerThread);
        }
        return this.asynchConsumerThread;
    }

    @Override
    public DestinationSessionProxy getDestinationSessionProxy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDestinationSessionProxy");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDestinationSessionProxy", (Object)this.consumerSession);
        }
        return this.consumerSession;
    }

    @Override
    public ConsumerSessionProxy getConsumerSessionProxy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerSessionProxy");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerSessionProxy", (Object)this.consumerSession);
        }
        return this.consumerSession;
    }

    @Override
    public ConversationHelper getConversationHelper() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConversationHelper");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConversationHelper", (Object)this.convHelper);
        }
        return this.convHelper;
    }

    public Queue getQueue() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getQueue");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getQueue", (Object)this.queue);
        }
        return this.queue;
    }

    @Override
    public short getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getId");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getId", (Object)this.id);
        }
        return this.id;
    }

    @Override
    public short getCurrentMessageBatchSequenceNumber() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCurrentMessageBatchSequenceNumber");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCurrentMessageBatchSequenceNumber", (Object)this.currentBatchNumber);
        }
        return this.currentBatchNumber;
    }

    @Override
    public Object getLMEOperationMonitor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLMEOperationMonitor");
        }
        Object rc = this.consumerSession.getLMEMonitor();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLMEOperationMonitor", (Object)rc);
        }
        return rc;
    }

    int getType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getType");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getType", (Object)this.type);
        }
        return this.type;
    }

    @Override
    public boolean getStarted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getStarted");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getStarted", (Object)this._started);
        }
        return this._started;
    }

    boolean getClosed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getClosed");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getClosed", (Object)this._closed);
        }
        return this._closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(CommsByteBuffer msgBuffer, short msgBatch, boolean lastInBatch, boolean chunk) {
        block44: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"put", (Object)("msgBuffer=" + msgBuffer + ", msgBatch=" + msgBatch + ", lastInBatch=" + lastInBatch + ", chunk=" + chunk));
            }
            boolean stashSynchronizerLockedHeld = false;
            boolean proxyQueueSynchronizerLockHeld = false;
            try {
                stashSynchronizerLockedHeld = this.stashSynchronizer.enter();
                try {
                    proxyQueueSynchronizerLockHeld = this.proxyQueueSynchronizerLock.tryLock(false);
                    if (proxyQueueSynchronizerLockHeld) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Putting msg to proxy queue");
                        }
                        stashSynchronizerLockedHeld = this.stashSynchronizer.exit();
                        AsynchConsumerProxyQueueImpl asynchConsumerProxyQueueImpl = this;
                        synchronized (asynchConsumerProxyQueueImpl) {
                            if (!this._closed) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Async consumer is not closed - will put msg");
                                }
                                if (msgBatch == this.currentBatchNumber) {
                                    Queue queue = this.queue;
                                    synchronized (queue) {
                                        boolean wasEmpty = this.queue.isEmpty(this.id);
                                        if (chunk) {
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Dealing with a chunked message");
                                            }
                                            byte flags = msgBuffer.get();
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Flags=" + flags));
                                            }
                                            if ((flags & 1) == 1) {
                                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"First chunk received");
                                                }
                                                QueueData queueData = new QueueData(this, lastInBatch, chunk, msgBuffer);
                                                this.queue.put(queueData, msgBatch);
                                            } else {
                                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Middle/Last chunk received");
                                                }
                                                boolean lastChunk = (flags & 4) == 4;
                                                this.queue.appendToLastMessage(msgBuffer, lastChunk);
                                            }
                                        } else {
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Dealing with the entire message");
                                            }
                                            QueueData queueData = new QueueData(this, lastInBatch, chunk, msgBuffer);
                                            this.queue.put(queueData, msgBatch);
                                        }
                                        if (wasEmpty) {
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Queue was previously empty");
                                            }
                                            this.nudge();
                                        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Queue was not previously empty");
                                        }
                                    }
                                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Received data for msgbatch: " + msgBatch + " when we are expecting " + this.currentBatchNumber + " put will be ignored"));
                                }
                            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Async consumer is closed - will ignore msg put");
                            }
                        }
                        proxyQueueSynchronizerLockHeld = this.proxyQueueSynchronizerLock.unlock();
                        break block44;
                    }
                    if (!this._closed) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Putting msg to stash queue");
                        }
                        this.stashQueue.add(new StashQueueEntry(msgBuffer, msgBatch, lastInBatch, chunk));
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Async consumer is closed - will ignore msg put");
                    }
                    stashSynchronizerLockedHeld = this.stashSynchronizer.exit();
                }
                finally {
                    if (proxyQueueSynchronizerLockHeld) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Tidy up of proxyQueueSynchronizerLock required");
                        }
                        this.proxyQueueSynchronizerLock.unlock();
                    }
                }
            }
            finally {
                if (stashSynchronizerLockedHeld) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Tidy up of stashSynchronizer required");
                    }
                    this.stashSynchronizer.exit();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"put");
        }
    }

    @Override
    public void setConsumerSession(ConsumerSessionProxy cs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setConsumerSession", (Object)("consumerSession=" + cs));
        }
        if (this.consumerSession != null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("RESET_OF_CONSUMER_SESSION_SICO1055", null, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".setConsumerSession"), (String)"2-011-0001", (Object)this);
            throw e;
        }
        if (cs == null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("NULL_CONSUMER_SESSION_SICO1056", null, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".setConsumerSession"), (String)"2-011-0002", (Object)this);
            throw e;
        }
        this.consumerSession = cs;
        this.convHelper.setSessionId(this.consumerSession.getProxyID());
        this.processExceptions();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setConsumerSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliverException(Throwable exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deliverException", (Object)("exception=" + exception));
        }
        ArrayList<Throwable> arrayList = this.exceptionQueue;
        synchronized (arrayList) {
            this.exceptionQueue.add(exception);
        }
        this.processExceptions();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deliverException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExceptions() {
        block13: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"processExceptions");
            }
            if (this.consumerSession == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"No consumer session has been set yet, doing nothing");
                }
            } else {
                try {
                    SICoreConnection conn = ((ClientConversationState)this.owningGroup.getConversation().getAttachment()).getSICoreConnection();
                    SICoreConnectionListener[] listeners = conn.getConnectionListeners();
                    ArrayList<Throwable> arrayList = this.exceptionQueue;
                    synchronized (arrayList) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Core connection has " + listeners.length + " listeners"));
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Exception queue has " + this.exceptionQueue.size() + " exception(s) on it"));
                        }
                        for (int x = 0; x < listeners.length; ++x) {
                            for (int y = 0; y < this.exceptionQueue.size(); ++y) {
                                Throwable exception = this.exceptionQueue.get(y);
                                listeners[x].asynchronousException((ConsumerSession)this.consumerSession, exception);
                            }
                        }
                        this.exceptionQueue.clear();
                    }
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".processExceptions"), (String)"2-011-0003", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                    SibTr.debug((TraceComponent)tc, (String)"Failed to get the conversation from the proxy queue", (Object)((Object)e));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processExceptions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void closing() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"closing");
        }
        this._started = false;
        this._closed = true;
        Object object = this.queue.getConcurrentAccessLock();
        synchronized (object) {
            this.queue.purge(this.id);
        }
        this.notify();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"closing");
        }
    }

    @Override
    public void closed() throws SIConnectionDroppedException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"closed");
        }
        this.convHelper.closeSession();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"closed");
        }
    }

    @Override
    public synchronized void start() throws SIConnectionDroppedException, SIConnectionLostException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start");
        }
        this.checkConversationLive();
        this._started = true;
        if (this.asynchConsumerCallback == null) {
            this.notify();
        } else if (!this.queue.isEmpty(this.id)) {
            AsynchConsumerThreadPool.getInstance().dispatch(this);
        } else if (!this.readAhead) {
            this.convHelper.sendStart();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    @Override
    public void stopping(boolean notifypeer) throws SISessionDroppedException, SIConnectionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stopping", (Object)("notifypeer=" + notifypeer));
        }
        this.stopping = true;
        if (!this.readAhead) {
            if (notifypeer) {
                this.convHelper.exchangeStop();
            }
            this.queue.waitUntilEmpty(this.id);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stopping");
        }
    }

    @Override
    public boolean isStopping() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isStopping");
        }
        boolean rc = this.stopping;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isStopping", (Object)("rc=" + rc));
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopped() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stopped");
        }
        this.stopping = false;
        Object object = this.queue.getConcurrentAccessLock();
        synchronized (object) {
            this._started = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsynchCallback(AsynchConsumerCallback callback, int maxActiveMessages, long messageLockExpiry, int maxBatchSize, OrderingContext orderContext, int maxSequentialFailures, long hiddenMessageDelay, boolean stoppable) throws SISessionDroppedException, SIConnectionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setAsynchCallback", (Object)new Object[]{callback, maxActiveMessages, messageLockExpiry, maxBatchSize, orderContext, maxSequentialFailures, hiddenMessageDelay, stoppable});
        }
        boolean proxyQueueSynchronizerLockHeld = false;
        try {
            proxyQueueSynchronizerLockHeld = this.proxyQueueSynchronizerLock.lock(true);
            AsynchConsumerProxyQueueImpl asynchConsumerProxyQueueImpl = this;
            synchronized (asynchConsumerProxyQueueImpl) {
                this._setAsynchCallback(callback, maxActiveMessages, messageLockExpiry, maxBatchSize, orderContext, maxSequentialFailures, hiddenMessageDelay, stoppable);
                proxyQueueSynchronizerLockHeld = this.proxyQueueSynchronizerLock.unlock();
                this.stashSynchronizer.waitNoPutters();
                while (!this.stashQueue.isEmpty()) {
                    StashQueueEntry entry = this.stashQueue.remove(0);
                    this.put(entry.getMsgBuffer(), entry.getMsgBatch(), entry.getLastInBatch(), entry.getChunk());
                }
            }
        }
        finally {
            if (proxyQueueSynchronizerLockHeld) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Tidy up of proxyQueueSynchronizerLock required");
                }
                this.proxyQueueSynchronizerLock.unlock();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAsynchCallback");
        }
    }

    private void _setAsynchCallback(AsynchConsumerCallback callback, int maxActiveMessages, long messageLockExpiry, int maxBatchSize, OrderingContext orderContext, int maxSequentialFailures, long hiddenMessageDelay, boolean stoppable) throws SISessionDroppedException, SIConnectionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_setAsynchCallback", (Object)new Object[]{callback, maxActiveMessages, messageLockExpiry, maxBatchSize, orderContext, maxSequentialFailures, hiddenMessageDelay, stoppable});
        }
        this.checkConversationLive();
        if (callback == null) {
            if (!this.readAhead) {
                this.convHelper.unsetAsynchConsumer(stoppable);
                this.owningGroup.notifyClose(this);
            }
            this.currentOrderContext = null;
            this.asynchConsumerCallback = null;
            this.maxBatchSize = 0;
            this.maxSequentialFailures = 0;
            this.hiddenMessageDelay = 0L;
            this.stoppable = stoppable;
        } else if (this.asynchConsumerCallback != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Performing a re-registration");
            }
            if (this.readAhead) {
                orderContext = null;
            }
            if (this.currentOrderContext != null && orderContext == null || this.currentOrderContext == null && orderContext != null || this.currentOrderContext != orderContext || this.maxBatchSize != maxBatchSize || this.stoppable != stoppable || this.stoppable && stoppable && this.maxSequentialFailures != maxSequentialFailures || this.stoppable && stoppable && this.hiddenMessageDelay != hiddenMessageDelay) {
                if (this.currentOrderContext != null && orderContext == null) {
                    this.type = 2;
                } else if (this.currentOrderContext == null && orderContext != null) {
                    this.type = 3;
                }
                try {
                    this.unlockAll();
                }
                catch (SIResourceException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".setAsynchCallback"), (String)"2-006-0004", (Object)this);
                    throw new SIErrorException((Throwable)e);
                }
                this.convHelper.unsetAsynchConsumer(stoppable);
                this.queue = this.obtainQueue(this.type, orderContext, null);
                this.convHelper.setAsynchConsumer(callback, maxActiveMessages, messageLockExpiry, maxBatchSize, orderContext, maxSequentialFailures, hiddenMessageDelay, stoppable);
            }
            this.currentOrderContext = orderContext;
            this.asynchConsumerCallback = callback;
            this.maxBatchSize = maxBatchSize;
            this.maxSequentialFailures = maxSequentialFailures;
            this.hiddenMessageDelay = hiddenMessageDelay;
            this.stoppable = stoppable;
        } else {
            this.asynchConsumerCallback = callback;
            this.currentOrderContext = orderContext;
            this.maxBatchSize = maxBatchSize;
            this.maxSequentialFailures = maxSequentialFailures;
            this.hiddenMessageDelay = hiddenMessageDelay;
            this.stoppable = stoppable;
            if (!this.readAhead) {
                this.convHelper.setAsynchConsumer(callback, maxActiveMessages, messageLockExpiry, maxBatchSize, orderContext, maxSequentialFailures, hiddenMessageDelay, stoppable);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_setAsynchCallback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Queue obtainQueue(int queueType, OrderingContext oc, Reliability unrecoverableReliability) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"obtainQueue", (Object)("queueType=" + queueType + ", oc=" + oc + ", unrecoverableReliability=" + unrecoverableReliability));
        }
        Queue q = null;
        if (queueType == 1) {
            q = new ReadAheadQueue(this.id, this.convHelper, unrecoverableReliability);
        } else if (queueType == 2) {
            q = new AsynchConsumerQueue(false);
        } else {
            OrderingContext orderingContext = oc;
            synchronized (orderingContext) {
                OrderingContextProxy ocp = (OrderingContextProxy)oc;
                q = ocp.getAssociatedQueue();
                if (q == null) {
                    q = new AsynchConsumerQueue(true);
                    ocp.associateWithQueue(q);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"obtainQueue", (Object)q);
        }
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliverMessages() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deliverMessages");
        }
        Object object = this.consumerSession.getCallbackLock();
        synchronized (object) {
            block14: {
                try {
                    SICoreConnection conn = ((ClientConversationState)this.owningGroup.getConversation().getAttachment()).getSICoreConnection();
                    AsyncCallbackSynchronizer asyncCallbackSynchronizer = ((ConnectionProxy)conn).getAsyncCallbackSynchronizer();
                    asyncCallbackSynchronizer.enterAsyncMessageCallback();
                    try {
                        Object object2 = this.queue.getConcurrentAccessLock();
                        synchronized (object2) {
                            if (this._started && !this.queue.isEmpty(this.id)) {
                                this.queue.deliverBatch(this.maxBatchSize, this.id, this.convHelper);
                            }
                        }
                    }
                    finally {
                        asyncCallbackSynchronizer.exitAsyncMessageCallback();
                    }
                }
                catch (SIIncorrectCallException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".deliverMessages"), (String)"2-011-0004", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block14;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Failed to obtain the AsyncCallbackSynchronizer object");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deliverMessages");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockAll() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
        boolean proxyQueueSynchronizerLockHeld = false;
        try {
            proxyQueueSynchronizerLockHeld = this.proxyQueueSynchronizerLock.lock(true);
            AsynchConsumerProxyQueueImpl asynchConsumerProxyQueueImpl = this;
            synchronized (asynchConsumerProxyQueueImpl) {
                this._unlockAll();
                proxyQueueSynchronizerLockHeld = this.proxyQueueSynchronizerLock.unlock();
                this.stashSynchronizer.waitNoPutters();
                while (!this.stashQueue.isEmpty()) {
                    StashQueueEntry entry = this.stashQueue.remove(0);
                    this.put(entry.getMsgBuffer(), entry.getMsgBatch(), entry.getLastInBatch(), entry.getChunk());
                }
            }
        }
        finally {
            if (proxyQueueSynchronizerLockHeld) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Tidy up of proxyQueueSynchronizerLock required");
                }
                this.proxyQueueSynchronizerLock.unlock();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
    }

    private void _unlockAll() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_unlockall");
        }
        this.checkConversationLive();
        this.currentBatchNumber = (short)(this.currentBatchNumber + 1);
        this.queue.purge(this.id);
        this.queue.unlockAll();
        this.convHelper.unlockAll();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_unlockall");
        }
    }

    @Override
    public synchronized void nudge() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"nudge");
        }
        if (this._started) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Queue is started");
            }
            if (!this.queue.isEmpty(this.id)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Queue is not empty for sessionId=" + this.id));
                }
                if (this.asynchConsumerCallback != null) {
                    AsynchConsumerThreadPool.getInstance().dispatch(this);
                } else {
                    this.notifyAll();
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Queue is empty for sessionId=" + this.id));
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Async consumer is not started - no initiation action will be taken to process the put message");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"nudge");
        }
    }

    @Override
    public synchronized void conversationDroppedNotification() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"conversationDroppedNotification");
        }
        this.connectionDropped = true;
        this.notifyAll();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"conversationDroppedNotification");
        }
    }

    void checkConversationLive() throws SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"checkConversationLive");
        }
        if (this.connectionDropped) {
            throw new SIConnectionDroppedException(nls.getFormattedMessage("CONVERSATION_CLOSED_SICO0068", null, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"checkConversationLive");
        }
    }

    public String toString() {
        return this.getClass() + "@" + Integer.toHexString(this.hashCode()) + ": " + this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackOccurred() throws SISessionDroppedException, SIConnectionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollbackOccurred");
        }
        Object object = this.queue.getConcurrentAccessLock();
        synchronized (object) {
            this.unlockAll();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollbackOccurred");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source Info: @(#) 1.82 SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/impl/AsynchConsumerProxyQueueImpl.java, SIB.comms, WASX.SIB, uu1215.01 09/06/16 11:25:27 [4/12/12 22:14:07]");
        }
        tc1 = SibTr.register(StashSynchronizer.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
        tc2 = SibTr.register(StashQueueEntry.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
        tc3 = SibTr.register(ProxyQueueSynchronizer.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    }

    private final class StashSynchronizer {
        private int putters = 0;

        private StashSynchronizer() {
        }

        synchronized boolean enter() {
            if (TraceComponent.isAnyTracingEnabled() && tc1.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc1, (String)"enter", (Object)("putters=" + this.putters));
            }
            ++this.putters;
            if (TraceComponent.isAnyTracingEnabled() && tc1.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc1, (String)"enter", (Object)("putters=" + this.putters));
            }
            return true;
        }

        synchronized boolean exit() {
            if (TraceComponent.isAnyTracingEnabled() && tc1.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc1, (String)"exit", (Object)("putters=" + this.putters));
            }
            if (--this.putters == 0) {
                this.notifyAll();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc1.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc1, (String)"exit", (Object)("putters=" + this.putters));
            }
            return false;
        }

        synchronized void waitNoPutters() {
            if (TraceComponent.isAnyTracingEnabled() && tc1.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc1, (String)"waitNoPutters", (Object)("putters=" + this.putters));
            }
            if (this.putters != 0) {
                while (true) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc1.isDebugEnabled()) continue;
                        SibTr.exception((Object)this, (TraceComponent)tc1, (Exception)e);
                        continue;
                    }
                    break;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc1.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc1, (String)"waitNoPutters");
            }
        }
    }

    private final class ProxyQueueSynchronizer {
        int locks = 0;
        boolean exclusive;
        Thread thread;

        private ProxyQueueSynchronizer() {
        }

        synchronized boolean lock(boolean excl) {
            if (TraceComponent.isAnyTracingEnabled() && tc3.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc3, (String)"lock");
            }
            while (!this.tryLock(excl)) {
                if (TraceComponent.isAnyTracingEnabled() && tc3.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc3, (String)"Waiting for lock...");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (TraceComponent.isAnyTracingEnabled() && tc3.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc3, (String)"lock", (Object)"rc=true");
            }
            return true;
        }

        synchronized boolean unlock() {
            if (TraceComponent.isAnyTracingEnabled() && tc3.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc3, (String)"unlock");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc3.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc3, (String)("locks=" + this.locks + ", exclusive=" + this.exclusive));
            }
            if (--this.locks == 0) {
                this.thread = null;
                this.notifyAll();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc3.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc3, (String)("locks=" + this.locks + ", exclusive=" + this.exclusive));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc3.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc3, (String)"unlock", (Object)"rc=false");
            }
            return false;
        }

        synchronized boolean tryLock(boolean excl) {
            if (TraceComponent.isAnyTracingEnabled() && tc3.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc3, (String)"tryLock", (Object)("excl=" + excl));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc3.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc3, (String)("locks=" + this.locks + ", exclusive=" + this.exclusive));
            }
            boolean rc = true;
            if (this.locks == 0) {
                ++this.locks;
                this.exclusive = excl;
                this.thread = this.exclusive ? Thread.currentThread() : null;
            } else if (!this.exclusive && !excl) {
                ++this.locks;
            } else if (this.exclusive && this.thread.equals(Thread.currentThread())) {
                ++this.locks;
            } else {
                rc = false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc3.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc3, (String)("locks=" + this.locks + ", exclusive=" + this.exclusive));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc3.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc3, (String)"tryLock", (Object)("rc=" + rc));
            }
            return rc;
        }
    }

    private final class StashQueueEntry {
        private final CommsByteBuffer msgBuffer;
        private final short msgBatch;
        private final boolean lastInBatch;
        private final boolean chunk;

        StashQueueEntry(CommsByteBuffer msgBuffer, short msgBatch, boolean lastInBatch, boolean chunk) {
            if (TraceComponent.isAnyTracingEnabled() && tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc2, (String)"<init>", (Object)("msgBuffer=" + msgBuffer + ", msgBatch=" + msgBatch + ", lastInBatch=" + lastInBatch + ", chunk=" + chunk));
            }
            this.msgBuffer = msgBuffer;
            this.msgBatch = msgBatch;
            this.lastInBatch = lastInBatch;
            this.chunk = chunk;
            if (TraceComponent.isAnyTracingEnabled() && tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc2, (String)"<init>");
            }
        }

        CommsByteBuffer getMsgBuffer() {
            return this.msgBuffer;
        }

        short getMsgBatch() {
            return this.msgBatch;
        }

        boolean getLastInBatch() {
            return this.lastInBatch;
        }

        boolean getChunk() {
            return this.chunk;
        }
    }
}

