/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.netty;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBufferPool;
import com.ibm.ws.sib.utils.ras.SibTr;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class NettyToWsBufferDecoder
extends ByteToMessageDecoder {
    private static final TraceComponent tc = SibTr.register(NettyToWsBufferDecoder.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        byte[] bytes;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"decode", (Object)ctx.channel());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"decode", (Object)(ctx.channel().remoteAddress() + " decoding message [ " + in.toString(StandardCharsets.UTF_8) + " ] from Netty ByteBuf to WSByteBuffer"));
        }
        ByteBuf temp = in.readBytes(in.readableBytes());
        int length = temp.readableBytes();
        if (temp.hasArray()) {
            bytes = temp.array();
            int offset = temp.arrayOffset();
        } else {
            bytes = new byte[length];
            temp.getBytes(temp.readerIndex(), bytes);
            boolean offset = false;
        }
        out.add(WsByteBufferPool.getInstance().wrap(bytes).position(in.readerIndex()));
        temp.release();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"decode", (Object)ctx.channel());
        }
    }

    public void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"decodeLast", (Object)ctx.channel());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"decodeLast", (Object)(ctx.channel().remoteAddress() + " calling decode "));
        }
        this.decode(ctx, in, out);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"decodeLast", (Object)ctx.channel());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"exceptionCaught", (Object)new Object[]{cause, ctx.channel()});
        }
        super.exceptionCaught(ctx, cause);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"exceptionCaught", (Object)new Object[]{cause, ctx.channel()});
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/netty/jfapchannel/NettyToWsBufferDecoder.java, SIB.comms, WASX.SIB, uu1215.01 1.1");
        }
    }
}

