/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.webapp;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.webcontainer.async.FragmentResponse;
import com.ibm.ws.webcontainer.webapp.WebAppRequestDispatcher;
import com.ibm.wsspi.ard.JspFragmentResponse;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SyncFragmentResponse
implements FragmentResponse,
JspFragmentResponse {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.webapp");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.webapp.SyncFragmentResponse";
    private WebAppRequestDispatcher dispatcher;

    public SyncFragmentResponse(WebAppRequestDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public void insertFragment(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "insertFragment", "about to execute synchronous include");
        }
        this.dispatcher.include(req, resp);
    }

    @Override
    public void insertFragmentBlocking(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "insertFragmentBlocking", "about to execute synchronous include");
        }
        this.dispatcher.include(req, resp);
    }

    @Override
    public void insertFragmentFromJsp(ServletRequest req, ServletResponse resp, PrintWriter pw) throws ServletException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "insertFragmentFromJsp", "about to execute synchronous include");
        }
        SyncResponseWrapper sw = new SyncResponseWrapper((HttpServletResponse)resp, pw);
        this.dispatcher.include(req, (ServletResponse)sw);
    }

    @Override
    public void insertFragmentBlockingFromJsp(ServletRequest req, ServletResponse resp, PrintWriter pw) throws ServletException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "insertFragmentBlockingFromJsp", "calling insertFragmentFromJsp");
        }
        this.insertFragmentFromJsp(req, resp, pw);
    }

    protected class SyncResponseWrapper
    extends HttpServletResponseWrapper {
        private PrintWriter pw;

        public SyncResponseWrapper(HttpServletResponse resp, PrintWriter pw) {
            super(resp);
            this.pw = pw;
        }

        public PrintWriter getWriter() {
            return this.pw;
        }
    }
}

