/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.RemoteAsyncResult;
import com.ibm.ejs.container.RemoteAsyncResultExtended;
import com.ibm.ws.ejb.portable.Constants;
import com.ibm.ws.ejb.portable.LoggerHelper;
import jakarta.ejb.EJBException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.CORBA_2_3.portable.InputStream;

public class ClientAsyncResult
implements Future,
Serializable {
    private static final long serialVersionUID = -2495785869614768234L;
    private static final String CLASS_NAME = ClientAsyncResult.class.getName();
    private static final Logger svLogger = LoggerHelper.getLogger(CLASS_NAME, "EJBContainer");
    public static final String disableAsyncResultRetries = "com.ibm.websphere.ejbcontainer.disableAsyncResultRetries";
    public static final boolean DisableAsyncResultRetries = Boolean.getBoolean("com.ibm.websphere.ejbcontainer.disableAsyncResultRetries");
    public static final String asyncResultNoResponseBackoff = "com.ibm.websphere.ejbcontainer.asyncResultNoResponseBackoff";
    public static final long AsyncResultNoResponseBackoff = TimeUnit.SECONDS.toMillis(Integer.getInteger("com.ibm.websphere.ejbcontainer.asyncResultNoResponseBackoff", 30).intValue());
    private static final long MIN_ASYNC_RESULT_NO_RESPONSE_WAIT_TIME = TimeUnit.SECONDS.toMillis(1L);
    private transient RemoteAsyncResult ivServer = null;
    private final boolean ivServerExtended;
    private transient boolean ivUseServerExtended;
    private transient Object ivResult = null;
    private transient boolean ivDone = false;
    private transient CancellationException ivCancellationException = null;
    private transient ExecutionException ivExecutionException = null;
    private transient boolean ivBusinessRmiRemote = false;

    private EJBException initCause(EJBException ex) {
        if (ex.getCause() == null) {
            ex.initCause((Throwable)ex.getCausedByException());
        }
        return ex;
    }

    public ClientAsyncResult(RemoteAsyncResult serverImpl, boolean businessRmiRemote) {
        this.ivServer = serverImpl;
        this.ivBusinessRmiRemote = businessRmiRemote;
        this.ivServerExtended = serverImpl instanceof RemoteAsyncResultExtended;
    }

    public String toString() {
        return super.toString() + "[rmi=" + this.ivBusinessRmiRemote + ", done=" + this.ivDone + ", exception=" + (this.ivExecutionException != null) + ", cancelled=" + (this.ivCancellationException != null) + ", extended=" + this.ivUseServerExtended + ']';
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean isTraceOn = svLogger.isLoggable(Level.FINER);
        if (isTraceOn) {
            svLogger.entering(CLASS_NAME, "cancel", new Object[]{this.toString(), mayInterruptIfRunning});
        }
        boolean cancelled = false;
        try {
            boolean bl = cancelled = this.ivServer != null ? this.ivServer.cancel(mayInterruptIfRunning) : false;
            if (cancelled) {
                this.ivCancellationException = new CancellationException();
                this.ivDone = true;
                this.ivServer = null;
            }
        }
        catch (RemoteException e) {
            EJBException ejbEx = this.initCause(new EJBException((Exception)e));
            if (isTraceOn) {
                svLogger.exiting(CLASS_NAME, "cancel", ejbEx);
            }
            throw ejbEx;
        }
        if (isTraceOn) {
            svLogger.exiting(CLASS_NAME, "cancel", cancelled);
        }
        return cancelled;
    }

    @Override
    public boolean isCancelled() {
        if (svLogger.isLoggable(Level.FINER)) {
            svLogger.logp(Level.FINER, CLASS_NAME, "isCancelled", this.toString());
        }
        return this.ivCancellationException != null;
    }

    public Object get() throws ExecutionException, InterruptedException {
        boolean isTraceOn = svLogger.isLoggable(Level.FINER);
        if (isTraceOn) {
            svLogger.entering(CLASS_NAME, "get", this.toString());
        }
        if (this.ivCancellationException != null) {
            if (isTraceOn) {
                svLogger.exiting(CLASS_NAME, "get", this.ivCancellationException);
            }
            throw this.ivCancellationException;
        }
        if (this.ivExecutionException != null) {
            if (isTraceOn) {
                svLogger.exiting(CLASS_NAME, "get", this.ivExecutionException);
            }
            throw this.ivExecutionException;
        }
        try {
            if (this.ivResult == null && this.ivServer != null) {
                if (this.ivUseServerExtended) {
                    try {
                        this.ivResult = this.waitForResult(0L);
                    }
                    catch (TimeoutException ex) {
                        IllegalStateException ise = new IllegalStateException(ex);
                        if (isTraceOn) {
                            svLogger.exiting(CLASS_NAME, "get", ise);
                        }
                        throw ise;
                    }
                } else {
                    if (isTraceOn) {
                        svLogger.logp(Level.FINER, CLASS_NAME, "get", "calling stub.get()");
                    }
                    this.ivResult = this.ivServer.get();
                }
                this.ivServer = null;
            }
        }
        catch (ExecutionException ee) {
            this.ivExecutionException = ee;
            this.ivServer = null;
            if (isTraceOn) {
                svLogger.exiting(CLASS_NAME, "get", ee);
            }
            throw ee;
        }
        catch (RemoteException e) {
            if (isTraceOn) {
                svLogger.logp(Level.FINER, CLASS_NAME, "get", "caught RemoteException", e);
            }
            this.ivServer = null;
            if (this.ivBusinessRmiRemote) {
                this.ivExecutionException = new ExecutionException(e);
            } else {
                Throwable cause = e.getCause();
                EJBException ejbEx = this.initCause(new EJBException(cause instanceof Exception ? (Exception)cause : e));
                this.ivExecutionException = new ExecutionException((Throwable)ejbEx);
            }
            if (isTraceOn) {
                svLogger.exiting(CLASS_NAME, "get", this.ivExecutionException);
            }
            throw this.ivExecutionException;
        }
        if (isTraceOn) {
            svLogger.exiting(CLASS_NAME, "get", "result");
        }
        return this.ivResult;
    }

    public Object get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        boolean isTraceOn = svLogger.isLoggable(Level.FINER);
        if (isTraceOn) {
            svLogger.entering(CLASS_NAME, "get", new Object[]{this.toString(), timeout, unit});
        }
        if (this.ivCancellationException != null) {
            if (isTraceOn) {
                svLogger.exiting(CLASS_NAME, "get", this.ivCancellationException);
            }
            throw this.ivCancellationException;
        }
        if (this.ivExecutionException != null) {
            if (isTraceOn) {
                svLogger.exiting(CLASS_NAME, "get", this.ivExecutionException);
            }
            throw this.ivExecutionException;
        }
        try {
            if (this.ivResult == null && this.ivServer != null) {
                long millis = unit.toMillis(timeout);
                if (this.ivUseServerExtended && millis > 0L) {
                    this.ivResult = this.waitForResult(millis);
                } else {
                    if (isTraceOn) {
                        svLogger.logp(Level.FINER, CLASS_NAME, "get", "calling stub.get(long, String)");
                    }
                    this.ivResult = this.ivServer.get(timeout, unit.toString());
                }
                this.ivServer = null;
            }
        }
        catch (ExecutionException ee) {
            this.ivExecutionException = ee;
            this.ivServer = null;
            if (isTraceOn) {
                svLogger.exiting(CLASS_NAME, "get", ee);
            }
            throw ee;
        }
        catch (RemoteException e) {
            if (isTraceOn) {
                svLogger.logp(Level.FINER, CLASS_NAME, "get", "caught RemoteException", e);
            }
            this.ivServer = null;
            if (this.ivBusinessRmiRemote) {
                this.ivExecutionException = new ExecutionException(e);
            } else {
                Throwable cause = e.getCause();
                EJBException ejbEx = this.initCause(new EJBException(cause instanceof Exception ? (Exception)cause : e));
                this.ivExecutionException = new ExecutionException((Throwable)ejbEx);
            }
            if (isTraceOn) {
                svLogger.exiting(CLASS_NAME, "get", this.ivExecutionException);
            }
            throw this.ivExecutionException;
        }
        if (isTraceOn) {
            svLogger.exiting(CLASS_NAME, "get", "result");
        }
        return this.ivResult;
    }

    private Object waitForResult(long timeoutMillis) throws ExecutionException, InterruptedException, TimeoutException, RemoteException {
        long begin;
        boolean isTraceOn = svLogger.isLoggable(Level.FINER);
        if (isTraceOn) {
            svLogger.entering(CLASS_NAME, "waitForResult", timeoutMillis);
        }
        long beginLastAttempt = begin = System.nanoTime();
        long end = begin + TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
        boolean noResponse = false;
        long waitTimeMillis = timeoutMillis;
        long maxWaitTimeMillis = -1L;
        while (true) {
            Object[] resultArray;
            if (isTraceOn) {
                svLogger.entering(CLASS_NAME, "waitForResult", "waiting " + waitTimeMillis);
            }
            try {
                resultArray = this.stubWaitForResult((Stub)this.ivServer, waitTimeMillis);
            }
            catch (RemoteException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof NO_RESPONSE && !noResponse) {
                    if (isTraceOn) {
                        svLogger.logp(Level.FINER, CLASS_NAME, "waitForResult", "retrying", cause);
                    }
                    resultArray = null;
                    noResponse = true;
                }
                if (isTraceOn) {
                    svLogger.exiting(CLASS_NAME, "waitForResult", ex);
                }
                throw ex;
            }
            if (resultArray != null) {
                if (isTraceOn) {
                    svLogger.exiting(CLASS_NAME, "waitForResult", "result");
                }
                return resultArray[0];
            }
            long now = System.nanoTime();
            if (timeoutMillis > 0L) {
                long remainingMillis = TimeUnit.NANOSECONDS.toMillis(end - now);
                if (remainingMillis <= 0L) {
                    if (isTraceOn) {
                        svLogger.exiting(CLASS_NAME, "waitForResult", "timeout");
                    }
                    throw new TimeoutException();
                }
                waitTimeMillis = remainingMillis;
            }
            if (noResponse) {
                if (maxWaitTimeMillis == -1L) {
                    long actualWaitTimeMillis = TimeUnit.NANOSECONDS.toMillis(now - beginLastAttempt);
                    maxWaitTimeMillis = Math.max(MIN_ASYNC_RESULT_NO_RESPONSE_WAIT_TIME, actualWaitTimeMillis - AsyncResultNoResponseBackoff);
                }
                waitTimeMillis = timeoutMillis == 0L ? maxWaitTimeMillis : Math.min(waitTimeMillis, maxWaitTimeMillis);
            }
            beginLastAttempt = now;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] stubWaitForResult(Stub stub, long waitTime) throws ExecutionException, InterruptedException, RemoteException {
        ServantObject so;
        while (true) {
            if (!Util.isLocal((Stub)stub)) {
                InputStream in = null;
                try {
                    OutputStream out = stub._request("waitForResult", true);
                    out.write_longlong(waitTime);
                    in = (InputStream)stub._invoke(out);
                    Object[] objectArray = (Object[])in.read_value(Object[].class);
                    stub._releaseReply((org.omg.CORBA.portable.InputStream)in);
                    return objectArray;
                }
                catch (ApplicationException ex) {
                    try {
                        in = (InputStream)ex.getInputStream();
                        String id = in.read_string();
                        if (id.equals("IDL:java/util/concurrent/ExecutionEx:1.0")) {
                            throw (ExecutionException)in.read_value(ExecutionException.class);
                        }
                        if (!id.equals("IDL:java/lang/InterruptedEx:1.0")) throw new UnexpectedException(id);
                        throw (InterruptedException)in.read_value(InterruptedException.class);
                        catch (RemarshalException ex2) {
                        }
                    }
                    catch (SystemException ex3) {
                        throw Util.mapSystemException((SystemException)ex3);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    stub._releaseReply(in);
                }
                continue;
            }
            so = stub._servant_preinvoke("waitForResult", RemoteAsyncResultExtended.class);
            if (so != null) break;
        }
        try {
            Object[] result = ((RemoteAsyncResultExtended)so.servant).waitForResult(waitTime);
            Object[] id = (Object[])Util.copyObject((Object)result, (ORB)stub._orb());
            return id;
        }
        catch (Throwable ex) {
            Throwable exCopy = (Throwable)Util.copyObject((Object)ex, (ORB)stub._orb());
            if (exCopy instanceof ExecutionException) {
                throw (ExecutionException)exCopy;
            }
            if (!(exCopy instanceof InterruptedException)) throw Util.wrapException((Throwable)exCopy);
            throw (InterruptedException)exCopy;
        }
        finally {
            stub._servant_postinvoke(so);
        }
    }

    @Override
    public boolean isDone() {
        boolean isTraceOn = svLogger.isLoggable(Level.FINER);
        if (isTraceOn) {
            svLogger.entering(CLASS_NAME, "isDone", this.toString());
        }
        try {
            if (!this.ivDone) {
                this.ivDone = this.ivServer != null ? this.ivServer.isDone() : true;
            }
        }
        catch (RemoteException e) {
            throw this.initCause(new EJBException((Exception)e));
        }
        if (isTraceOn) {
            svLogger.exiting(CLASS_NAME, "isDone", this.ivDone);
        }
        return this.ivDone;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (svLogger.isLoggable(Level.FINER)) {
            svLogger.logp(Level.FINER, CLASS_NAME, "writeObject", this.toString());
        }
        if (this.ivServer == null) {
            throw new EJBException("No Server side Future object exists.");
        }
        out.defaultWriteObject();
        out.write(Constants.CLIENT_ASYNC_RESULT_EYE_CATCHER);
        out.writeShort(1);
        out.writeShort(1);
        out.writeObject(this.ivServer);
        out.writeBoolean(this.ivBusinessRmiRemote);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean isTraceOn = svLogger.isLoggable(Level.FINER);
        if (isTraceOn) {
            svLogger.entering(CLASS_NAME, "readObject");
        }
        in.defaultReadObject();
        byte[] ec = new byte[4];
        byte[] eyecatcher = Constants.CLIENT_ASYNC_RESULT_EYE_CATCHER;
        int bytesRead = 0;
        for (int offset = 0; offset < 4; offset += bytesRead) {
            bytesRead = in.read(ec, offset, 4 - offset);
            if (bytesRead != -1) continue;
            throw new IOException("end of input stream while reading eye catcher");
        }
        for (int i = 0; i < eyecatcher.length; ++i) {
            if (eyecatcher[i] == ec[i]) continue;
            String eyeCatcherString = Arrays.toString(ec);
            throw new IOException("Invalid eye catcher '" + eyeCatcherString + "' in ClientAsyncResult input stream");
        }
        short incoming_platform = in.readShort();
        short incoming_vid = in.readShort();
        this.ivServer = (RemoteAsyncResult)PortableRemoteObject.narrow((Object)in.readObject(), RemoteAsyncResult.class);
        this.ivBusinessRmiRemote = in.readBoolean();
        boolean bl = this.ivUseServerExtended = this.ivServerExtended && !DisableAsyncResultRetries && !Util.isLocal((Stub)((Stub)this.ivServer));
        if (isTraceOn) {
            svLogger.exiting(CLASS_NAME, "readObject", this.toString() + ", platform=" + incoming_platform + ", version=" + incoming_vid + ", extended=" + this.ivServerExtended + ", server=" + this.ivServer);
        }
    }
}

