/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.AbstractSessionData;
import com.ibm.ws.session.SessionContext;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.SessionManagerRegistry;
import com.ibm.ws.session.store.memory.MemorySession;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.webcontainer.httpsession.SessionManager;
import com.ibm.wsspi.session.IGenericSessionManager;
import jakarta.servlet.http.HttpSession;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;

public class SessionContextRegistry {
    protected static Hashtable scrSessionContexts = null;
    protected static boolean initialized = false;
    protected static SessionContextRegistry scrInstance = null;
    protected static boolean _globalSessionContext = false;
    public static final String NO_BACKEND_UPDATE_FLAG = "*";
    public static final String UTF8 = "UTF-8";
    private static final String methodClassName = "SessionContextRegistry";
    protected static final int INITIALIZE = 0;
    protected static final int GET_SESSION_CONTEXT = 1;
    protected static final int CREATE_SESSION_CONTEXT = 2;
    protected static final int INVALIDATE_ALL = 3;
    protected static final String[] methodNames = new String[]{"initialize", "getSessionContext", "createSessionContext", "invalidateAll"};
    protected final SessionManager smgr;

    public SessionContextRegistry(SessionManager smgr) {
        scrSessionContexts = new Hashtable(1);
        this.smgr = smgr;
    }

    public static SessionContextRegistry getInstance() {
        return scrInstance;
    }

    protected synchronized void initialize() {
        if (initialized) {
            return;
        }
        scrSessionContexts = new Hashtable();
        scrInstance = this;
        SessionManagerConfig smc = this.getServerSMC();
        _globalSessionContext = SessionManagerConfig.getServlet21SessionCompatibility();
        if (_globalSessionContext) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.INFO, methodClassName, methodNames[0], "SessionContextRegistry.globalSessionsEnabled");
            if (LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.WARNING)) {
                if (smc.getEnableTimeBasedWrite()) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, methodNames[0], "SessionContextRegistry.globalSessionTBWWarning");
                }
                if (smc.isUsingMemtoMem()) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, methodNames[0], "SessionContextRegistry.globalSessionM2MWarning");
                }
            }
        }
        initialized = true;
    }

    public static String getTrackerData() {
        Enumeration vEnum = scrSessionContexts.elements();
        StringBuffer bigStrbuf = new StringBuffer();
        bigStrbuf.append("<center><h3>Session Tracking Internals</h3></center><UL>\n");
        while (vEnum.hasMoreElements()) {
            SessionContext localContext = (SessionContext)vEnum.nextElement();
            String contextData = localContext.toHTML();
            bigStrbuf.append(contextData).append("</UL>\n");
        }
        return bigStrbuf.toString();
    }

    public static synchronized void remove(String appname) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "remove", appname);
        }
        scrSessionContexts.remove(appname);
    }

    public static Enumeration getScrSessionContexts() {
        return scrSessionContexts.elements();
    }

    public SessionManagerConfig getServerSMC() {
        return this.smgr.getServerConfig();
    }

    public void invalidateAll(String sessionId, String appName, AbstractSessionData sd, boolean goRemote, boolean fromRemote) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            StringBuffer sb = new StringBuffer("for app ").append(appName).append(" id ").append(sessionId).append(" goRemote ").append(goRemote).append(" fromRemote ").append(fromRemote);
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[3], sb.toString());
        }
        boolean backendUpdate = true;
        if (sessionId.startsWith(NO_BACKEND_UPDATE_FLAG)) {
            backendUpdate = false;
            sessionId = sessionId.substring(1);
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[3], "setting backendUpdate to false and removed flag - sessionId: " + sessionId);
            }
        }
        if (sd != null && sd.getISession() != null && !((MemorySession)sd.getISession()).isInvalInProgress()) {
            sd.invalidate();
        }
        Enumeration vEnum = SessionContextRegistry.getScrSessionContexts();
        while (vEnum.hasMoreElements()) {
            SessionContext context = (SessionContext)vEnum.nextElement();
            if (fromRemote) {
                context.remoteInvalidate(sessionId, backendUpdate);
                continue;
            }
            if (sd.getSessCtx() == context) continue;
            context.invalidate(sessionId);
        }
        if (SessionManagerConfig.getUsingApplicationSessionsAndInvalidateAll()) {
            Enumeration vEnumManagers = SessionManagerRegistry.getSessionManagerRegistry().getSessionManagers();
            while (vEnumManagers.hasMoreElements()) {
                IGenericSessionManager manager = (IGenericSessionManager)vEnumManagers.nextElement();
                this.callInvalidateAllOnApplicationSessionManager(manager, sessionId, backendUpdate, fromRemote);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[3]);
        }
    }

    protected void callInvalidateAllOnApplicationSessionManager(IGenericSessionManager manager, String sessionId, boolean backendUpdate, boolean fromRemote) {
    }

    public void setPropertiesInSMC(SessionManagerConfig _smc) {
        if (_smc.isDebugSessionCrossover() && SessionContext.currentThreadSacHashtable == null) {
            SessionContext.currentThreadSacHashtable = new WSThreadLocal();
        }
    }

    public HttpSession getHttpSessionById(String virtualHost, String contextRoot, String sessionId) {
        return null;
    }
}

