/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.ClientConnection;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.CompHandshake;
import com.ibm.ws.sib.comms.ComponentData;
import com.ibm.ws.sib.comms.ConnectionMetaData;
import com.ibm.ws.sib.comms.DirectConnection;
import com.ibm.ws.sib.comms.client.ConnectionMetaDataImpl;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.DirectConnectionImpl;
import com.ibm.ws.sib.comms.common.XidProxy;
import com.ibm.ws.sib.comms.server.CommonServerReceiveListener;
import com.ibm.ws.sib.comms.server.CommsServerByteBuffer;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.ConversationStateFullException;
import com.ibm.ws.sib.comms.server.ServerLinkLevelState;
import com.ibm.ws.sib.comms.server.TransactionToDispatchableMap;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.ServerSICoreConnectionListener;
import com.ibm.ws.sib.comms.server.clientsupport.ServerSideConnection;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATBrowser;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATDestination;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATProducer;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATSubscription;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATTransaction;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATXATransaction;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.DispatchToAllNonEmptyDispatchable;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.JFapConnectionBrokenException;
import com.ibm.ws.sib.jfapchannel.JFapHeartbeatTimeoutException;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.mfp.impl.CompHandshakeFactory;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.trm.attach.TrmSingleton;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.io.EOFException;
import java.util.NoSuchElementException;
import javax.security.auth.Subject;
import javax.transaction.xa.Xid;

public class ServerTransportReceiveListener
extends CommonServerReceiveListener
implements ConversationReceiveListener {
    private static String CLASS_NAME = ServerTransportReceiveListener.class.getName();
    private static final TraceComponent tc = SibTr.register(ServerTransportReceiveListener.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static ServerTransportReceiveListener instance;

    public static ServerTransportReceiveListener getInstance() {
        return instance;
    }

    private ServerTransportReceiveListener() {
        super(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConversationReceiveListener dataReceived(WsByteBuffer data, int segmentType, int requestNumber, int priority, boolean allocatedFromBufferPool, boolean partOfExchange, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dataReceived");
        }
        AuditManager auditManager = new AuditManager();
        auditManager.setJMSConversationMetaData((Object)conversation.getMetaData());
        CommsServerByteBuffer buffer = this.poolManager.allocate();
        buffer.reset(data);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String LF = System.lineSeparator();
            String debugInfo = LF + LF + "-------------------------------------------------------" + LF;
            debugInfo = debugInfo + " Segment type  : " + JFapChannelConstants.getSegmentName((int)segmentType) + " - " + segmentType + " (0x" + Integer.toHexString(segmentType) + ")" + LF;
            debugInfo = debugInfo + " Request number: " + requestNumber + LF;
            debugInfo = debugInfo + " Priority      : " + priority + LF;
            debugInfo = debugInfo + " Exchange?     : " + partOfExchange + LF;
            debugInfo = debugInfo + " From pool?    : " + allocatedFromBufferPool + LF;
            debugInfo = debugInfo + " Conversation  : " + conversation + LF;
            debugInfo = debugInfo + "-------------------------------------------------------" + LF;
            SibTr.debug((Object)this, (TraceComponent)tc, (String)debugInfo);
            SibTr.debug((Object)this, (TraceComponent)tc, (String)conversation.getFullSummary());
        }
        try {
            switch (segmentType) {
                case 6: {
                    this.rcvHandshake(buffer, conversation, requestNumber, allocatedFromBufferPool);
                    return null;
                }
                case 8: {
                    this.rcvTRMExchange(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 9: {
                    this.rcvMFPExchange(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 12: {
                    this.rcvDirectConnect(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 230: {
                    this.rcvMFPSchema(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 52: {
                    StaticCATXATransaction.rcvXACommit(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 50: {
                    StaticCATXATransaction.rcvXAEnd(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 55: {
                    StaticCATXATransaction.rcvXAForget(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 48: {
                    StaticCATXATransaction.rcvXAOpen(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 51: {
                    StaticCATXATransaction.rcvXAPrepare(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 54: {
                    StaticCATXATransaction.rcvXARecover(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 53: {
                    StaticCATXATransaction.rcvXARollback(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 49: {
                    StaticCATXATransaction.rcvXAStart(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 56: {
                    StaticCATXATransaction.rcvXA_getTxTimeout(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 57: {
                    StaticCATXATransaction.rcvXA_setTxTimeout(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 64: {
                    StaticCATConnection.rcvCloseConnection(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 99: {
                    StaticCATConnection.rcvCloneConnection(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 65: {
                    StaticCATDestination.rcvCreateTempDestination(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 66: {
                    StaticCATDestination.rcvDeleteTempDestination(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 101: {
                    StaticCATDestination.rcvGetDestinationConfiguration(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 67: {
                    StaticCATSubscription.rcvCreateDurableSub(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 68: {
                    StaticCATSubscription.rcvDeleteDurableSub(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 69: {
                    StaticCATProducer.rcvSendConnMsg(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 70: {
                    StaticCATProducer.rcvSendConnMsgNoReply(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 71: {
                    StaticCATConnection.rcvReceiveConnMsg(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 72: {
                    StaticCATProducer.rcvCreateProducerSess(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 73: {
                    StaticCATConsumer.rcvCloseConsumerSess(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 74: {
                    StaticCATProducer.rcvCloseProducerSess(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 75: {
                    StaticCATProducer.rcvSendSessMsg(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 76: {
                    StaticCATProducer.rcvSendSessMsgNoReply(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 77: {
                    StaticCATConsumer.rcvCreateConsumerSess(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 78: {
                    StaticCATConsumer.rcvSessReceive(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 79: {
                    StaticCATConsumer.rcvRequestMsgs(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 80: {
                    StaticCATTransaction.rcvCreateUCTransaction(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 81: {
                    StaticCATTransaction.rcvCommitTransaction(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 82: {
                    StaticCATTransaction.rcvRollbackTransaction(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 83: 
                case 121: {
                    StaticCATConsumer.rcvRegisterAsyncConsumer(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange, segmentType == 121);
                    return null;
                }
                case 84: 
                case 122: {
                    StaticCATConsumer.rcvDeregisterAsyncConsumer(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange, segmentType == 122);
                    return null;
                }
                case 85: 
                case 124: {
                    StaticCATConsumer.rcvStartSess(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange, segmentType == 124);
                    return null;
                }
                case 86: {
                    StaticCATConsumer.rcvStopSess(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 87: {
                    StaticCATConsumer.rcvFlushSess(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 88: {
                    StaticCATConsumer.rcvUnlockAll(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 89: 
                case 104: {
                    StaticCATConsumer.rcvUnlockSet(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 90: 
                case 91: {
                    StaticCATConsumer.rcvDeleteSet(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 95: {
                    StaticCATBrowser.rcvCreateBrowserSess(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 96: {
                    StaticCATBrowser.rcvResetBrowse(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 100: {
                    StaticCATConnection.rcvGetUniqueId(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 102: {
                    StaticCATSubscription.rcvCreateConsumerForDurableSub(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 106: {
                    StaticCATConsumer.rcvReadAndDeleteSet(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 105: {
                    StaticCATConsumer.rcvReadSet(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 103: {
                    StaticCATConsumer.rcvCreateBifurcatedSess(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 107: {
                    StaticCATConnection.rcvCreateOrderContext(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 108: {
                    StaticCATDestination.rcvSendToExceptionDest(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 109: {
                    StaticCATConnection.rcvCloseOrderContext(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 110: {
                    this.rcvMFPRequestSchema(buffer, conversation, requestNumber, segmentType, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 111: {
                    StaticCATConnection.rcvCheckMessagingRequired(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 112: {
                    StaticCATConnection.rcvInvokeCommand(buffer, conversation, requestNumber, allocatedFromBufferPool, false);
                    return null;
                }
                case 113: {
                    StaticCATConnection.rcvInvokeCommand(buffer, conversation, requestNumber, allocatedFromBufferPool, true);
                    return null;
                }
                case 114: 
                case 115: {
                    StaticCATProducer.rcvSendChunkedSessMsg(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 116: 
                case 117: {
                    StaticCATProducer.rcvSendChunkedConnMsg(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 118: {
                    StaticCATDestination.rcvSendChunkedToExceptionDest(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 119: {
                    StaticCATConnection.rcvAddDestinationListener(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 131: {
                    StaticCATConnection.rcvAddConsumerMonitorListener(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                case 134: {
                    StaticCATConsumer.rcvUnlockAllWithUnlockCountFlag(buffer, conversation, requestNumber, allocatedFromBufferPool, partOfExchange);
                    return null;
                }
                default: {
                    String nlsText = nls.getFormattedMessage("INVALID_PROP_SICO8011", new Object[]{"" + segmentType}, null);
                    SIConnectionLostException commsException = new SIConnectionLostException(nlsText);
                    if (partOfExchange) {
                        StaticCATHelper.sendExceptionToClient(commsException, null, conversation, requestNumber);
                    }
                    if (allocatedFromBufferPool) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"releasing WsByteBuffer");
                        }
                        buffer.release();
                    }
                    this.closeConnection(conversation);
                    return null;
                }
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".dataReceived"), (String)"3-004-0013", (Object[])new Object[]{buffer.getDumpReceivedBytes(128), this});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an exception: ", (Object)t);
            }
            if (!partOfExchange) return null;
            StaticCATHelper.sendExceptionToClient(t, "3-004-0013", conversation, requestNumber);
            return null;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"dataReceived");
            }
        }
    }

    public void errorOccurred(SIConnectionLostException exception, int segmentType, int requestNumber, int priority, Conversation conversation) {
        Throwable cause;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"errorOccurred", (Object)new Object[]{exception, "" + segmentType, "" + requestNumber, "" + priority, conversation});
        }
        if ((cause = exception.getCause()) != null && cause instanceof JFapHeartbeatTimeoutException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error is due to heartbeat timeout");
            }
        } else if (exception instanceof JFapConnectionBrokenException && null != cause && cause instanceof EOFException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error is due to reaching the end of stream during a read");
            }
            System.out.println("Connection unexpectedly broken during read.");
        } else {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".errorOccurred"), (String)"3-004-0010", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Object[] debug = new Object[]{"Segment type  : " + segmentType + " (0x" + Integer.toHexString(segmentType) + ")", "Request number: " + requestNumber, "Priority      : " + priority};
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received an error in the ServerTransportReceiveListener", (Object)debug);
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Primary exception:", (Object)((Object)exception));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"errorOccurred");
        }
    }

    protected void cleanupConnection(Conversation conversation) {
        ConversationState convState;
        ServerSideConnection serverSideConn;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cleanupConnection", (Object)conversation);
        }
        if ((serverSideConn = (ServerSideConnection)(convState = (ConversationState)conversation.getAttachment()).getCommsConnection()) != null) {
            serverSideConn.failed();
        }
        Object obj = null;
        int x = 10;
        while (true) {
            block9: {
                try {
                    obj = convState.removeObject(x);
                    if (obj instanceof CATConnection) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Found a CATConnection at position " + x + " in object store"));
                        }
                        CATConnection catConnection = (CATConnection)obj;
                        ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
                        linkState.getTransactionTable().rollbackTxWithoutCompletionDirection(conversation);
                        SICoreConnection connection = catConnection.getSICoreConnection();
                        connection.removeConnectionListener((SICoreConnectionListener)linkState.getSICoreConnectionListener());
                        connection.close();
                        linkState.getSICoreConnectionListener().removeSICoreConnection(connection);
                        linkState.getSICoreConnectionTable().remove(conversation.getId());
                        linkState.getTransactionTable().removeTransactions(conversation, linkState.getDispatchableMap());
                    }
                }
                catch (NoSuchElementException e) {
                    break;
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".cleanupConnection"), (String)"3-004-0011", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to close SI connection", (Object)((Object)e));
                }
            }
            ++x;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cleanupConnection");
        }
    }

    @Override
    public void closeConnection(Conversation conversation) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"closeConnection");
            }
            try {
                conversation.close();
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rejectHandshake"), (String)"3-004-0016", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to close the conversation", (Object)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"closeConnection");
        }
    }

    public Dispatchable getThreadContext(Conversation conversation, WsByteBuffer data, int segmentType) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getThreadContext", (Object)new Object[]{conversation, data, "" + segmentType});
        }
        Dispatchable dispatchable = null;
        int transactionId = 0;
        int messageOrderId = 0;
        CommsServerByteBuffer buffer = this.poolManager.allocate();
        buffer.reset(data);
        ConversationState convState = (ConversationState)conversation.getAttachment();
        HandshakeProperties handshakeProperties = conversation.getHandshakeProperties();
        switch (segmentType) {
            case 64: 
            case 73: 
            case 74: 
            case 86: 
            case 88: 
            case 109: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Processing Session stop, close / Unlock All");
                }
                try {
                    dispatchable = DispatchToAllNonEmptyDispatchable.getInstance();
                    break;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getThreadContext"), (String)"3-004-0023", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to create dispatchable", (Object)e);
                    }
                    throw new SIErrorException(nls.getFormattedMessage("UNABLE_TO_CREATE_DISPATCH_TO_ALL_SICO2054", null, null), (Throwable)e);
                }
            }
        }
        if (dispatchable == null) {
            switch (segmentType) {
                case 80: {
                    TransactionToDispatchableMap map = ((ServerLinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    buffer.getShort();
                    int clientTxId = buffer.getInt();
                    dispatchable = map.addDispatchableForLocalTransaction(clientTxId);
                    break;
                }
                case 48: 
                case 54: {
                    dispatchable = null;
                    break;
                }
                case 49: {
                    TransactionToDispatchableMap map = ((ServerLinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    int clientXAResourceId = buffer.getInt();
                    Xid xid = buffer.getXid();
                    dispatchable = map.addEnlistedDispatchableForGlobalTransaction(clientXAResourceId, (XidProxy)xid);
                    if (dispatchable != null) break;
                    SIErrorException exception = new SIErrorException("3-004-0023");
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".getThreadContext"), (String)"3-004-0023", (Object[])new Object[]{map, this});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                    }
                    throw exception;
                }
                case 51: {
                    TransactionToDispatchableMap map = ((ServerLinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    int clientXAResourceId = buffer.getInt();
                    Xid xid = buffer.getXid();
                    dispatchable = map.getDispatchable(clientXAResourceId);
                    break;
                }
                case 52: 
                case 53: 
                case 55: {
                    TransactionToDispatchableMap map = ((ServerLinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    int clientXAResourceId = buffer.getInt();
                    Xid xid = buffer.getXid();
                    dispatchable = map.removeDispatchableForGlobalTransaction(clientXAResourceId, (XidProxy)xid);
                    break;
                }
                case 50: {
                    TransactionToDispatchableMap map = ((ServerLinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    int clientXAResourceId = buffer.getInt();
                    Xid xid = buffer.getXid();
                    dispatchable = map.getDispatchable(clientXAResourceId);
                    break;
                }
                case 56: 
                case 57: {
                    TransactionToDispatchableMap map = ((ServerLinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    int clientXAResourceId = buffer.getInt();
                    dispatchable = map.getDispatchable(clientXAResourceId);
                    break;
                }
                case 71: 
                case 108: 
                case 113: 
                case 118: {
                    boolean requiresOptimizedTransactions;
                    boolean bl = requiresOptimizedTransactions = handshakeProperties.getFapLevel() >= 5 && (handshakeProperties.getCapabilites() & 0x40) != 0;
                    if (requiresOptimizedTransactions) {
                        TransactionToDispatchableMap map = ((ServerLinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                        buffer.getShort();
                        int txFlags = buffer.getInt();
                        buffer.getInt();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("txFlags=" + txFlags));
                        }
                        if ((txFlags & 1) == 0) {
                            dispatchable = null;
                            break;
                        }
                        transactionId = buffer.getInt();
                        if ((txFlags & 4) != 0) {
                            if ((txFlags & 2) != 0) {
                                dispatchable = map.addDispatchableForOptimizedLocalTransaction(transactionId);
                                break;
                            }
                            if ((txFlags & 8) != 0) {
                                buffer.getInt();
                            }
                            Xid xid = buffer.getXid();
                            dispatchable = map.addEnlistedDispatchableForGlobalTransaction(transactionId, (XidProxy)xid);
                            break;
                        }
                        dispatchable = map.getDispatchable(transactionId);
                        break;
                    }
                    buffer.getShort();
                    int clientXAResourceId = buffer.getInt();
                    if (clientXAResourceId == 0) {
                        dispatchable = null;
                        break;
                    }
                    TransactionToDispatchableMap map = ((ServerLinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    dispatchable = map.getDispatchable(clientXAResourceId);
                    if (dispatchable != null) break;
                    SIErrorException exception = new SIErrorException("3-004-0023");
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".getThreadContext"), (String)"3-004-0023", (Object[])new Object[]{map, this});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                    }
                    throw exception;
                }
                case 69: 
                case 70: 
                case 75: 
                case 76: 
                case 78: 
                case 90: 
                case 91: 
                case 106: 
                case 114: 
                case 115: 
                case 116: 
                case 117: {
                    boolean requiresOptimizedTransactions;
                    boolean bl = requiresOptimizedTransactions = handshakeProperties.getFapLevel() >= 5 && (handshakeProperties.getCapabilites() & 0x40) != 0;
                    if (requiresOptimizedTransactions) {
                        TransactionToDispatchableMap map = ((ServerLinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                        buffer.getInt();
                        int txFlags = buffer.getInt();
                        buffer.getInt();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("txFlags=" + txFlags));
                        }
                        if ((txFlags & 1) == 0) {
                            dispatchable = null;
                            break;
                        }
                        transactionId = buffer.getInt();
                        if ((txFlags & 4) != 0) {
                            if ((txFlags & 2) != 0) {
                                dispatchable = map.addDispatchableForOptimizedLocalTransaction(transactionId);
                                break;
                            }
                            if ((txFlags & 8) != 0) {
                                buffer.getInt();
                            }
                            Xid xid = buffer.getXid();
                            dispatchable = map.addEnlistedDispatchableForGlobalTransaction(transactionId, (XidProxy)xid);
                            break;
                        }
                        dispatchable = map.getDispatchable(transactionId);
                        break;
                    }
                    buffer.getInt();
                    transactionId = buffer.getInt();
                    if (transactionId == 0) {
                        dispatchable = null;
                        break;
                    }
                    TransactionToDispatchableMap map = ((ServerLinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    dispatchable = map.getDispatchable(transactionId);
                    break;
                }
                case 81: 
                case 82: {
                    buffer.getShort();
                    transactionId = buffer.getInt();
                    if (transactionId == 0) {
                        dispatchable = null;
                        break;
                    }
                    TransactionToDispatchableMap map = ((ServerLinkLevelState)conversation.getLinkLevelAttachment()).getDispatchableMap();
                    dispatchable = map.removeDispatchableForLocalTransaction(transactionId);
                    if (dispatchable != null) break;
                    SIErrorException exception = new SIErrorException("3-004-0023");
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".getThreadContext"), (String)"3-004-0023", (Object[])new Object[]{map, this});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                    }
                    throw exception;
                }
            }
            if (dispatchable == null) {
                buffer.rewind();
                switch (segmentType) {
                    case 69: 
                    case 70: 
                    case 72: {
                        buffer.getShort();
                        messageOrderId = buffer.getShort();
                        break;
                    }
                    case 83: {
                        buffer.getShort();
                        buffer.getShort();
                        messageOrderId = buffer.getShort();
                    }
                }
                if (messageOrderId != 0) {
                    dispatchable = (Dispatchable)convState.getObject(messageOrderId);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getThreadContext", (Object)dispatchable);
        }
        return dispatchable;
    }

    private void rcvTRMExchange(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rcvTRMExchange", (Object)new Object[]{request, conversation, requestNumber, allocatedFromBufferPool, partOfExchange});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        TrmSingleton trm = TrmSingleton.getTrmSingleton();
        ComponentData cd = (ComponentData)trm.getComponentData();
        ClientConnection cc = (ClientConnection)convState.getCommsConnection();
        if (convState.getCommsConnection() == null) {
            cc = new ServerSideConnection(conversation);
            convState.setCommsConnection((CommsConnection)cc);
        }
        try {
            byte[] trmRequestData = request.getRemaining();
            byte[] trmReplyData = cd.handShake(cc, trmRequestData);
            if (cc.getSICoreConnection() != null) {
                ((MPCoreConnection)cc.getSICoreConnection()).setMessageCopiedWhenSent(false);
                ((MPCoreConnection)cc.getSICoreConnection()).setMessageCopiedWhenReceived(false);
                convState.addObject(cc);
                this.sendConnectionInfo(conversation);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"TRM did not allocate us a connection");
            }
            CommsServerByteBuffer reply = this.poolManager.allocate();
            reply.wrap(trmReplyData);
            conversation.send((JFapByteBuffer)reply, 8, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
        }
        catch (ConversationStateFullException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvTRMExchange"), (String)"3-004-0003", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-004-0003", conversation, requestNumber);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvTRMExchange"), (String)"3-004-0004", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2019", (Object)((Object)e));
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rcvTRMExchange");
        }
    }

    private void rcvMFPExchange(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rcvMFPExchange", (Object)new Object[]{request, conversation, requestNumber, allocatedFromBufferPool, partOfExchange});
        }
        CompHandshake ch = null;
        ConversationState convState = (ConversationState)conversation.getAttachment();
        ServerSideConnection cc = new ServerSideConnection(conversation);
        convState.setCommsConnection((CommsConnection)cc);
        try {
            ch = (CompHandshake)CompHandshakeFactory.getInstance();
            byte[] mfpRequestData = request.getRemaining();
            HandshakeProperties handshakeGroup = conversation.getHandshakeProperties();
            short productVersion = handshakeGroup.getMajorVersion();
            byte[] mfpReplyData = ch.compHandshakeData((CommsConnection)cc, (int)productVersion, mfpRequestData);
            CommsServerByteBuffer reply = this.poolManager.allocate();
            reply.wrap(mfpReplyData);
            conversation.send((JFapByteBuffer)reply, 9, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvMFPExchange"), (String)"3-004-0018", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2019", (Object)((Object)e));
        }
        catch (Exception e1) {
            FFDCFilter.processException((Throwable)e1, (String)(CLASS_NAME + ".rcvMFPExchange"), (String)"3-004-0017", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"MFP unable to create CompHandshake Singleton", (Object)e1);
            }
            StaticCATHelper.sendExceptionToClient(e1, "3-004-0017", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rcvMFPExchange");
        }
    }

    private void rcvMFPSchema(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"rcvMFPSchema", (Object)new Object[]{request, conversation, requestNumber, allocatedFromBufferPool, partOfExchange});
            }
            CompHandshake ch = null;
            ConversationState convState = (ConversationState)conversation.getAttachment();
            CommsConnection cc = convState.getCommsConnection();
            try {
                ch = (CompHandshake)CompHandshakeFactory.getInstance();
                byte[] mfpRequestData = request.getRemaining();
                HandshakeProperties handshakeGroup = conversation.getHandshakeProperties();
                short productVersion = handshakeGroup.getMajorVersion();
                ch.compData(cc, (int)productVersion, mfpRequestData);
            }
            catch (Exception e1) {
                FFDCFilter.processException((Throwable)e1, (String)(CLASS_NAME + ".rcvMFPSchema"), (String)"3-004-0019", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"MFP unable to create CompHandshake Singleton", (Object)e1);
            }
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rcvMFPSchema");
        }
    }

    private void rcvMFPRequestSchema(CommsByteBuffer request, Conversation conversation, int requestNumber, int segmentId, boolean allocatedFromBufferPool, boolean partOfExchange) {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"rcvMFPRequestSchema", (Object)new Object[]{request, conversation, requestNumber, allocatedFromBufferPool, partOfExchange});
            }
            CompHandshake ch = null;
            ConversationState convState = (ConversationState)conversation.getAttachment();
            CommsConnection cc = convState.getCommsConnection();
            try {
                ch = (CompHandshake)CompHandshakeFactory.getInstance();
                byte[] mfpRequestData = request.getRemaining();
                HandshakeProperties handshakeGroup = conversation.getHandshakeProperties();
                short productVersion = handshakeGroup.getMajorVersion();
                byte[] mfpReplyData = ch.compRequest(cc, (int)productVersion, segmentId, mfpRequestData);
                if (mfpReplyData == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"MFP returned null");
                    }
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("MFP_SCHEMA_REQUEST_FAILED_SICO2056", null, null));
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvMFPRequestSchema"), (String)"3-004-0024", (Object)this);
                    StaticCATHelper.sendExceptionToClient((Throwable)e, null, conversation, requestNumber);
                } else {
                    CommsServerByteBuffer reply = this.poolManager.allocate();
                    reply.wrap(mfpReplyData);
                    try {
                        conversation.send((JFapByteBuffer)reply, 240, requestNumber, 12, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvMFPRequestSchema"), (String)"3-004-0025", (Object)this);
                        SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2019", (Object)((Object)e));
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvMFPRequestSchema"), (String)"3-004-0026", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"MFP unable to create CompHandshake Singleton", (Object)e);
            }
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rcvMFPRequestSchema");
        }
    }

    private void sendConnectionInfo(Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendConnectionInfo", (Object)conversation);
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        ClientConnection clientConnection = (ClientConnection)convState.getObject(10);
        SICoreConnection conn = null;
        try {
            String resolvedUserId;
            String meUuid;
            String meName;
            byte[] uniqueId;
            short connectionObjectId;
            block8: {
                conn = clientConnection.getSICoreConnection();
                connectionObjectId = 0;
                uniqueId = new byte[]{};
                meName = null;
                meUuid = null;
                resolvedUserId = null;
                try {
                    uniqueId = conn.createUniqueId();
                    CATConnection catConnection = new CATConnection(conn);
                    connectionObjectId = (short)convState.addObject(catConnection);
                    convState.setConnectionObjectId(connectionObjectId);
                    meName = conn.getMeName();
                    meUuid = conn.getMeUuid();
                    resolvedUserId = conn.getResolvedUserid();
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendConnectionInfo"), (String)"3-004-0008", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to get the unique ID", (Object)((Object)e));
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"SICoreConnection Id:", (Object)connectionObjectId);
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"ME Name:", (Object)meName);
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"ME UUId:", (Object)meUuid);
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Resolved User Id:", (Object)resolvedUserId);
            }
            CommsServerByteBuffer reply = this.poolManager.allocate();
            reply.putShort(connectionObjectId);
            reply.putString(meName);
            reply.putShort(uniqueId.length);
            reply.put(uniqueId);
            reply.putString(meUuid);
            reply.putString(resolvedUserId);
            conversation.send((JFapByteBuffer)reply, 226, 0, 11, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendConnectionInfo"), (String)"3-004-0006", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2019", (Object)((Object)e));
        }
        catch (ConversationStateFullException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendConnectionInfo"), (String)"3-004-0007", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_OBJECT_STORE_FULL_SICO2010", (Object)e);
        }
        this.attachConnectionListener(conversation, conn);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendConnectionInfo");
        }
    }

    private void attachConnectionListener(Conversation conversation, SICoreConnection conn) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"attachConnectionListener", (Object)new Object[]{conversation, conn});
            }
            ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
            ServerSICoreConnectionListener listener = linkState.getSICoreConnectionListener();
            listener.addSICoreConnection(conn, conversation);
            try {
                conn.addConnectionListener((SICoreConnectionListener)listener);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".attachConnectionListener"), (String)"3-004-0005", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to register connection listener", (Object)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"attachConnectionListener");
        }
    }

    private void rcvDirectConnect(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        Subject subject;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rcvDirectConnect", (Object)new Object[]{request, conversation, requestNumber, allocatedFromBufferPool, partOfExchange});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        String meName = request.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Me Name", (Object)meName);
        }
        String busName = request.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Bus Name", (Object)busName);
        }
        String userId = request.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"User Id", (Object)userId);
        }
        String password = request.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Password", (Object)"****");
        }
        if ((subject = new Subject()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Authentication failed");
            }
            StaticCATHelper.sendExceptionToClient((Throwable)new SIAuthenticationException(null), null, conversation, requestNumber);
        } else {
            TrmSingleton trmSingleton = TrmSingleton.getTrmSingleton();
            ComponentData componentData = (ComponentData)trmSingleton.getComponentData();
            ConnectionMetaDataImpl metaData = new ConnectionMetaDataImpl(conversation.getMetaData(), conversation.getHandshakeProperties());
            DirectConnectionImpl connProps = new DirectConnectionImpl((ConnectionMetaData)metaData);
            connProps.setBus(busName);
            connProps.setName(meName);
            boolean rc = componentData.directConnect((DirectConnection)connProps, subject);
            SICoreConnection conn = connProps.getSICoreConnection();
            if (!rc || conn == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"TRM did not allocate us a connection");
                }
                StaticCATHelper.sendExceptionToClient((Throwable)new SIResourceException(), null, conversation, requestNumber);
            } else {
                try {
                    ServerSideConnection cc = new ServerSideConnection(conversation);
                    convState.setCommsConnection((CommsConnection)cc);
                    convState.addObject((Object)cc);
                    short objId = (short)convState.addObject(new CATConnection(conn));
                    convState.setConnectionObjectId(objId);
                    cc.setSICoreConnection(conn);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"SICoreConnection object ID", (Object)("" + objId));
                    }
                    this.attachConnectionListener(conversation, conn);
                    byte[] idStem = conn.createUniqueId();
                    CommsServerByteBuffer reply = this.poolManager.allocate();
                    reply.putShort(objId);
                    reply.putShort((short)idStem.length);
                    reply.put(idStem);
                    try {
                        conversation.send((JFapByteBuffer)reply, 13, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".,rcvDirectConnect"), (String)"3-004-0021", (Object)this);
                        SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2019", (Object)((Object)e));
                    }
                }
                catch (ConversationStateFullException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".,rcvDirectConnect"), (String)"3-004-0020", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)e);
                    }
                    StaticCATHelper.sendExceptionToClient(e, "3-004-0020", conversation, requestNumber);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".,rcvDirectConnect"), (String)"3-004-0022", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                    }
                    StaticCATHelper.sendExceptionToClient(e, "3-004-0022", conversation, requestNumber);
                }
            }
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rcvDirectConnect");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/ServerTransportReceiveListener.java, SIB.comms, WASX.SIB, aa1225.01 1.173.1.2");
        }
        instance = new ServerTransportReceiveListener();
    }
}

