/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.tx.jta.embeddable.EmbeddableTransactionManagerFactory;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.impl.SibRaDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIMessageNotLockedException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import jakarta.transaction.Synchronization;

class SibRaSynchronizedDispatcher
extends SibRaDispatcher {
    private SITransaction _transaction;
    private boolean _transactionRolledBack = false;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaSynchronizedDispatcher.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String CLASS_NAME = SibRaSynchronizedDispatcher.class.getName();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";

    protected SibRaSynchronizedDispatcher(SibRaMessagingEngineConnection connection, AbstractConsumerSession session, SibRaEndpointActivation endpointActivation, Reliability unrecoveredReliability, int maxFailedDeliveries, int sequentialFailureThreshold) throws ResourceException {
        super(connection, session, endpointActivation, unrecoveredReliability, maxFailedDeliveries, sequentialFailureThreshold);
        String methodName = "SibRaSynchronizedDispatcher";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaSynchronizedDispatcher", (Object)new Object[]{connection, session, endpointActivation});
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaSynchronizedDispatcher");
        }
    }

    @Override
    protected SITransaction getTransaction() throws ResourceException {
        String methodName = "getTransaction";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getTransaction");
        }
        if (this._transaction == null) {
            try {
                this._transaction = this._connection.createUncoordinatedTransaction(false);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "getTransaction"), (String)FFDC_PROBE_1, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
                }
                throw new ResourceException(NLS.getFormattedMessage("UNCOORD_TRAN_CWSIV1201", new Object[]{this._connection, exception}, null), (Throwable)exception);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getTransaction", (Object)this._transaction);
        }
        return this._transaction;
    }

    @Override
    protected MessageEndpoint createEndpoint() throws ResourceException {
        String methodName = "createEndpoint";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createEndpoint");
        }
        MessageEndpoint endpoint = this._endpointFactory.createEndpoint(null);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createEndpoint", (Object)endpoint);
        }
        return endpoint;
    }

    @Override
    protected void beforeDelivery(MessageEndpoint endpoint) throws ResourceException {
        String methodName = "beforeDelivery";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery", (Object)endpoint);
        }
        try {
            endpoint.beforeDelivery(this._invoker.getEndpointMethod());
        }
        catch (NoSuchMethodException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "beforeDelivery"), (String)FFDC_PROBE_2, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("BEFORE_DELIVERY_CWSIV1200", new Object[]{exception, endpoint}, null), (Throwable)exception);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery");
        }
    }

    @Override
    protected void beforeDelivery(SIBusMessage message, MessageEndpoint endpoint) throws ResourceException {
        String methodName = "beforeDelivery";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery", (Object)new Object[]{message, endpoint});
        }
        this.beforeDelivery(endpoint);
        this.deleteMessage(message, this.getTransactionForDelete());
    }

    @Override
    protected SIBusMessage readMessage(SIMessageHandle handle) throws ResourceException, SIMessageNotLockedException {
        String methodName = "beforeDelivery";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery", (Object)handle);
        }
        SIBusMessage message = this.readAndDeleteMessage(handle, this.getTransactionForDelete());
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery", (Object)message);
        }
        return message;
    }

    private SITransaction getTransactionForDelete() throws ResourceException {
        SITransaction transaction;
        String methodName = "getTransactionForDelete";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getTransactionForDelete");
        }
        if ((transaction = this.getTransaction()) instanceof Synchronization) {
            try {
                EmbeddableWebSphereTransactionManager transactionManager = EmbeddableTransactionManagerFactory.getTransactionManager();
                UOWCoordinator coordinator = EmbeddableTransactionManagerFactory.getUOWCurrent().getUOWCoord();
                Synchronization synchronization = new Synchronization(){

                    public void beforeCompletion() {
                        ((Synchronization)transaction).beforeCompletion();
                    }

                    public void afterCompletion(int status) {
                        ((Synchronization)transaction).afterCompletion(status);
                        SibRaSynchronizedDispatcher.this._transactionRolledBack = 3 != status;
                    }
                };
                EmbeddableTransactionManagerFactory.getTransactionManager();
                transactionManager.registerSynchronization(coordinator, synchronization, 2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "getTransactionForDelete"), (String)FFDC_PROBE_3, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
                }
                throw new ResourceException(NLS.getFormattedMessage("REGISTER_SYNC_CWSIV1202", new Object[]{transaction, exception}, null), (Throwable)exception);
            }
        } else {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("SYNC_CWSIV1203", new Object[]{transaction, Synchronization.class.getName()}, null));
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getTransactionForDelete", (Object)transaction);
        }
        return transaction;
    }

    @Override
    protected void afterDelivery(SIBusMessage message, MessageEndpoint endpoint, boolean success) throws ResourceException {
        String methodName = "afterDelivery";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"afterDelivery", (Object)new Object[]{message, success});
        }
        this._transaction = null;
        endpoint.afterDelivery();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"afterDelivery");
        }
    }

    @Override
    protected void cleanup() {
        if (TRACE.isEntryEnabled()) {
            String methodName = "cleanup";
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"cleanup");
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"cleanup");
        }
    }

    @Override
    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator generator = super.getStringGenerator();
        generator.addField("transaction", this._transaction);
        return generator;
    }

    @Override
    protected boolean isTransactionRolledBack() {
        return this._transactionRolledBack;
    }
}

