/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.JspContext;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspFactory;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.el.ELException;
import jakarta.servlet.jsp.el.ExpressionEvaluator;
import jakarta.servlet.jsp.el.FunctionMapper;
import jakarta.servlet.jsp.el.VariableResolver;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jasper.el.ELContextImpl;
import org.apache.jasper.el.ExpressionEvaluatorImpl;
import org.apache.jasper.el.FunctionMapperImpl;
import org.apache.jasper.el.VariableResolverImpl;
import org.apache.jasper.runtime.BodyContentImpl;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.jasper.runtime.JspWriterImpl;
import org.apache.jasper.runtime.ProtectedFunctionMapper;
import org.apache.jasper.runtime.ServletResponseWrapperInclude;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class PageContextImpl
extends PageContext {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "org.apache.jasper.runtime.PageContextImpl";
    private VariableResolver variableResolver;
    private BodyContentImpl[] outs;
    private int depth;
    private Servlet servlet;
    private ServletConfig config;
    private ServletContext context;
    private JspFactory factory;
    private JspApplicationContextImpl applicationContext;
    private boolean needsSession;
    private String errorPageURL;
    private boolean autoFlush;
    private int bufferSize;
    private int bodyContentBufferSize;
    private transient HashMap attributes;
    private transient ServletRequest request;
    private transient ServletResponse response;
    private transient Object page;
    private transient HttpSession session;
    private boolean isIncluded;
    private transient ELContextImpl elContext;
    private transient JspWriter out;
    private transient JspWriterImpl baseOut;
    private boolean wasReleased;
    private boolean alreadyInitialized;
    static final long serialVersionUID = 8250913120652883230L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    PageContextImpl(JspFactory factory) {
        this(factory, 512);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{factory});
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "PageContextImpl", "PageContextImpl ctor 1 buffsize=[512]  this=[" + (Object)((Object)this) + "]");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    PageContextImpl(JspFactory factory, int bodyContentBufferSize) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{factory, bodyContentBufferSize});
        }
        this.wasReleased = false;
        this.alreadyInitialized = false;
        this.factory = factory;
        this.outs = new BodyContentImpl[0];
        this.attributes = new HashMap(16);
        this.depth = -1;
        this.bodyContentBufferSize = bodyContentBufferSize;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "PageContextImpl", "PageContextImpl ctor 2 buffsize=[" + this.bodyContentBufferSize + "]  this=[" + (Object)((Object)this) + "]");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "initialize", new Object[]{servlet, request, response, errorPageURL, needsSession, bufferSize, autoFlush});
        }
        this._initialize(servlet, request, response, errorPageURL, needsSession, bufferSize, autoFlush);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "initialize");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void _initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "_initialize", new Object[]{servlet, request, response, errorPageURL, needsSession, bufferSize, autoFlush});
        }
        this.wasReleased = false;
        if (this.alreadyInitialized) {
            logger.logp(Level.SEVERE, CLASS_NAME, "initialize", "jsp.error.pageContext.multipleInitOrRelease");
        }
        this.servlet = servlet;
        this.config = servlet.getServletConfig();
        this.context = this.config.getServletContext();
        this.needsSession = needsSession;
        this.errorPageURL = errorPageURL;
        this.bufferSize = bufferSize;
        this.autoFlush = autoFlush;
        this.request = request;
        this.response = response;
        this.applicationContext = JspApplicationContextImpl.getInstance(this.context);
        if (request instanceof HttpServletRequest && needsSession) {
            this.session = ((HttpServletRequest)request).getSession();
        }
        if (needsSession && this.session == null) {
            throw new IllegalStateException("Page needs a session and none is available");
        }
        this.depth = -1;
        if (this.baseOut == null) {
            this.baseOut = this._createOut(bufferSize, autoFlush);
        } else {
            this.baseOut.init(response, bufferSize, autoFlush);
        }
        this.out = this.baseOut;
        if (this.out == null) {
            throw new IllegalStateException("failed initialize JspWriter");
        }
        this.setAttribute("jakarta.servlet.jsp.jspOut", this.out);
        this.setAttribute("jakarta.servlet.jsp.jspRequest", request);
        this.setAttribute("jakarta.servlet.jsp.jspResponse", response);
        if (this.session != null) {
            this.setAttribute("jakarta.servlet.jsp.jspSession", this.session);
        }
        this.setAttribute("jakarta.servlet.jsp.jspPage", servlet);
        this.setAttribute("jakarta.servlet.jsp.jspConfig", this.config);
        this.setAttribute("jakarta.servlet.jsp.jspPageContext", (Object)this);
        this.setAttribute("jakarta.servlet.jsp.jspApplication", this.context);
        this.isIncluded = request.getAttribute("jakarta.servlet.include.servlet_path") != null;
        this.alreadyInitialized = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "_initialize");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void release() {
        block6: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering(CLASS_NAME, "release", new Object[0]);
            }
            if (this.wasReleased) {
                logger.logp(Level.SEVERE, CLASS_NAME, "release", "jsp.error.pageContext.multipleInitOrRelease");
            }
            this.out = this.baseOut;
            try {
                ((JspWriterImpl)this.out).flushBuffer();
            }
            catch (IOException ex) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) break block6;
                logger.logp(Level.WARNING, CLASS_NAME, "release", "failed to flush response buffer during PageContext.release().", ex);
            }
        }
        this.servlet = null;
        this.config = null;
        this.context = null;
        this.needsSession = false;
        this.errorPageURL = null;
        this.bufferSize = -1;
        this.autoFlush = true;
        this.request = null;
        this.response = null;
        this.depth = -1;
        this.session = null;
        this.applicationContext = null;
        this.elContext = null;
        this.attributes.clear();
        for (BodyContentImpl body : this.outs) {
            body.recycle();
        }
        this.baseOut.recycle(((JspFactoryImpl)this.factory).poolFreePageContextIfNotFull(this));
        this.wasReleased = true;
        this.alreadyInitialized = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "release");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object getAttribute(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getAttribute", new Object[]{name});
        }
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        Object v = this.attributes.get(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            v = v;
            logger.exiting(CLASS_NAME, "getAttribute", v);
        }
        return v;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object getAttribute(String name, int scope) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getAttribute", new Object[]{name, scope});
        }
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        switch (scope) {
            case 1: {
                Object v = this.attributes.get(name);
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    v = v;
                    logger.exiting(CLASS_NAME, "getAttribute", v);
                }
                return v;
            }
            case 2: {
                Object object = this.request.getAttribute(name);
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    object = object;
                    logger.exiting(CLASS_NAME, "getAttribute", object);
                }
                return object;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException("jsp.error.page.noSession");
                }
                Object object = this.session.getAttribute(name);
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    object = object;
                    logger.exiting(CLASS_NAME, "getAttribute", object);
                }
                return object;
            }
            case 4: {
                Object object = this.context.getAttribute(name);
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    object = object;
                    logger.exiting(CLASS_NAME, "getAttribute", object);
                }
                return object;
            }
        }
        throw new IllegalArgumentException("Invalid scope");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setAttribute(String name, Object attribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setAttribute", new Object[]{name, attribute});
        }
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        if (attribute != null) {
            this.attributes.put(name, attribute);
        } else {
            this.removeAttribute(name, 1);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setAttribute");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setAttribute(String name, Object o, int scope) {
        block11: {
            block10: {
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    logger.entering(CLASS_NAME, "setAttribute", new Object[]{name, o, scope});
                }
                if (name == null) {
                    throw new NullPointerException("Null name");
                }
                if (o == null) break block10;
                switch (scope) {
                    case 1: {
                        this.attributes.put(name, o);
                        break block11;
                    }
                    case 2: {
                        this.request.setAttribute(name, o);
                        break block11;
                    }
                    case 3: {
                        if (this.session == null) {
                            throw new IllegalStateException("jsp.error.page.noSession");
                        }
                        this.session.setAttribute(name, o);
                        break block11;
                    }
                    case 4: {
                        this.context.setAttribute(name, o);
                        break block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid scope");
                    }
                }
            }
            this.removeAttribute(name, scope);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setAttribute");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void removeAttribute(String name, int scope) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "removeAttribute", new Object[]{name, scope});
        }
        if (name == null) {
            throw new NullPointerException("jsp.error.attribute.null_name");
        }
        switch (scope) {
            case 1: {
                this.attributes.remove(name);
                break;
            }
            case 2: {
                this.request.removeAttribute(name);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException("jsp.error.page.noSession");
                }
                this.session.removeAttribute(name);
                break;
            }
            case 4: {
                this.context.removeAttribute(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope");
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "removeAttribute");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getAttributesScope(String name) {
        block13: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering(CLASS_NAME, "getAttributesScope", new Object[]{name});
            }
            if (name == null) {
                throw new NullPointerException("jsp.error.attribute.null_name");
            }
            if (this.attributes.get(name) != null) {
                int n = 1;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    n = n;
                    logger.exiting(CLASS_NAME, "getAttributesScope", n);
                }
                return n;
            }
            if (this.request.getAttribute(name) != null) {
                int n = 2;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    n = n;
                    logger.exiting(CLASS_NAME, "getAttributesScope", n);
                }
                return n;
            }
            if (this.session != null) {
                int n;
                try {
                    if (this.session.getAttribute(name) == null) break block13;
                    n = 3;
                }
                catch (IllegalStateException ex) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block13;
                    logger.logp(Level.FINE, CLASS_NAME, "PageContextImpl", "The session was invalid and method getAttributesScope(String name) was called.", ex);
                }
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    n = n;
                    logger.exiting(CLASS_NAME, "getAttributesScope", n);
                }
                return n;
            }
        }
        if (this.context.getAttribute(name) != null) {
            int n = 4;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                n = n;
                logger.exiting(CLASS_NAME, "getAttributesScope", n);
            }
            return n;
        }
        int n = 0;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting(CLASS_NAME, "getAttributesScope", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object findAttribute(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "findAttribute", new Object[]{name});
        }
        if (name == null) {
            throw new NullPointerException("jsp.error.attribute.null_name");
        }
        Object o = this.attributes.get(name);
        if (o != null) {
            Object v = o;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                v = v;
                logger.exiting(CLASS_NAME, "findAttribute", v);
            }
            return v;
        }
        o = this.request.getAttribute(name);
        if (o != null) {
            Object object = o;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                object = object;
                logger.exiting(CLASS_NAME, "findAttribute", object);
            }
            return object;
        }
        if (this.session != null) {
            block12: {
                try {
                    o = this.session.getAttribute(name);
                }
                catch (IllegalStateException ex) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block12;
                    logger.logp(Level.FINE, CLASS_NAME, "PageContextImpl", "The session was invalid and method findAttribute(String name) was called.", ex);
                }
            }
            if (o != null) {
                Object object = o;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    object = object;
                    logger.exiting(CLASS_NAME, "findAttribute", object);
                }
                return object;
            }
        }
        Object object = this.context.getAttribute(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            object = object;
            logger.exiting(CLASS_NAME, "findAttribute", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Enumeration getAttributeNamesInScope(int scope) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getAttributeNamesInScope", new Object[]{scope});
        }
        switch (scope) {
            case 1: {
                Enumeration enumeration = Collections.enumeration(this.attributes.keySet());
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    enumeration = enumeration;
                    logger.exiting(CLASS_NAME, "getAttributeNamesInScope", enumeration);
                }
                return enumeration;
            }
            case 2: {
                Enumeration enumeration = this.request.getAttributeNames();
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    enumeration = enumeration;
                    logger.exiting(CLASS_NAME, "getAttributeNamesInScope", enumeration);
                }
                return enumeration;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException("jsp.error.page.noSession");
                }
                Enumeration enumeration = this.session.getAttributeNames();
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    enumeration = enumeration;
                    logger.exiting(CLASS_NAME, "getAttributeNamesInScope", enumeration);
                }
                return enumeration;
            }
            case 4: {
                Enumeration enumeration = this.context.getAttributeNames();
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    enumeration = enumeration;
                    logger.exiting(CLASS_NAME, "getAttributeNamesInScope", enumeration);
                }
                return enumeration;
            }
        }
        throw new IllegalArgumentException("Invalid scope");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void removeAttribute(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "removeAttribute", new Object[]{name});
        }
        if (name == null) {
            throw new NullPointerException("jsp.error.attribute.null_name");
        }
        try {
            block8: {
                this.removeAttribute(name, 1);
                this.removeAttribute(name, 2);
                if (this.session != null) {
                    try {
                        this.removeAttribute(name, 3);
                    }
                    catch (IllegalStateException ex) {
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block8;
                        logger.logp(Level.FINE, CLASS_NAME, "PageContextImpl", "The session was invalid and method removeAttribute(String name) was called.", ex);
                    }
                }
            }
            this.removeAttribute(name, 4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "removeAttribute");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspWriter getOut() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getOut", new Object[0]);
        }
        JspWriter jspWriter = this.out;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspWriter = jspWriter;
            logger.exiting(CLASS_NAME, "getOut", jspWriter);
        }
        return jspWriter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HttpSession getSession() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getSession", new Object[0]);
        }
        HttpSession httpSession = this.session;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            httpSession = httpSession;
            logger.exiting(CLASS_NAME, "getSession", httpSession);
        }
        return httpSession;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Servlet getServlet() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getServlet", new Object[0]);
        }
        Servlet servlet = this.servlet;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            servlet = servlet;
            logger.exiting(CLASS_NAME, "getServlet", servlet);
        }
        return servlet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ServletConfig getServletConfig() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getServletConfig", new Object[0]);
        }
        ServletConfig servletConfig = this.config;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            servletConfig = servletConfig;
            logger.exiting(CLASS_NAME, "getServletConfig", servletConfig);
        }
        return servletConfig;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ServletContext getServletContext() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getServletContext", new Object[0]);
        }
        ServletContext servletContext = this.config.getServletContext();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            servletContext = servletContext;
            logger.exiting(CLASS_NAME, "getServletContext", servletContext);
        }
        return servletContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ServletRequest getRequest() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getRequest", new Object[0]);
        }
        ServletRequest servletRequest = this.request;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            servletRequest = servletRequest;
            logger.exiting(CLASS_NAME, "getRequest", servletRequest);
        }
        return servletRequest;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ServletResponse getResponse() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getResponse", new Object[0]);
        }
        ServletResponse servletResponse = this.response;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            servletResponse = servletResponse;
            logger.exiting(CLASS_NAME, "getResponse", servletResponse);
        }
        return servletResponse;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Exception getException() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getException", new Object[0]);
        }
        Exception exception = (Exception)this.request.getAttribute("jakarta.servlet.jsp.jspException");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            exception = exception;
            logger.exiting(CLASS_NAME, "getException", exception);
        }
        return exception;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object getPage() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getPage", new Object[0]);
        }
        Servlet servlet = this.servlet;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            servlet = servlet;
            logger.exiting(CLASS_NAME, "getPage", servlet);
        }
        return servlet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private final String getAbsolutePathRelativeToContext(String relativeUrlPath) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getAbsolutePathRelativeToContext", new Object[]{relativeUrlPath});
        }
        String path = relativeUrlPath;
        if (!path.startsWith("/")) {
            String uri = (String)this.request.getAttribute("jakarta.servlet.include.servlet_path");
            if (uri == null) {
                uri = ((HttpServletRequest)this.request).getServletPath();
            }
            String baseURI = uri.substring(0, uri.lastIndexOf(47));
            path = baseURI + '/' + path;
        }
        String string = path;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getAbsolutePathRelativeToContext", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void include(String relativeUrlPath) throws ServletException, IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "include", new Object[]{relativeUrlPath});
        }
        JspRuntimeLibrary.include(this.request, this.response, relativeUrlPath, (Writer)this.out, true);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "include");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void include(String relativeUrlPath, boolean flush) throws ServletException, IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "include", new Object[]{relativeUrlPath, flush});
        }
        JspRuntimeLibrary.include(this.request, this.response, relativeUrlPath, (Writer)this.out, flush);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "include");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public VariableResolver getVariableResolver() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getVariableResolver", new Object[0]);
        }
        VariableResolverImpl variableResolverImpl = new VariableResolverImpl(this.getELContext());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            variableResolverImpl = variableResolverImpl;
            logger.exiting(CLASS_NAME, "getVariableResolver", variableResolverImpl);
        }
        return variableResolverImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void forward(String relativeUrlPath) throws ServletException, IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "forward", new Object[]{relativeUrlPath});
        }
        try {
            this.out.clear();
        }
        catch (IOException ex) {
            throw new IllegalStateException("jsp.error.attempt_to_clear_flushed_buffer");
        }
        while (this.response instanceof ServletResponseWrapperInclude) {
            this.response = ((ServletResponseWrapperInclude)this.response).getResponse();
        }
        String path = this.getAbsolutePathRelativeToContext(relativeUrlPath);
        String includeUri = (String)this.request.getAttribute("jakarta.servlet.include.servlet_path");
        ServletResponse fresponse = this.response;
        ServletRequest frequest = this.request;
        if (includeUri != null) {
            this.request.removeAttribute("jakarta.servlet.include.servlet_path");
        }
        try {
            this.context.getRequestDispatcher(path).forward(this.request, this.response);
        }
        finally {
            if (includeUri != null) {
                this.request.setAttribute("jakarta.servlet.include.servlet_path", (Object)includeUri);
            }
            this.request.setAttribute("jakarta.servlet.forward.seen", (Object)"true");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "forward");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BodyContent pushBody() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "pushBody", new Object[0]);
        }
        BodyContent bodyContent = (BodyContent)this.pushBody(null);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bodyContent = bodyContent;
            logger.exiting(CLASS_NAME, "pushBody", bodyContent);
        }
        return bodyContent;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspWriter pushBody(Writer writer) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "pushBody", new Object[]{writer});
        }
        ++this.depth;
        if (this.depth >= this.outs.length) {
            BodyContentImpl[] newOuts = new BodyContentImpl[this.depth + 1];
            for (int i = 0; i < this.outs.length; ++i) {
                newOuts[i] = this.outs[i];
            }
            newOuts[this.depth] = new BodyContentImpl(this.out, this.bodyContentBufferSize);
            this.outs = newOuts;
        }
        this.outs[this.depth].setWriter(writer);
        this.out = this.outs[this.depth];
        this.setAttribute("jakarta.servlet.jsp.jspOut", this.out);
        BodyContentImpl bodyContentImpl = this.outs[this.depth];
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bodyContentImpl = bodyContentImpl;
            logger.exiting(CLASS_NAME, "pushBody", (Object)bodyContentImpl);
        }
        return bodyContentImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspWriter popBody() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "popBody", new Object[0]);
        }
        --this.depth;
        this.out = this.depth >= 0 ? this.outs[this.depth] : this.baseOut;
        this.setAttribute("jakarta.servlet.jsp.jspOut", this.out);
        JspWriter jspWriter = this.out;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspWriter = jspWriter;
            logger.exiting(CLASS_NAME, "popBody", jspWriter);
        }
        return jspWriter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExpressionEvaluator getExpressionEvaluator() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getExpressionEvaluator", new Object[0]);
        }
        ExpressionEvaluatorImpl expressionEvaluatorImpl = new ExpressionEvaluatorImpl(this.applicationContext.getExpressionFactory());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            expressionEvaluatorImpl = expressionEvaluatorImpl;
            logger.exiting(CLASS_NAME, "getExpressionEvaluator", expressionEvaluatorImpl);
        }
        return expressionEvaluatorImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handlePageException(Exception ex) throws IOException, ServletException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "handlePageException", new Object[]{ex});
        }
        this.handlePageException((Throwable)ex);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "handlePageException");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handlePageException(Throwable t) throws IOException, ServletException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "handlePageException", new Object[]{t});
        }
        if (t == null) {
            throw new NullPointerException("null Throwable");
        }
        if (this.errorPageURL != null && !this.errorPageURL.equals("")) {
            this.request.setAttribute("jakarta.servlet.jsp.jspException", (Object)t);
            this.request.setAttribute("jakarta.servlet.error.status_code", (Object)new Integer(500));
            this.request.setAttribute("jakarta.servlet.error.request_uri", (Object)((HttpServletRequest)this.request).getRequestURI());
            this.request.setAttribute("jakarta.servlet.error.servlet_name", (Object)this.config.getServletName());
            try {
                this.forward(this.errorPageURL);
            }
            catch (IllegalStateException ise) {
                this.include(this.errorPageURL);
            }
            Object newException = this.request.getAttribute("jakarta.servlet.error.exception");
            if (newException != null && newException == t) {
                this.request.removeAttribute("jakarta.servlet.error.exception");
            }
        } else {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            Throwable rootCause = null;
            if (t instanceof JspException) {
                rootCause = ((JspException)t).getRootCause();
            } else if (t instanceof ELException) {
                rootCause = ((ELException)t).getRootCause();
            }
            if (rootCause != null) {
                throw new ServletErrorReport(t.getMessage(), rootCause);
            }
            throw new ServletErrorReport(t);
        }
        this.request.removeAttribute("jakarta.servlet.error.status_code");
        this.request.removeAttribute("jakarta.servlet.error.request_uri");
        this.request.removeAttribute("jakarta.servlet.error.status_code");
        this.request.removeAttribute("jakarta.servlet.jsp.jspException");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "handlePageException");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String XmlEscape(String s) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "XmlEscape", new Object[]{s});
        }
        if (s == null) {
            String string = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "XmlEscape", string);
            }
            return string;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\'') {
                sb.append("&#039;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("&#034;");
                continue;
            }
            sb.append(c);
        }
        String string = sb.toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "XmlEscape", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object proprietaryEvaluate(String expression, Class expectedType, PageContext pageContext, ProtectedFunctionMapper functionMap, boolean escape) throws ELException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "proprietaryEvaluate", new Object[]{expression, expectedType, pageContext, functionMap, escape});
        }
        ExpressionFactory exprFactorySetInPageContext = (ExpressionFactory)pageContext.getAttribute("_jspx_ExpressionFactoryImplObject");
        if (exprFactorySetInPageContext == null) {
            exprFactorySetInPageContext = JspFactory.getDefaultFactory().getJspApplicationContext(pageContext.getServletContext()).getExpressionFactory();
        }
        ExpressionFactory exprFactory = exprFactorySetInPageContext;
        ELContextImpl ctx = (ELContextImpl)pageContext.getELContext();
        ctx.setFunctionMapper((jakarta.el.FunctionMapper)new FunctionMapperImpl((FunctionMapper)functionMap));
        ValueExpression ve = exprFactory.createValueExpression((ELContext)ctx, expression, expectedType);
        Object retValue = ve.getValue((ELContext)ctx);
        if (escape && retValue != null) {
            retValue = PageContextImpl.XmlEscape(retValue.toString());
        }
        Object object = retValue;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            object = object;
            logger.exiting(CLASS_NAME, "proprietaryEvaluate", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private JspWriterImpl _createOut(int bufferSize, boolean autoFlush) throws IOException {
        JspWriterImpl jspWriterImpl;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering(CLASS_NAME, "_createOut", new Object[]{bufferSize, autoFlush});
            }
            try {
                jspWriterImpl = new JspWriterImpl(this.response, bufferSize, autoFlush);
                if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            }
            catch (Throwable t) {
                JspWriterImpl jspWriterImpl2 = null;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    jspWriterImpl2 = jspWriterImpl2;
                    logger.exiting(CLASS_NAME, "_createOut", (Object)jspWriterImpl2);
                }
                return jspWriterImpl2;
            }
            jspWriterImpl = jspWriterImpl;
            logger.exiting(CLASS_NAME, "_createOut", (Object)jspWriterImpl);
        }
        return jspWriterImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ELContext getELContext() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getELContext", new Object[0]);
        }
        if (this.elContext == null) {
            this.elContext = this.applicationContext.createELContext((JspContext)this);
        }
        ELContextImpl eLContextImpl = this.elContext;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            eLContextImpl = eLContextImpl;
            logger.exiting(CLASS_NAME, "getELContext", eLContextImpl);
        }
        return eLContextImpl;
    }
}

