/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.service.util.ServiceCaller;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.services.OpenAPIModelOperations;
import io.openliberty.microprofile.openapi20.internal.utils.Constants;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.media.Schema;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SchemaValidator
extends TypeValidator<Schema> {
    private static final TraceComponent tc = Tr.register(SchemaValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static ServiceCaller<OpenAPIModelOperations> MODEL_OPS = new ServiceCaller(SchemaValidator.class, OpenAPIModelOperations.class);
    private static final SchemaValidator INSTANCE = new SchemaValidator();
    static final long serialVersionUID = -4473352753159848123L;

    public static SchemaValidator getInstance() {
        return INSTANCE;
    }

    private SchemaValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Schema t) {
        if (t != null) {
            String message;
            String reference = t.getRef();
            if (reference != null && !reference.isEmpty()) {
                helper.validateReference(context, key, reference, Schema.class);
                return;
            }
            Set types = MODEL_OPS.run(s -> s.getTypes(t)).map(typeList -> typeList.stream().map(Object::toString).collect(Collectors.toSet())).orElse(null);
            if (types != null && types.contains(Constants.SCHEMA_TYPE_ARRAY) && t.getItems() == null) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"schemaTypeArrayNullItems", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
            if (t.getReadOnly() != null && t.getWriteOnly() != null && t.getReadOnly().booleanValue() && t.getWriteOnly().booleanValue()) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"schemaReadOnlyOrWriteOnly", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
            if (t.getMultipleOf() != null && t.getMultipleOf().compareTo(BigDecimal.ZERO) <= 0) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"schemaMultipleOfNotGreaterThanZero", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
            ArrayList<String> propertiesInvalidValue = new ArrayList<String>();
            ArrayList<String> propertiesNotForSchemaType = new ArrayList<String>();
            if (t.getMaxLength() != null) {
                if (t.getMaxLength() < 0) {
                    propertiesInvalidValue.add("maxLength");
                }
                if (types != null && !types.contains(Constants.SCHEMA_TYPE_STRING)) {
                    propertiesNotForSchemaType.add("maxLength");
                }
            }
            if (t.getMinLength() != null) {
                if (t.getMinLength() < 0) {
                    propertiesInvalidValue.add("minLength");
                }
                if (types != null && !types.contains(Constants.SCHEMA_TYPE_STRING)) {
                    propertiesNotForSchemaType.add("minLength");
                }
            }
            if (t.getMinItems() != null) {
                if (t.getMinItems() < 0) {
                    propertiesInvalidValue.add("minItems");
                }
                if (types != null && !types.contains(Constants.SCHEMA_TYPE_ARRAY)) {
                    propertiesNotForSchemaType.add("minItems");
                }
            }
            if (t.getMaxItems() != null) {
                if (t.getMaxItems() < 0) {
                    propertiesInvalidValue.add("maxItems");
                }
                if (types != null && !types.contains(Constants.SCHEMA_TYPE_ARRAY)) {
                    propertiesNotForSchemaType.add("maxItems");
                }
            }
            if (t.getUniqueItems() != null && types != null && !types.contains(Constants.SCHEMA_TYPE_ARRAY)) {
                propertiesNotForSchemaType.add("uniqueItems");
            }
            if (t.getMinProperties() != null) {
                if (t.getMinProperties() < 0) {
                    propertiesInvalidValue.add("minProperties");
                }
                if (types != null && !types.contains(Constants.SCHEMA_TYPE_OBJECT)) {
                    propertiesNotForSchemaType.add("minProperties");
                }
            }
            if (t.getMaxProperties() != null) {
                if (t.getMaxProperties() < 0) {
                    propertiesInvalidValue.add("maxProperties");
                }
                if (types != null && !types.contains(Constants.SCHEMA_TYPE_OBJECT)) {
                    propertiesNotForSchemaType.add("maxProperties");
                }
            }
            if (!propertiesInvalidValue.isEmpty()) {
                for (String s2 : propertiesInvalidValue) {
                    String message2 = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyLessThanZero", (Object[])new Object[]{s2});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message2));
                }
            }
            if (!propertiesNotForSchemaType.isEmpty()) {
                for (String s2 : propertiesNotForSchemaType) {
                    String typeString = types.size() == 1 ? (String)types.iterator().next() : types.stream().collect(Collectors.joining(",", "[", "]"));
                    String message3 = Tr.formatMessage((TraceComponent)tc, (String)"schemaTypeDoesNotMatchProperty", (Object[])new Object[]{s2, typeString});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message3));
                }
            }
        }
    }
}

