/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.utils.Constants;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RuntimeExpressionUtils {
    private static final String EXP_URL = "$url";
    private static final String EXP_METHOD = "$method";
    private static final String EXP_STATUS_CODE = "$statusCode";
    private static final String EXP_REQUEST = "$request.";
    private static final String EXP_RESPONSE = "$response.";
    private static final String HEADER_REF = "header.";
    private static final String QUERY_REF = "query.";
    private static final String PATH_REF = "path.";
    private static final String BODY_REF = "body";
    static final long serialVersionUID = 6835997068379589321L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static boolean isRuntimeExpression(String re) {
        if (re == null) {
            return false;
        }
        if ((re = re.trim()).equals(EXP_URL)) {
            return true;
        }
        if (re.equals(EXP_METHOD)) {
            return true;
        }
        if (re.equals(EXP_STATUS_CODE)) {
            return true;
        }
        if (re.startsWith(EXP_REQUEST)) {
            return RuntimeExpressionUtils.isSource(re.substring(EXP_REQUEST.length()));
        }
        if (re.startsWith(EXP_RESPONSE)) {
            return RuntimeExpressionUtils.isSource(re.substring(EXP_RESPONSE.length()));
        }
        return false;
    }

    private static boolean isSource(String sourceString) {
        if (sourceString == null) {
            return false;
        }
        if ((sourceString = sourceString.trim()).startsWith(HEADER_REF)) {
            return RuntimeExpressionUtils.isToken(sourceString.substring(HEADER_REF.length()));
        }
        if (sourceString.startsWith(QUERY_REF)) {
            return RuntimeExpressionUtils.isName(sourceString.substring(QUERY_REF.length()));
        }
        if (sourceString.startsWith(PATH_REF)) {
            return RuntimeExpressionUtils.isName(sourceString.substring(PATH_REF.length()));
        }
        if (sourceString.startsWith(BODY_REF)) {
            return RuntimeExpressionUtils.isFragment(sourceString.substring(BODY_REF.length()));
        }
        return false;
    }

    private static boolean isToken(String token) {
        return Constants.REGEX_TOKEN_PATTERN.matcher(token).matches();
    }

    private static boolean isName(String name) {
        return name.length() >= 1;
    }

    private static boolean isFragment(String fragment) {
        if (fragment == null || !fragment.startsWith("#/")) {
            return false;
        }
        Scanner s = new Scanner(fragment.substring(1)).useDelimiter("/");
        if (!s.hasNext()) {
            return false;
        }
        while (s.hasNext()) {
            String ref = s.next();
            if (RuntimeExpressionUtils.isReference(ref)) continue;
            return false;
        }
        return true;
    }

    private static boolean isReference(String ref) {
        if (ref == null || ref.length() < 1) {
            return false;
        }
        int tildeLoc = ref.indexOf(126);
        while (tildeLoc != -1) {
            if (tildeLoc < ref.length() - 1 && (ref.charAt(tildeLoc + 1) == '0' || ref.charAt(tildeLoc + 1) == '1')) {
                tildeLoc = ref.indexOf(126, tildeLoc + 2);
                continue;
            }
            return false;
        }
        return true;
    }

    public static List<String> extractURLVars(String input) {
        ArrayList<String> list = new ArrayList<String>();
        if (input.startsWith("}")) {
            return null;
        }
        int openLoc = input.indexOf(123);
        int closeLoc = 0;
        while (openLoc != -1) {
            if ((closeLoc = input.indexOf(125, closeLoc + 1)) <= openLoc) {
                return null;
            }
            list.add(input.substring(openLoc + 1, closeLoc));
            if ((openLoc = input.indexOf(123, openLoc + 1)) <= 0 || openLoc >= closeLoc) continue;
            return null;
        }
        if ((closeLoc = input.indexOf(125, closeLoc + 1)) != -1) {
            return null;
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.validation.RuntimeExpressionUtils", RuntimeExpressionUtils.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    }
}

