/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.internal.validation.ValidatorUtils;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ExternalDocumentationValidator
extends TypeValidator<ExternalDocumentation> {
    private static final TraceComponent tc = Tr.register(ExternalDocumentationValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final ExternalDocumentationValidator INSTANCE = new ExternalDocumentationValidator();
    static final long serialVersionUID = -892547761442297345L;

    public static ExternalDocumentationValidator getInstance() {
        return INSTANCE;
    }

    private ExternalDocumentationValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, ExternalDocumentation t) {
        ValidatorUtils.validateRequiredField(t.getUrl(), context, "url").ifPresent(helper::addValidationEvent);
        if (t.getUrl() != null && !ValidatorUtils.isValidURI(t.getUrl())) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"externalDocumentationInvalidURL", (Object[])new Object[]{t.getUrl()});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("url"), message));
        }
    }
}

