/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.registry.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.security.wim.registry.util.BridgeUtils;
import com.ibm.ws.security.wim.registry.util.TypeMappings;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Context;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.Root;
import com.ibm.wsspi.security.wim.model.SearchControl;
import java.util.HashMap;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UniqueIdBridge {
    private static final TraceComponent tc = Tr.register(UniqueIdBridge.class, (String)"registyUtil", (String)"com.ibm.ws.security.wim.registry.util.resources.RegistryUtilMessages");
    private TypeMappings propertyMap = null;
    private BridgeUtils mappingUtils = null;
    static final long serialVersionUID = 6072552178668405112L;

    public UniqueIdBridge(BridgeUtils mappingUtil) {
        this.mappingUtils = mappingUtil;
        this.propertyMap = new TypeMappings(this.mappingUtils);
    }

    @FFDCIgnore(value={InvalidNameException.class})
    public static boolean isDN(String uniqueName) {
        if (uniqueName == null) {
            return false;
        }
        try {
            new LdapName(uniqueName);
            return true;
        }
        catch (InvalidNameException e) {
            return false;
        }
    }

    @FFDCIgnore(value={WIMException.class, InvalidNameException.class})
    public HashMap<String, String> getUniqueUserId(String inputUserSecurityName) throws EntryNotFoundException, RegistryException {
        List contexts;
        String methodName = "getUniqueUserId";
        String returnValue = "";
        Root root = null;
        try {
            Root resultRoot;
            Context context;
            boolean allowDNAsPrincipalName;
            String outputAttrName;
            String inputAttrName;
            String id;
            String quote;
            IDAndRealm idAndRealm;
            block26: {
                List contexts2;
                this.mappingUtils.validateId(inputUserSecurityName);
                idAndRealm = this.mappingUtils.separateIDAndRealm(inputUserSecurityName);
                root = this.mappingUtils.getWimService().createRootObject();
                if (idAndRealm.isRealmDefined()) {
                    this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
                    contexts = root.getContexts();
                    if (contexts != null) {
                        Context ctx = new Context();
                        ctx.setKey("allowOperationIfReposDown");
                        ctx.setValue((Object)this.mappingUtils.getCoreConfiguration().isAllowOpIfRepoDown(idAndRealm.getRealm()));
                        contexts.add(ctx);
                    }
                }
                quote = "'";
                id = idAndRealm.getId();
                if (id.indexOf("'") != -1) {
                    quote = "\"";
                }
                inputAttrName = this.propertyMap.getInputUserSecurityName(idAndRealm.getRealm());
                inputAttrName = this.mappingUtils.getRealInputAttrName(inputAttrName, id, true);
                outputAttrName = this.propertyMap.getOutputUniqueUserId(idAndRealm.getRealm());
                allowDNAsPrincipalName = this.mappingUtils.allowDNAsPrincipalName;
                if (allowDNAsPrincipalName && (contexts2 = root.getContexts()) != null) {
                    Context ctx = new Context();
                    ctx.setKey("allowDNPrincipalNameAsLiteral");
                    ctx.setValue((Object)allowDNAsPrincipalName);
                    contexts2.add(ctx);
                }
                context = new Context();
                context.setKey("isURBridgeResult");
                context.setValue((Object)"false");
                root.getContexts().add(context);
                resultRoot = null;
                try {
                    resultRoot = this.mappingUtils.getEntityByIdentifier(root, inputAttrName, id, outputAttrName, this.mappingUtils);
                }
                catch (WIMException e) {
                    if (!tc.isDebugEnabled()) break block26;
                    Tr.debug((TraceComponent)tc, (String)("Ignoring exception: " + e.getMessage()), (Object[])new Object[]{e});
                }
            }
            boolean foundInURBridge = false;
            if (resultRoot != null && !resultRoot.getEntities().isEmpty()) {
                List contexts3 = resultRoot.getContexts();
                for (Context ctx : contexts3) {
                    String key = ctx.getKey();
                    if (key == null || !"isURBridgeResult".equals(key) || !"true".equalsIgnoreCase((String)ctx.getValue())) continue;
                    foundInURBridge = true;
                }
            }
            if (resultRoot != null && !resultRoot.getEntities().isEmpty() && (UniqueIdBridge.isDN(id) || foundInURBridge)) {
                root = resultRoot;
            } else if (!this.mappingUtils.isIdentifierTypeProperty(inputAttrName) || allowDNAsPrincipalName) {
                if (allowDNAsPrincipalName) {
                    inputAttrName = "principalName";
                }
                List controls = root.getControls();
                SearchControl searchControl = new SearchControl();
                if (controls != null) {
                    controls.add(searchControl);
                }
                if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName)) {
                    searchControl.getProperties().add(outputAttrName);
                }
                searchControl.setExpression("//entities[@xsi:type='LoginAccount' and " + inputAttrName + "=" + quote + id + quote + "]");
                context = new Context();
                context.set("key", (Object)"useUserFilterForSearch");
                context.set("value", (Object)id);
                root.getContexts().add(context);
                root = this.mappingUtils.getWimService().search(root);
            }
            List returnList = root.getEntities();
            if (returnList.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUserSecurityName)));
            }
            if (returnList.size() != 1) {
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUserSecurityName)));
            }
            Entity entity = (Entity)returnList.get(0);
            if (entity != null) {
                Object value;
                returnValue = !this.mappingUtils.isIdentifierTypeProperty(outputAttrName) ? ((value = entity.get(outputAttrName)) instanceof List ? BridgeUtils.getStringValue(((List)value).get(0)) : BridgeUtils.getStringValue(value)) : BridgeUtils.getStringValue(entity.getIdentifier().get(outputAttrName));
                if (this.mappingUtils.returnRealmInfoInUniqueUserId && idAndRealm.isRealmDefined() || idAndRealm.isRealmDefined() && !this.mappingUtils.getDefaultRealmName().equals(idAndRealm.getRealm())) {
                    returnValue = returnValue + idAndRealm.getDelimiter() + idAndRealm.getRealm();
                }
            }
            if ("uniqueName".equalsIgnoreCase(outputAttrName)) {
                try {
                    new LdapName(returnValue);
                }
                catch (InvalidNameException e) {
                    String uid = entity.getIdentifier().getUniqueId();
                    if (uid != null) {
                        returnValue = uid;
                    }
                }
            }
        }
        catch (WIMException toCatch) {
            BridgeUtils.handleExceptions((Exception)((Object)toCatch));
        }
        String isURBrigeResult = "false";
        if (root != null) {
            contexts = root.getContexts();
            for (Context contextInput : contexts) {
                String key = contextInput.getKey();
                if (key == null || !"isURBridgeResult".equals(key)) continue;
                isURBrigeResult = String.valueOf(contextInput.getValue());
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("isURBridgeResult", isURBrigeResult);
        result.put("RESULT", returnValue);
        return result;
    }

    @FFDCIgnore(value={WIMException.class, InvalidNameException.class})
    public String getUniqueGroupId(String inputGroupSecurityName) throws EntryNotFoundException, RegistryException {
        String methodName = "getUniqueGroupId";
        String returnValue = "";
        try {
            Object value;
            this.mappingUtils.validateId(inputGroupSecurityName);
            IDAndRealm idAndRealm = this.mappingUtils.separateIDAndRealm(inputGroupSecurityName);
            Root root = this.mappingUtils.getWimService().createRootObject();
            if (idAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
            }
            String quote = "'";
            String id = idAndRealm.getId();
            if (id.indexOf("'") != -1) {
                quote = "\"";
            }
            String inputAttrName = this.propertyMap.getInputGroupSecurityName(idAndRealm.getRealm());
            inputAttrName = this.mappingUtils.getRealInputAttrName(inputAttrName, id, false);
            String outputAttrName = this.propertyMap.getOutputUniqueGroupId(idAndRealm.getRealm());
            Root resultRoot = null;
            if (UniqueIdBridge.isDN(id)) {
                resultRoot = this.mappingUtils.getEntityByIdentifier(root, inputAttrName, id, outputAttrName, this.mappingUtils);
            }
            if (resultRoot != null && !resultRoot.getEntities().isEmpty()) {
                root = resultRoot;
            } else {
                List controls = root.getControls();
                SearchControl searchControl = new SearchControl();
                if (controls != null) {
                    controls.add(searchControl);
                }
                if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName)) {
                    searchControl.getProperties().add(outputAttrName);
                }
                searchControl.setExpression("//entities[@xsi:type='Group' and " + inputAttrName + "=" + quote + id + quote + "]");
                Context context = new Context();
                context.set("key", (Object)"useGroupFilterForSearch");
                context.set("value", (Object)id);
                root.getContexts().add(context);
                root = this.mappingUtils.getWimService().search(root);
            }
            List returnList = root.getEntities();
            if (returnList.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputGroupSecurityName)));
            }
            if (returnList.size() != 1) {
                if (tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputGroupSecurityName));
                }
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputGroupSecurityName)));
            }
            Entity group = (Entity)returnList.get(0);
            returnValue = !this.mappingUtils.isIdentifierTypeProperty(outputAttrName) ? ((value = group.get(outputAttrName)) instanceof List ? BridgeUtils.getStringValue(((List)value).get(0)) : BridgeUtils.getStringValue(value)) : BridgeUtils.getStringValue(group.getIdentifier().get(outputAttrName));
            if ("uniqueName".equalsIgnoreCase(outputAttrName)) {
                try {
                    new LdapName(returnValue);
                }
                catch (InvalidNameException e) {
                    String uid = group.getIdentifier().getUniqueId();
                    if (uid != null) {
                        returnValue = uid;
                    }
                }
            }
        }
        catch (WIMException toCatch) {
            BridgeUtils.handleExceptions((Exception)((Object)toCatch));
        }
        return returnValue;
    }
}

