/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.EmbeddedSignature;
import org.bouncycastle.bcpg.sig.Exportable;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.IntendedRecipientFingerprint;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.bcpg.sig.PolicyURI;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.bcpg.sig.RegularExpression;
import org.bouncycastle.bcpg.sig.Revocable;
import org.bouncycastle.bcpg.sig.RevocationKey;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.bcpg.sig.SignatureTarget;
import org.bouncycastle.bcpg.sig.SignerUserID;
import org.bouncycastle.bcpg.sig.TrustSignature;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;

public class PGPSignatureSubpacketGenerator {
    List packets = new ArrayList();

    public PGPSignatureSubpacketGenerator() {
    }

    public PGPSignatureSubpacketGenerator(PGPSignatureSubpacketVector pGPSignatureSubpacketVector) {
        if (pGPSignatureSubpacketVector != null) {
            for (int i = 0; i != pGPSignatureSubpacketVector.packets.length; ++i) {
                this.packets.add(pGPSignatureSubpacketVector.packets[i]);
            }
        }
    }

    public void setRevocable(boolean bl, boolean bl2) {
        if (this.contains(7)) {
            throw new IllegalStateException("Revocable exists in the Signature Subpacket Generator");
        }
        this.packets.add(new Revocable(bl, bl2));
    }

    public void setExportable(boolean bl, boolean bl2) {
        if (this.contains(4)) {
            throw new IllegalStateException("Exportable Certification exists in the Signature Subpacket Generator");
        }
        this.packets.add(new Exportable(bl, bl2));
    }

    public void setFeature(boolean bl, byte by) {
        this.packets.add(new Features(bl, by));
    }

    public void setTrust(boolean bl, int n, int n2) {
        this.packets.add(new TrustSignature(bl, n, n2));
    }

    public void setKeyExpirationTime(boolean bl, long l) {
        this.packets.add(new KeyExpirationTime(bl, l));
    }

    public void setSignatureExpirationTime(boolean bl, long l) {
        this.packets.add(new SignatureExpirationTime(bl, l));
    }

    public void setSignatureCreationTime(boolean bl, Date date) {
        this.packets.add(new SignatureCreationTime(bl, date));
    }

    public void setPreferredHashAlgorithms(boolean bl, int[] nArray) {
        this.packets.add(new PreferredAlgorithms(21, bl, nArray));
    }

    public void setPreferredSymmetricAlgorithms(boolean bl, int[] nArray) {
        this.packets.add(new PreferredAlgorithms(11, bl, nArray));
    }

    public void setPreferredCompressionAlgorithms(boolean bl, int[] nArray) {
        this.packets.add(new PreferredAlgorithms(22, bl, nArray));
    }

    public void setPreferredAEADAlgorithms(boolean bl, int[] nArray) {
        this.packets.add(new PreferredAlgorithms(39, bl, nArray));
    }

    public void addPolicyURI(boolean bl, String string) {
        this.packets.add(new PolicyURI(bl, string));
    }

    public void setKeyFlags(boolean bl, int n) {
        this.packets.add(new KeyFlags(bl, n));
    }

    public void setSignerUserID(boolean bl, String string) {
        this.addSignerUserID(bl, string);
    }

    public void addSignerUserID(boolean bl, String string) {
        if (string == null) {
            throw new IllegalArgumentException("attempt to set null SignerUserID");
        }
        this.packets.add(new SignerUserID(bl, string));
    }

    public void setSignerUserID(boolean bl, byte[] byArray) {
        this.addSignerUserID(bl, byArray);
    }

    public void addSignerUserID(boolean bl, byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("attempt to set null SignerUserID");
        }
        this.packets.add(new SignerUserID(bl, false, byArray));
    }

    public void setEmbeddedSignature(boolean bl, PGPSignature pGPSignature) throws IOException {
        this.addEmbeddedSignature(bl, pGPSignature);
    }

    public void addEmbeddedSignature(boolean bl, PGPSignature pGPSignature) throws IOException {
        byte[] byArray = pGPSignature.getEncoded();
        byte[] byArray2 = byArray.length - 1 > 256 ? new byte[byArray.length - 3] : new byte[byArray.length - 2];
        System.arraycopy(byArray, byArray.length - byArray2.length, byArray2, 0, byArray2.length);
        this.packets.add(new EmbeddedSignature(bl, false, byArray2));
    }

    public void setPrimaryUserID(boolean bl, boolean bl2) {
        this.packets.add(new PrimaryUserID(bl, bl2));
    }

    public void setNotationData(boolean bl, boolean bl2, String string, String string2) {
        this.addNotationData(bl, bl2, string, string2);
    }

    public void addNotationData(boolean bl, boolean bl2, String string, String string2) {
        this.packets.add(new NotationData(bl, bl2, string, string2));
    }

    public void setRevocationReason(boolean bl, byte by, String string) {
        this.packets.add(new RevocationReason(bl, by, string));
    }

    public void setRevocationKey(boolean bl, int n, byte[] byArray) {
        this.addRevocationKey(bl, n, byArray);
    }

    public void addRevocationKey(boolean bl, int n, byte[] byArray) {
        this.packets.add(new RevocationKey(bl, -128, n, byArray));
    }

    public void setIssuerKeyID(boolean bl, long l) {
        this.packets.add(new IssuerKeyID(bl, l));
    }

    public void setSignatureTarget(boolean bl, int n, int n2, byte[] byArray) {
        this.packets.add(new SignatureTarget(bl, n, n2, byArray));
    }

    public void setIssuerFingerprint(boolean bl, PGPSecretKey pGPSecretKey) {
        this.setIssuerFingerprint(bl, pGPSecretKey.getPublicKey());
    }

    public void setIssuerFingerprint(boolean bl, PGPPublicKey pGPPublicKey) {
        this.packets.add(new IssuerFingerprint(bl, pGPPublicKey.getVersion(), pGPPublicKey.getFingerprint()));
    }

    public void setIntendedRecipientFingerprint(boolean bl, PGPPublicKey pGPPublicKey) {
        this.addIntendedRecipientFingerprint(bl, pGPPublicKey);
    }

    public void addIntendedRecipientFingerprint(boolean bl, PGPPublicKey pGPPublicKey) {
        this.packets.add(new IntendedRecipientFingerprint(bl, pGPPublicKey.getVersion(), pGPPublicKey.getFingerprint()));
    }

    public void addCustomSubpacket(SignatureSubpacket signatureSubpacket) {
        this.packets.add(signatureSubpacket);
    }

    public boolean removePacket(SignatureSubpacket signatureSubpacket) {
        return this.packets.remove(signatureSubpacket);
    }

    public boolean hasSubpacket(int n) {
        for (int i = 0; i != this.packets.size(); ++i) {
            if (((SignatureSubpacket)this.packets.get(i)).getType() != n) continue;
            return true;
        }
        return false;
    }

    public SignatureSubpacket[] getSubpackets(int n) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i != this.packets.size(); ++i) {
            if (((SignatureSubpacket)this.packets.get(i)).getType() != n) continue;
            arrayList.add(this.packets.get(i));
        }
        return arrayList.toArray(new SignatureSubpacket[0]);
    }

    public PGPSignatureSubpacketVector generate() {
        return new PGPSignatureSubpacketVector(this.packets.toArray(new SignatureSubpacket[this.packets.size()]));
    }

    private boolean contains(int n) {
        for (int i = 0; i < this.packets.size(); ++i) {
            if (((SignatureSubpacket)this.packets.get(i)).getType() != n) continue;
            return true;
        }
        return false;
    }

    public void addRegularExpression(boolean bl, String string) {
        if (string == null) {
            throw new IllegalArgumentException("attempt to set null regular expression");
        }
        this.packets.add(new RegularExpression(bl, string));
    }
}

