/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.sib.mfp.MfpConstants;
import com.ibm.ws.sib.mfp.jmf.JMFMessage;
import com.ibm.ws.sib.mfp.jmf.tools.JSFormatter;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ffdc.SibDiagnosticModule;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.List;

public class MfpDiagnostics
extends SibDiagnosticModule {
    private static TraceComponent tc = SibTr.register(MfpDiagnostics.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final String DIAGNOSTIC_DATA_LIMIT_PROP = "com.ibm.ws.sib.mfp.DIAGNOSTIC_DATA_LIMIT";
    private static final int DEFAULT_DIAGNOSTIC_DATA_LIMIT_INT = 4096;
    private static final int DIAGNOSTIC_DATA_LIMIT_INT;
    private static MfpDiagnostics singleton;
    private static String[] packageList;

    static int getDiagnosticDataLimitInt() {
        return DIAGNOSTIC_DATA_LIMIT_INT;
    }

    private MfpDiagnostics() {
    }

    public static MfpDiagnostics initialize() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialize");
        }
        if (singleton == null) {
            singleton = new MfpDiagnostics();
            singleton.register(packageList);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialize");
        }
        return singleton;
    }

    public void ffdcDumpDefault(Throwable t, IncidentStream is, Object callerThis, Object[] objs, String sourceId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ffdcDumpDefault");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("FFDC for " + t));
        }
        if (t != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("  at... " + t.getStackTrace()[0]));
        }
        super.captureDefaultInformation(is);
        if (objs != null && objs.length > 0) {
            if (objs[0] instanceof Object[]) {
                for (int i = 0; i < objs.length; ++i) {
                    if (!(objs[i] instanceof Object[])) continue;
                    this.dumpUsefulStuff(is, (Object[])objs[i]);
                }
            } else {
                this.dumpUsefulStuff(is, objs);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ffdcDumpDefault");
        }
    }

    private void dumpUsefulStuff(IncidentStream is, Object[] objs) {
        if (objs != null && objs.length > 0) {
            if (objs[0] == MfpConstants.DM_BUFFER && objs.length >= 4) {
                this.dumpJmfBuffer(is, (byte[])objs[1], (Integer)objs[2], (Integer)objs[3]);
            } else if (objs[0] == MfpConstants.DM_MESSAGE && objs.length >= 2) {
                this.dumpJmfMessage(is, (JMFMessage)objs[1], objs[2]);
            } else if (objs[0] == MfpConstants.DM_SLICES && objs.length >= 2) {
                this.dumpJmfSlices(is, (List)objs[1]);
            }
        }
    }

    private void dumpJmfBuffer(IncidentStream is, byte[] frame, int offset, int length) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dumpJmfBuffer");
        }
        if (frame != null) {
            if (length == 0) {
                is.writeLine("Request to dump offset=" + offset + " length=" + length + " implies bad data so dumping buffer from offset 0.", "");
                offset = 0;
                length = frame.length;
            } else if (offset + length > frame.length) {
                length = frame.length - offset;
            }
            try {
                String buffer = SibTr.formatBytes((byte[])frame, (int)offset, (int)length, (int)MfpDiagnostics.getDiagnosticDataLimitInt());
                is.writeLine("JMF data buffer", buffer);
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("dumpJmfBuffer failed: " + e));
                }
            }
        } else {
            is.writeLine("No JMF buffer data available", "");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dumpJmfBuffer");
        }
    }

    private void dumpJmfMessage(IncidentStream is, JMFMessage jmfMsg, Object msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dumpJmfMessage");
        }
        if (msg != null) {
            is.writeLine("Message is of class: ", msg.getClass().getName());
        }
        if (jmfMsg != null) {
            try {
                String buffer = JSFormatter.format(jmfMsg);
                is.writeLine("JMF message", buffer);
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("dumpJmfMessage failed: " + e));
                }
            }
        } else {
            is.writeLine("No JMF message available", "");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dumpJmfMessage");
        }
    }

    private void dumpJmfSlices(IncidentStream is, List<DataSlice> slices) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dumpJmfSlices");
        }
        if (slices != null) {
            try {
                is.writeLine("JMF data slices", SibTr.formatSlices(slices, (int)MfpDiagnostics.getDiagnosticDataLimitInt()));
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("dumpJmfSlices failed: " + e));
                }
            }
        } else {
            is.writeLine("No JMF DataSlices available", "");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dumpJmfSlices");
        }
    }

    static {
        String diagnosticDataLimitString = RuntimeInfo.getProperty((String)DIAGNOSTIC_DATA_LIMIT_PROP);
        int limit = 4096;
        if (diagnosticDataLimitString != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("DIAGNOSTIC_DATA_LIMIT_PROP=" + diagnosticDataLimitString));
            }
            try {
                limit = Integer.parseInt(diagnosticDataLimitString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        DIAGNOSTIC_DATA_LIMIT_INT = limit;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("DIAGNOSTIC_DATA_LIMIT_INT=" + MfpDiagnostics.getDiagnosticDataLimitInt()));
        }
        singleton = null;
        packageList = new String[]{"com.ibm.ws.sib.mfp"};
    }
}

