/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc.v43;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.ConnectionSharing;
import com.ibm.ws.rsadapter.impl.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.jdbc.v41.WSJdbc41Connection;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.ShardingKey;

public class WSJdbc43Connection
extends WSJdbc41Connection
implements Connection {
    public WSJdbc43Connection(WSRdbManagedConnectionImpl mc, Connection conn, Object key, Object currentThreadID) {
        super(mc, conn, key, currentThreadID);
    }

    @Override
    public void beginRequest() throws SQLException {
        AdapterUtil.suppressBeginAndEndRequest();
    }

    @Override
    public void endRequest() throws SQLException {
        AdapterUtil.suppressBeginAndEndRequest();
    }

    @Override
    public boolean setShardingKeyIfValid(ShardingKey shardingKey, int timeout) throws SQLException {
        this.activate();
        try {
            if (this.managedConn.getHandleCount() > 1 && !AdapterUtil.match((Object)shardingKey, (Object)this.managedConn.getCurrentShardingKey())) {
                throw this.createSharingException("setShardingKeyIfValid");
            }
            boolean updated = this.managedConn.setShardingKeysIfValid((Object)shardingKey, (Object)"UNCHANGED", timeout);
            if (updated && this.managedConn.connectionSharing == ConnectionSharing.MatchCurrentState) {
                WSConnectionRequestInfoImpl cri = (WSConnectionRequestInfoImpl)this.managedConn.getConnectionRequestInfo();
                if (!cri.isCRIChangable()) {
                    cri = WSConnectionRequestInfoImpl.createChangableCRIFromNon((WSConnectionRequestInfoImpl)cri);
                    this.managedConn.setCRI(cri);
                }
                cri.setShardingKey((Object)shardingKey);
            }
            return updated;
        }
        catch (SQLException x) {
            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"65", (Object)this);
            throw this.proccessSQLException(x);
        }
        catch (NullPointerException x) {
            throw this.runtimeXIfNotClosed(x);
        }
    }

    @Override
    public boolean setShardingKeyIfValid(ShardingKey shardingKey, ShardingKey superShardingKey, int timeout) throws SQLException {
        this.activate();
        try {
            if (!(this.managedConn.getHandleCount() <= 1 || AdapterUtil.match((Object)shardingKey, (Object)this.managedConn.getCurrentShardingKey()) && AdapterUtil.match((Object)superShardingKey, (Object)this.managedConn.getCurrentSuperShardingKey()))) {
                throw this.createSharingException("setShardingKey");
            }
            boolean updated = this.managedConn.setShardingKeysIfValid((Object)shardingKey, (Object)superShardingKey, timeout);
            if (updated && this.managedConn.connectionSharing == ConnectionSharing.MatchCurrentState) {
                WSConnectionRequestInfoImpl cri = (WSConnectionRequestInfoImpl)this.managedConn.getConnectionRequestInfo();
                if (!cri.isCRIChangable()) {
                    cri = WSConnectionRequestInfoImpl.createChangableCRIFromNon((WSConnectionRequestInfoImpl)cri);
                    this.managedConn.setCRI(cri);
                }
                cri.setShardingKey((Object)shardingKey);
                cri.setSuperShardingKey((Object)superShardingKey);
            }
            return updated;
        }
        catch (SQLException x) {
            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"100", (Object)this);
            throw this.proccessSQLException(x);
        }
        catch (NullPointerException x) {
            throw this.runtimeXIfNotClosed(x);
        }
    }

    @Override
    public void setShardingKey(ShardingKey shardingKey) throws SQLException {
        this.activate();
        try {
            if (this.managedConn.getHandleCount() > 1 && !AdapterUtil.match((Object)shardingKey, (Object)this.managedConn.getCurrentShardingKey())) {
                throw this.createSharingException("setShardingKey");
            }
            this.managedConn.setShardingKeys((Object)shardingKey, (Object)"UNCHANGED");
            if (this.managedConn.connectionSharing == ConnectionSharing.MatchCurrentState) {
                WSConnectionRequestInfoImpl cri = (WSConnectionRequestInfoImpl)this.managedConn.getConnectionRequestInfo();
                if (!cri.isCRIChangable()) {
                    cri = WSConnectionRequestInfoImpl.createChangableCRIFromNon((WSConnectionRequestInfoImpl)cri);
                    this.managedConn.setCRI(cri);
                }
                cri.setShardingKey((Object)shardingKey);
            }
        }
        catch (SQLException x) {
            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"71", (Object)this);
            throw this.proccessSQLException(x);
        }
        catch (NullPointerException x) {
            throw this.runtimeXIfNotClosed(x);
        }
    }

    @Override
    public void setShardingKey(ShardingKey shardingKey, ShardingKey superShardingKey) throws SQLException {
        this.activate();
        try {
            if (!(this.managedConn.getHandleCount() <= 1 || AdapterUtil.match((Object)shardingKey, (Object)this.managedConn.getCurrentShardingKey()) && AdapterUtil.match((Object)superShardingKey, (Object)this.managedConn.getCurrentSuperShardingKey()))) {
                throw this.createSharingException("setShardingKey");
            }
            this.managedConn.setShardingKeys((Object)shardingKey, (Object)superShardingKey);
            if (this.managedConn.connectionSharing == ConnectionSharing.MatchCurrentState) {
                WSConnectionRequestInfoImpl cri = (WSConnectionRequestInfoImpl)this.managedConn.getConnectionRequestInfo();
                if (!cri.isCRIChangable()) {
                    cri = WSConnectionRequestInfoImpl.createChangableCRIFromNon((WSConnectionRequestInfoImpl)cri);
                    this.managedConn.setCRI(cri);
                }
                cri.setShardingKey((Object)shardingKey);
                cri.setSuperShardingKey((Object)superShardingKey);
            }
        }
        catch (SQLException x) {
            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"104", (Object)this);
            throw this.proccessSQLException(x);
        }
        catch (NullPointerException x) {
            throw this.runtimeXIfNotClosed(x);
        }
    }
}

