/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing.soap;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Iterator;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.soap.MAPCodec;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DecoupledFaultHandler
extends AbstractSoapInterceptor {
    public static final String WSA_ACTION = "http://schemas.xmlsoap.org/wsdl/soap/envelope/fault";
    static final long serialVersionUID = -8806790084721011578L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public DecoupledFaultHandler() {
        super("pre-protocol");
        this.addBefore(MAPCodec.class.getName());
    }

    public void handleMessage(SoapMessage message) {
    }

    public void handleFault(@Sensitive SoapMessage message) {
        Exchange exchange;
        Message inMessage;
        AddressingProperties maps;
        if (!ContextUtils.isRequestor((Message)message) && (maps = ContextUtils.retrieveMAPs((Message)(inMessage = (exchange = message.getExchange()).getInMessage()), (boolean)false, (boolean)false, (boolean)true)) != null && !ContextUtils.isGenericAddress((EndpointReferenceType)maps.getFaultTo())) {
            if (exchange.getOutMessage() != null) {
                message = (SoapMessage)exchange.getOutMessage();
            }
            Iterator iterator = message.getHeaders().iterator();
            while (iterator.hasNext()) {
                Header header = (Header)iterator.next();
                if (this.isWSAHeader(header)) continue;
                iterator.remove();
            }
            exchange.setOneWay(false);
            exchange.setOutMessage((Message)message);
            message.put((Object)ContextUtils.ACTION, (Object)WSA_ACTION);
            Destination destination = this.createDecoupledDestination(exchange, maps.getFaultTo());
            exchange.setDestination(destination);
        }
    }

    protected Destination createDecoupledDestination(Exchange exchange, EndpointReferenceType epr) {
        return ContextUtils.createDecoupledDestination((Exchange)exchange, (EndpointReferenceType)epr);
    }

    private boolean isWSAHeader(Header header) {
        return header.getName().getNamespaceURI().startsWith("http://www.w3.org/2005/08/addressing");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.ws.addressing.soap.DecoupledFaultHandler", DecoupledFaultHandler.class, null, null);
    }
}

