/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.util.ThreadContextAccessor;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.security.AccessController;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JAXBUtils {
    private static final TraceComponent tc = Tr.register(JAXBUtils.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
    public static final String RI_JAXB_CONTEXT_FACTORY = "org.glassfish.jaxb.runtime.v2.ContextFactory";
    public static final String IBM_JAXB_CONTEXT_FACTORY = "org.glassfish.jaxb.runtime.v2.JAXBContextFactory";
    private static final ThreadContextAccessor THREAD_CONTEXT_ACCESSOR = (ThreadContextAccessor)AccessController.doPrivileged(ThreadContextAccessor.getPrivilegedAction());
    static final long serialVersionUID = -8160294296232821071L;

    public static JAXBContext newInstance(Class<?> ... classesToBeBound) throws JAXBException {
        ClassLoader originalContextClassLoader = THREAD_CONTEXT_ACCESSOR.getContextClassLoader(Thread.currentThread());
        try {
            THREAD_CONTEXT_ACCESSOR.setContextClassLoader(Thread.currentThread(), JAXBUtils.getJAXBContextProviderClassLoader());
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])classesToBeBound);
            return jAXBContext;
        }
        finally {
            THREAD_CONTEXT_ACCESSOR.setContextClassLoader(Thread.currentThread(), originalContextClassLoader);
        }
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    public static ClassLoader getJAXBContextProviderClassLoader() {
        Class<?> contextFactoryClass;
        block5: {
            contextFactoryClass = null;
            try {
                contextFactoryClass = Class.forName(IBM_JAXB_CONTEXT_FACTORY);
            }
            catch (ClassNotFoundException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to load IBM JAXB Context Factory org.glassfish.jaxb.runtime.v2.JAXBContextFactory", (Object[])new Object[0]);
                }
                try {
                    contextFactoryClass = Class.forName(RI_JAXB_CONTEXT_FACTORY);
                }
                catch (ClassNotFoundException e1) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)"Unable to load RI JAXB Context Factory org.glassfish.jaxb.runtime.v2.ContextFactory", (Object[])new Object[0]);
                }
            }
        }
        return contextFactoryClass == null ? JAXBUtils.class.getClassLoader() : contextFactoryClass.getClassLoader();
    }
}

