/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.db;

import io.opentelemetry.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.instrumentation.api.db.SqlStatementSanitizer;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.db.SqlClientAttributesGetter;

public abstract class DbClientSpanNameExtractor<REQUEST>
implements SpanNameExtractor<REQUEST> {
    private static final String DEFAULT_SPAN_NAME = "DB Query";

    public static <REQUEST> SpanNameExtractor<REQUEST> create(DbClientAttributesGetter<REQUEST> getter) {
        return new GenericDbClientSpanNameExtractor(getter);
    }

    public static <REQUEST> SpanNameExtractor<REQUEST> create(SqlClientAttributesGetter<REQUEST> getter) {
        return new SqlClientSpanNameExtractor(getter);
    }

    private DbClientSpanNameExtractor() {
    }

    protected String computeSpanName(String dbName, String operation, String table) {
        if (operation == null) {
            return dbName == null ? DEFAULT_SPAN_NAME : dbName;
        }
        StringBuilder name = new StringBuilder(operation);
        if (dbName != null || table != null) {
            name.append(' ');
        }
        if (dbName != null && (table == null || table.indexOf(46) == -1)) {
            name.append(dbName);
            if (table != null) {
                name.append('.');
            }
        }
        if (table != null) {
            name.append(table);
        }
        return name.toString();
    }

    private static final class GenericDbClientSpanNameExtractor<REQUEST>
    extends DbClientSpanNameExtractor<REQUEST> {
        private final DbClientAttributesGetter<REQUEST> getter;

        private GenericDbClientSpanNameExtractor(DbClientAttributesGetter<REQUEST> getter) {
            this.getter = getter;
        }

        @Override
        public String extract(REQUEST request) {
            String dbName = this.getter.name(request);
            String operation = this.getter.operation(request);
            return this.computeSpanName(dbName, operation, null);
        }
    }

    private static final class SqlClientSpanNameExtractor<REQUEST>
    extends DbClientSpanNameExtractor<REQUEST> {
        private static final SqlStatementSanitizer sanitizer = SqlStatementSanitizer.create(true);
        private final SqlClientAttributesGetter<REQUEST> getter;

        private SqlClientSpanNameExtractor(SqlClientAttributesGetter<REQUEST> getter) {
            this.getter = getter;
        }

        @Override
        public String extract(REQUEST request) {
            String dbName = this.getter.name(request);
            SqlStatementInfo sanitizedStatement = sanitizer.sanitize(this.getter.rawStatement(request));
            return this.computeSpanName(dbName, sanitizedStatement.getOperation(), sanitizedStatement.getTable());
        }
    }
}

