/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal;

import com.ibm.websphere.channelfw.CFEndPoint;
import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.OutboundChannelDefinition;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.CFEndPointSerializer;
import com.ibm.ws.channelfw.internal.ChainDataImpl;
import com.ibm.ws.channelfw.internal.ChannelFrameworkImpl;
import com.ibm.ws.channelfw.internal.OutboundChannelDefinitionImpl;
import com.ibm.ws.channelfw.internal.OutboundVirtualConnectionFactoryImpl;
import com.ibm.wsspi.channelfw.ChannelFactory;
import com.ibm.wsspi.channelfw.LocalChannelFactory;
import com.ibm.wsspi.channelfw.SSLChannelFactory;
import com.ibm.wsspi.channelfw.VirtualConnectionFactory;
import com.ibm.wsspi.channelfw.exception.ChannelFactoryException;
import com.ibm.wsspi.channelfw.exception.ChannelFrameworkException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CFEndPointImpl
implements CFEndPoint,
Serializable {
    private static final TraceComponent tc = Tr.register(CFEndPointImpl.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private static final long serialVersionUID = -4050856186139408312L;
    private String name = null;
    private List<String> vhostArray = null;
    private int port = 0;
    private InetAddress address = null;
    private LinkedList<OutboundChannelDefinition> outboundChannelDefs = null;
    private Class<?> channelAccessor = null;
    private int sslChannelIndex = -1;
    private int localChannelIndex = -1;
    private transient VirtualConnectionFactory vcf = null;
    private final transient ChannelFrameworkImpl framework = ChannelFrameworkImpl.getRef();
    private transient ChainData outboundChainData = null;

    public CFEndPointImpl(ChainDataImpl chainData) throws ChannelFrameworkException {
        try {
            String listenPortString;
            this.name = chainData.getName();
            this.outboundChannelDefs = new LinkedList();
            Map<Object, Object> chainProperties = chainData.getPropertyBag();
            String addressString = null;
            String portString = null;
            if (chainProperties != null) {
                addressString = (String)chainProperties.get("hostname");
                portString = (String)chainProperties.get("port");
                listenPortString = (String)chainProperties.get("listeningPort");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Resolving tcp properties: host=" + addressString + ", port=" + portString + ", listenPort=" + listenPortString), (Object[])new Object[0]);
                }
            } else {
                throw new IllegalArgumentException("No properties found in device side channel.  No CFEndPoint created.");
            }
            this.assignAddress(addressString);
            this.assignPort(portString, listenPortString);
            ChannelData[] channelList = chainData.getChannelList();
            ChannelFactory inboundFactory = null;
            HashMap<Object, Object> copyMap = null;
            Map<Object, Object> channelMap = null;
            for (int i = 0; i < channelList.length; ++i) {
                inboundFactory = this.framework.getChannelFactoryInternal(channelList[i].getFactoryType(), false);
                copyMap = new HashMap<Object, Object>();
                channelMap = channelList[i].getPropertyBag();
                if (channelMap != null) {
                    for (Map.Entry<Object, Object> entry : channelMap.entrySet()) {
                        copyMap.put(entry.getKey(), entry.getValue());
                    }
                }
                copyMap.put("chainData", chainData);
                OutboundChannelDefinition def = inboundFactory.getOutboundChannelDefinition(copyMap);
                if (null == def) continue;
                this.outboundChannelDefs.addFirst(def);
            }
            this.determineChannelAccessor();
            this.determineIsSSLEnabled();
            this.determineIsLocal();
            this.vhostArray = this.framework.getVhost(addressString, portString);
            if (null == this.vhostArray) {
                this.vhostArray = new ArrayList<String>(0);
            }
        }
        catch (Throwable t) {
            throw new ChannelFrameworkException(t);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("constructor: " + this), (Object[])new Object[0]);
        }
    }

    private void determineChannelAccessor() throws ChannelFrameworkException, ChannelFactoryException {
        OutboundChannelDefinition first = this.outboundChannelDefs.getFirst();
        Class<?> factoryClass = first.getOutboundFactory();
        if (factoryClass == null) {
            throw new ChannelFrameworkException("No factory class associated with outbound channel " + first);
        }
        ChannelFactory outboundFactory = this.framework.getChannelFactoryInternal(factoryClass, false);
        if (outboundFactory == null) {
            throw new ChannelFrameworkException("No channel factory could be found for factory class " + factoryClass);
        }
        this.channelAccessor = outboundFactory.getApplicationInterface();
    }

    private void determineIsSSLEnabled() {
        int i = 0;
        for (OutboundChannelDefinition def : this.outboundChannelDefs) {
            if (SSLChannelFactory.class.isAssignableFrom(def.getOutboundFactory())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found SSLChannelFactory interface: " + def.getOutboundFactory()), (Object[])new Object[0]);
                }
                this.sslChannelIndex = i;
                break;
            }
            ++i;
        }
    }

    private void determineIsLocal() {
        int i = 0;
        for (OutboundChannelDefinition def : this.outboundChannelDefs) {
            if (LocalChannelFactory.class.isAssignableFrom(def.getOutboundFactory())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found LocalChannelFactory interface: " + def.getOutboundFactory()), (Object[])new Object[0]);
                }
                this.localChannelIndex = i;
                break;
            }
            ++i;
        }
    }

    private void assignAddress(String addressString) throws ChannelFrameworkException, UnknownHostException {
        if (addressString == null) {
            throw new ChannelFrameworkException("No address available in properties.");
        }
        this.address = "*".equals(addressString) ? InetAddress.getLocalHost() : InetAddress.getByName(addressString);
    }

    private void assignPort(String portString, String listenPortString) throws ChannelFrameworkException, NumberFormatException {
        if (portString != null) {
            this.port = Integer.parseInt(portString);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Port set from regular tcp port: " + this.port), (Object[])new Object[0]);
            }
        } else if (listenPortString != null) {
            this.port = Integer.parseInt(listenPortString);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Port set from tcp listening port: " + this.port), (Object[])new Object[0]);
            }
        } else {
            throw new ChannelFrameworkException("Port not available in TCP channel properties.");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public List<String> getVirtualHosts() {
        if (null == this.vhostArray) {
            this.vhostArray = new ArrayList<String>(0);
        }
        return this.vhostArray;
    }

    @Override
    public List<OutboundChannelDefinition> getOutboundChannelDefs() {
        return this.outboundChannelDefs;
    }

    @Override
    public Class<?> getChannelAccessor() {
        return this.channelAccessor;
    }

    @Override
    public boolean isSSLEnabled() {
        return -1 != this.sslChannelIndex;
    }

    @Override
    public boolean isLocal() {
        return -1 != this.localChannelIndex;
    }

    protected void setOutboundChainData(ChainData inputChainData) {
        this.outboundChainData = inputChainData;
    }

    protected ChainData getOutboundChainData() {
        return this.outboundChainData;
    }

    @Override
    public synchronized ChainData createOutboundChain() throws ChannelFrameworkException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createOutboundChain", (Object[])new Object[0]);
        }
        if (this.outboundChainData == null) {
            this.outboundChainData = this.framework.createOutboundChain(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createOutboundChain");
        }
        return this.outboundChainData;
    }

    @Override
    public VirtualConnectionFactory getOutboundVCFactory(Map<Object, Object> sslProps, boolean overwriteExisting) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOutboundVCFactory(ssl)", (Object[])new Object[0]);
        }
        if (-1 == this.sslChannelIndex) {
            throw new IllegalStateException("The SSL channel factory does not exist in this CFEndPoint.");
        }
        OutboundChannelDefinition existingDef = this.outboundChannelDefs.get(this.sslChannelIndex);
        OutboundChannelDefinitionImpl newChannelDef = new OutboundChannelDefinitionImpl(existingDef, sslProps, overwriteExisting);
        this.outboundChannelDefs.add(this.sslChannelIndex, newChannelDef);
        VirtualConnectionFactory localVCF = this.getOutboundVCFactory();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOutboundVCFactory(ssl)");
        }
        return localVCF;
    }

    @Override
    public VirtualConnectionFactory getOutboundVCFactory() {
        OutboundVirtualConnectionFactoryImpl outboundVCF;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOutboundVCFactory", (Object[])new Object[0]);
        }
        if (this.vcf != null && (outboundVCF = (OutboundVirtualConnectionFactoryImpl)this.vcf).getRefCount() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found destroyed vcf, nulling it out to build another", (Object[])new Object[0]);
            }
            this.vcf = null;
        }
        if (this.vcf == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Existing vcf not available.  Build one.", (Object[])new Object[0]);
            }
            if (this.outboundChainData != null) {
                try {
                    this.vcf = this.framework.getOutboundVCFactory(this.outboundChainData.getName());
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Caught exception while getting VCFactory: " + e), (Object[])new Object[0]);
                    }
                    this.vcf = null;
                }
            } else {
                try {
                    this.framework.prepareEndPoint(this);
                }
                catch (ChannelFrameworkException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Caught exception while preparing CFEndPoint: " + e), (Object[])new Object[0]);
                    }
                    this.vcf = null;
                }
            }
        } else {
            outboundVCF = (OutboundVirtualConnectionFactoryImpl)this.vcf;
            outboundVCF.incrementRefCount();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found an existing VCF, updating the ref count to " + outboundVCF.getRefCount()), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOutboundVCFactory");
        }
        return this.vcf;
    }

    public void setOutboundVCFactory(VirtualConnectionFactory inputVCF) {
        this.vcf = inputVCF;
    }

    @Override
    public String serializeToXML() throws NotSerializableException {
        return CFEndPointSerializer.serialize(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("CFEndPoint@").append(this.hashCode());
        sb.append(' ').append(this.name);
        if (this.vhostArray == null || this.vhostArray.isEmpty()) {
            sb.append(",[null]");
        } else {
            sb.append(",[");
            for (String vhost : this.vhostArray) {
                sb.append(vhost);
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, ']');
        }
        sb.append(',').append(this.port);
        sb.append(',').append(this.address);
        sb.append(',').append(this.channelAccessor.getName());
        if (-1 != this.sslChannelIndex) {
            sb.append(",ssl=").append(this.sslChannelIndex);
        }
        if (-1 != this.localChannelIndex) {
            sb.append(",local=").append(this.localChannelIndex);
        }
        if (this.outboundChannelDefs != null && !this.outboundChannelDefs.isEmpty()) {
            sb.append(",[");
            for (OutboundChannelDefinition def : this.outboundChannelDefs) {
                sb.append(OutboundChannelDefinitionImpl.toString(def));
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, ']');
        }
        return sb.toString();
    }
}

