/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.gd.InternalOutputStream;
import com.ibm.ws.sib.processor.gd.SourceStream;
import com.ibm.ws.sib.processor.gd.Stream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.interfaces.DownstreamControl;
import com.ibm.ws.sib.processor.impl.interfaces.HealthStateListener;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.runtime.HealthState;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryStreamTransmitControllable;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryTransmitControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPTransmitMessageControllable;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.HealthStateTree;
import com.ibm.ws.sib.processor.runtime.impl.LinkPubSubTransmitMessageControl;
import com.ibm.ws.sib.processor.runtime.impl.TransmitMessageControllableIterator;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Iterator;
import java.util.LinkedList;

public class InternalOutputStreamControl
extends AbstractControlAdapter
implements SIMPDeliveryStreamTransmitControllable {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(InternalOutputStreamControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private InternalOutputStream _ioStream;
    private StreamSet _streamSet;
    private HealthState _healthState;
    private DownstreamControl _downControl;

    public InternalOutputStreamControl(InternalOutputStream sourceStream, StreamSet streamSet, DownstreamControl downControl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"InternalOutputStreamControl", (Object)new Object[]{sourceStream, streamSet, downControl});
        }
        this._ioStream = sourceStream;
        this._streamSet = streamSet;
        this._downControl = downControl;
        this._healthState = new HealthStateTree();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"InternalOutputStreamControl", (Object)this);
        }
    }

    public Reliability getReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReliability");
        }
        Reliability rel = this._ioStream.getReliability();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReliability", (Object)rel);
        }
        return rel;
    }

    public int getPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPriority");
        }
        int priority = this._ioStream.getPriority();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPriority", (Object)new Integer(priority));
        }
        return priority;
    }

    public int getNumberOfActiveMessages() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfActiveMessages");
        }
        int activeMessages = (int)this._ioStream.countAllMessagesOnStream();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfActiveMessages", (Object)new Integer(activeMessages));
        }
        return activeMessages;
    }

    public SIMPTransmitMessageControllable getTransmitMessageByID(String id) throws SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransmitMessageByID", (Object)id);
        }
        Iterator<TickRange> messagesOnStream = this._ioStream.getAllMessageItemsOnStream(true).iterator();
        LinkPubSubTransmitMessageControl transmitMessage = null;
        try {
            while (messagesOnStream.hasNext()) {
                long msgStoreId = -1L;
                TickRange tr = messagesOnStream.next();
                if (tr.value != null) continue;
                msgStoreId = tr.itemStreamIndex;
                if (Long.parseLong(id) != msgStoreId) continue;
                transmitMessage = new LinkPubSubTransmitMessageControl(msgStoreId, this._ioStream, this._downControl, this._streamSet.getControlAdapter());
            }
        }
        catch (SIResourceException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getTransmitMessageByID", (Object)((Object)e));
            }
            throw new SIMPRuntimeOperationFailedException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransmitMessageByID", transmitMessage);
        }
        return transmitMessage;
    }

    public SIMPIterator getTransmitMessagesIterator(int maxMsgs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransmitMessagesIterator");
        }
        TransmitMessageControllableIterator returnIterator = null;
        Iterator<TickRange> messagesOnStream = this._ioStream.getAllMessageItemsOnStream(true).iterator();
        LinkedList<LinkPubSubTransmitMessageControl> transmitMessages = new LinkedList<LinkPubSubTransmitMessageControl>();
        boolean allMsgs = maxMsgs == -1;
        int index = 0;
        while ((allMsgs || index < maxMsgs) && messagesOnStream.hasNext()) {
            try {
                TickRange tr = messagesOnStream.next();
                if (tr.value == null) {
                    transmitMessages.add(new LinkPubSubTransmitMessageControl(tr.itemStreamIndex, this._ioStream, this._downControl, this._streamSet.getControlAdapter()));
                } else {
                    transmitMessages.add(new LinkPubSubTransmitMessageControl((SIMPMessage)tr.value, (Stream)this._ioStream, this._streamSet.getControlAdapter()));
                }
                ++index;
            }
            catch (SIResourceException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        returnIterator = new TransmitMessageControllableIterator(transmitMessages.iterator());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransmitMessagesIterator", (Object)returnIterator);
        }
        return returnIterator;
    }

    public SIMPDeliveryTransmitControllable.StreamState getStreamState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        SourceStream.SourceStreamState returnState = this._ioStream.getStreamState();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)returnState);
        }
        return returnState;
    }

    public SIBUuid12 getStreamID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamID");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamID", (Object)this._streamSet.getStreamID());
        }
        return this._streamSet.getStreamID();
    }

    public String getName() {
        return null;
    }

    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String id = this._ioStream.getID();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)id);
        }
        return id;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._ioStream == null || this._streamSet == null) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"InternalOutputStreamControl.assertValidControllable", "1:300:1.40", this._streamSet, this._ioStream}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable", (Object)((Object)finalE));
            }
            throw finalE;
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this._ioStream = null;
        this._streamSet = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
    }

    public long getNumberOfMessagesSent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfMessagesSent");
        }
        long returnValue = this._ioStream.getTotalMessagesSent();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfMessagesSent", (Object)new Long(returnValue));
        }
        return returnValue;
    }

    @Override
    public String getRemoteEngineUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
        }
        String uuid = this._streamSet.getRemoteMEUuid().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)uuid);
        }
        return uuid;
    }

    public void moveMessage(String msgId, boolean discard) throws SIMPRuntimeOperationFailedException, SIMPControllableNotFoundException {
        SIMPTransmitMessageControllable xmitMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveMessage", (Object)new Object[]{msgId, new Boolean(discard)});
        }
        if ((xmitMsg = this.getTransmitMessageByID(msgId)) != null) {
            xmitMsg.moveMessage(discard);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveMessage");
        }
    }

    public HealthStateListener getHealthState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHealthState");
            SibTr.exit((TraceComponent)tc, (String)"getHealthState", (Object)this._healthState);
        }
        return (HealthStateListener)this._healthState;
    }

    public long getLastMsgSentTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLastMsgSentTime");
        }
        long time = this._ioStream.getLastMsgSentTime();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLastMsgSentTime", (Object)time);
        }
        return time;
    }
}

