/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.matching;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSetChangeCallback;

public class WrappedConsumerSetChangeCallback {
    private static final TraceComponent tc = SibTr.register(WrappedConsumerSetChangeCallback.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ConsumerSetChangeCallback callback;
    private int transition;

    public WrappedConsumerSetChangeCallback(ConsumerSetChangeCallback callback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"WrappedConsumerSetChangeCallback", (Object)new Object[]{callback});
        }
        this.callback = callback;
        this.transition = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"WrappedConsumerSetChangeCallback", (Object)this);
        }
    }

    public ConsumerSetChangeCallback getCallback() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCallback");
            SibTr.exit((TraceComponent)tc, (String)"getCallback", (Object)this.callback);
        }
        return this.callback;
    }

    public synchronized void transitionEvent(boolean isEmpty) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"transitionEvent", (Object)new Object[]{new Boolean(isEmpty)});
        }
        this.transition = isEmpty ? --this.transition : ++this.transition;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"transitionEvent", (Object)new Integer(this.transition));
        }
    }

    public synchronized void consumerSetChange() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"consumerSetChange");
        }
        if (this.transition < 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Negative transition, isEmpty is true");
            }
            this.callback.consumerSetChange(true);
        } else if (this.transition > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Positive transition, isEmpty is false");
            }
            this.callback.consumerSetChange(false);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Zero transition, no callback");
        }
        this.transition = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"consumerSetChange");
        }
    }

    public boolean equals(Object o) {
        ConsumerSetChangeCallback otherCB;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"equals", (Object)o);
        }
        boolean areEqual = false;
        if (o instanceof WrappedConsumerSetChangeCallback && this.callback.equals(otherCB = ((WrappedConsumerSetChangeCallback)o).getCallback())) {
            areEqual = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"equals", (Object)new Boolean(areEqual));
        }
        return areEqual;
    }

    public int hashCode() {
        return this.callback.hashCode();
    }
}

