/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationAliasDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.LWMConfig;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.admin.MQLinkDefinition;
import com.ibm.ws.sib.admin.MQLocalizationDefinition;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;

public abstract class JsAdminFactory {
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.internal.JsAdminFactory";
    private static final TraceComponent tc = SibTr.register(JsAdminFactory.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private static JsAdminFactory _instance = null;
    private static Exception createException = null;

    private static void createInstance() throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createInstance", null);
        }
        try {
            Class<?> cls = Class.forName("com.ibm.ws.sib.admin.internal.JsAdminFactoryImpl");
            _instance = (JsAdminFactory)cls.newInstance();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.internal.JsAdminFactory.<clinit>", (String)"10");
            SibTr.error((TraceComponent)tc, (String)"EXCP_DURING_INIT_SIEG0001", (Object)e);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createInstance");
        }
    }

    public static JsAdminFactory getInstance() throws Exception {
        if (_instance == null) {
            throw createException;
        }
        return _instance;
    }

    public abstract BaseDestinationDefinition createBaseDestinationDefinition(DestinationType var1, String var2);

    public abstract BaseDestinationDefinition createBaseDestinationDefinition(LWMConfig var1);

    public abstract DestinationDefinition createDestinationDefinition(DestinationType var1, String var2);

    public abstract DestinationDefinition createDestinationDefinition(LWMConfig var1);

    public abstract DestinationAliasDefinition createDestinationAliasDefinition(DestinationType var1, String var2);

    public abstract DestinationAliasDefinition createDestinationAliasDefinition(LWMConfig var1);

    public abstract LocalizationDefinition createLocalizationDefinition(String var1);

    public abstract LocalizationDefinition createLocalizationDefinition(LWMConfig var1);

    public abstract MQLocalizationDefinition createMQLocalizationDefinition(String var1);

    public abstract MQLocalizationDefinition createMQLocalizationDefinition(LWMConfig var1, LWMConfig var2, LWMConfig var3);

    public abstract MQLinkDefinition createMQLinkDefinition(String var1);

    static {
        try {
            JsAdminFactory.createInstance();
        }
        catch (Exception e) {
            createException = e;
        }
    }
}

