/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.cdi.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.impl.AbstractAnnotationConfig;
import com.ibm.ws.microprofile.faulttolerance.spi.FaultToleranceProvider;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TimeoutConfig
extends AbstractAnnotationConfig<Timeout> {
    private static final TraceComponent tc = Tr.register(TimeoutConfig.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.cdi.resources.FaultToleranceCDI");
    private final AbstractAnnotationConfig.AnnotationParameterConfig<Long> valueConfig = this.getParameterConfig("value", Long.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<ChronoUnit> unitConfig = this.getParameterConfig("unit", ChronoUnit.class);
    static final long serialVersionUID = 2404141368625968848L;

    public TimeoutConfig(Class<?> annotatedClass, Timeout annotation) {
        super(annotatedClass, annotation, Timeout.class);
    }

    public TimeoutConfig(Method annotatedMethod, Class<?> annotatedClass, Timeout annotation) {
        super(annotatedMethod, annotatedClass, annotation, Timeout.class);
    }

    private long value() {
        return this.valueConfig.getValue();
    }

    private ChronoUnit unit() {
        return this.unitConfig.getValue();
    }

    @Override
    public void validate() {
        String target = this.getTargetName();
        if (this.value() < 0L) {
            throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"timeout.parameter.invalid.value.CWMFT5011E", (Object[])new Object[]{this.value(), target}));
        }
    }

    public TimeoutPolicy generatePolicy() {
        Duration timeoutDuration = Duration.of(this.value(), this.unit());
        TimeoutPolicy timeoutPolicy = FaultToleranceProvider.newTimeoutPolicy();
        timeoutPolicy.setTimeout(timeoutDuration);
        return timeoutPolicy;
    }
}

