/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils.xml.ra;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jca.utils.xml.ra.RaAuthenticationMechanism;
import com.ibm.ws.jca.utils.xml.ra.RaConnectionDefinition;
import com.ibm.ws.jca.utils.xml.ra.v10.Ra10AuthenticationMechanism;
import com.ibm.ws.jca.utils.xml.ra.v10.Ra10ResourceAdapter;
import jakarta.resource.spi.TransactionSupport;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlType;
import java.util.LinkedList;
import java.util.List;

@Trivial
@XmlType(propOrder={"connectionDefinitions", "transactionSupport", "authenticationMechanisms", "reauthenticationSupport"})
public class RaOutboundResourceAdapter {
    private String transactionSupport;
    private String reauthenticationSupport;
    @XmlElement(name="connection-definition")
    private final List<RaConnectionDefinition> connectionDefinitions = new LinkedList<RaConnectionDefinition>();
    private List<RaAuthenticationMechanism> authenticationMechanisms = new LinkedList<RaAuthenticationMechanism>();
    @XmlID
    @XmlAttribute(name="id")
    private String id;

    public String getTransactionSupport() {
        return this.transactionSupport;
    }

    @XmlElement(name="transaction-support")
    public void setTransactionSupport(String transSup) {
        this.transactionSupport = transSup == null ? null : Enum.valueOf(TransactionSupport.TransactionSupportLevel.class, transSup).name();
    }

    public String getReauthenticationSupport() {
        return this.reauthenticationSupport;
    }

    @XmlElement(name="reauthentication-support")
    public void setReauthenticationSupport(String reauthenticationSupport) {
        this.reauthenticationSupport = reauthenticationSupport;
    }

    public List<RaConnectionDefinition> getConnectionDefinitions() {
        return this.connectionDefinitions;
    }

    public List<RaAuthenticationMechanism> getAuthenticationMechanisms() {
        return this.authenticationMechanisms;
    }

    @XmlElement(name="authentication-mechanism")
    public void setAuthenticationMechanisms(List<RaAuthenticationMechanism> authenticationMechanisms) {
        this.authenticationMechanisms = authenticationMechanisms;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RaOutboundResourceAdapter{");
        if (this.transactionSupport != null) {
            sb.append("transaction-support='").append(this.transactionSupport).append("' ");
        }
        if (this.reauthenticationSupport != null) {
            sb.append("reauthentication-support").append(this.reauthenticationSupport).append("' ");
        }
        sb.append("}");
        return sb.toString();
    }

    public RaConnectionDefinition getConnectionDefinitionByInterface(String connectionFactoryInterface) {
        for (RaConnectionDefinition connectionDefinition : this.connectionDefinitions) {
            if (!connectionDefinition.getConnectionFactoryInterface().equals(connectionFactoryInterface)) continue;
            return connectionDefinition;
        }
        return null;
    }

    public void copyRa10Settings(Ra10ResourceAdapter ra10resourceAdapter) {
        RaConnectionDefinition definition = new RaConnectionDefinition();
        definition.copyRa10Settings(ra10resourceAdapter);
        this.connectionDefinitions.add(definition);
        for (Ra10AuthenticationMechanism mech : ra10resourceAdapter.getAuthMechanisms()) {
            RaAuthenticationMechanism authMechanism = new RaAuthenticationMechanism();
            authMechanism.copyRa10Settings(mech);
            this.authenticationMechanisms.add(authMechanism);
        }
        this.reauthenticationSupport = ra10resourceAdapter.getReauthenticationSupport();
        this.transactionSupport = ra10resourceAdapter.getTransactionSupport();
    }
}

