/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.metrics;

import io.grpc.ManagedChannel;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.compression.Compressor;
import io.opentelemetry.exporter.internal.compression.CompressorUtil;
import io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.OtlpUserAgent;
import io.opentelemetry.exporter.otlp.metrics.MarshalerMetricsServiceGrpc;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OtlpGrpcMetricExporterBuilder {
    private static final String GRPC_SERVICE_NAME = "opentelemetry.proto.collector.metrics.v1.MetricsService";
    static final String GRPC_ENDPOINT_PATH = "/opentelemetry.proto.collector.metrics.v1.MetricsService/Export";
    private static final String DEFAULT_ENDPOINT_URL = "http://localhost:4317";
    private static final URI DEFAULT_ENDPOINT = URI.create("http://localhost:4317");
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private static final AggregationTemporalitySelector DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR = AggregationTemporalitySelector.alwaysCumulative();
    private static final MemoryMode DEFAULT_MEMORY_MODE = MemoryMode.REUSABLE_DATA;
    final GrpcExporterBuilder<Marshaler> delegate;
    private AggregationTemporalitySelector aggregationTemporalitySelector = DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR;
    private DefaultAggregationSelector defaultAggregationSelector = DefaultAggregationSelector.getDefault();
    private MemoryMode memoryMode;

    OtlpGrpcMetricExporterBuilder(GrpcExporterBuilder<Marshaler> delegate, MemoryMode memoryMode) {
        this.delegate = delegate;
        this.memoryMode = memoryMode;
        delegate.setMeterProvider(MeterProvider::noop);
        OtlpUserAgent.addUserAgentHeader(delegate::addConstantHeader);
    }

    OtlpGrpcMetricExporterBuilder() {
        this(new GrpcExporterBuilder<Marshaler>("otlp", "metric", 10L, DEFAULT_ENDPOINT, () -> MarshalerMetricsServiceGrpc::newFutureStub, GRPC_ENDPOINT_PATH), DEFAULT_MEMORY_MODE);
    }

    @Deprecated
    public OtlpGrpcMetricExporterBuilder setChannel(ManagedChannel channel) {
        this.delegate.setChannel(channel);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(timeout, unit);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        this.delegate.setTimeout(timeout);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setConnectTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout >= 0L, "timeout must be non-negative");
        this.delegate.setConnectTimeout(timeout, unit);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setConnectTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setConnectTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpGrpcMetricExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Compressor compressor = CompressorUtil.validateAndResolveCompressor(compressionMethod);
        this.delegate.setCompression(compressor);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.setTrustManagerFromCerts(trustedCertificatesPem);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.setKeyManagerFromCerts(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        this.delegate.setSslContext(sslContext, trustManager);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder addHeader(String key, String value) {
        this.delegate.addConstantHeader(key, value);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setHeaders(Supplier<Map<String, String>> headerSupplier) {
        this.delegate.setHeadersSupplier(headerSupplier);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setAggregationTemporalitySelector(AggregationTemporalitySelector aggregationTemporalitySelector) {
        Objects.requireNonNull(aggregationTemporalitySelector, "aggregationTemporalitySelector");
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setDefaultAggregationSelector(DefaultAggregationSelector defaultAggregationSelector) {
        Objects.requireNonNull(defaultAggregationSelector, "defaultAggregationSelector");
        this.defaultAggregationSelector = defaultAggregationSelector;
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setRetryPolicy(@Nullable RetryPolicy retryPolicy) {
        this.delegate.setRetryPolicy(retryPolicy);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setMemoryMode(MemoryMode memoryMode) {
        Objects.requireNonNull(memoryMode, "memoryMode");
        this.memoryMode = memoryMode;
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setServiceClassLoader(ClassLoader serviceClassLoader) {
        Objects.requireNonNull(serviceClassLoader, "serviceClassLoader");
        this.delegate.setServiceClassLoader(serviceClassLoader);
        return this;
    }

    public OtlpGrpcMetricExporter build() {
        return new OtlpGrpcMetricExporter(this.delegate, this.delegate.build(), this.aggregationTemporalitySelector, this.defaultAggregationSelector, this.memoryMode);
    }
}

