/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util;

import java.util.AbstractCollection;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public enum Collectors {


    public static <E extends Enum<E>> Collector<E, ?, Set<E>> toUnmodifiableEnumSet(final Class<E> enumClass) {
        return new Collector<E, EnumSet<E>, Set<E>>(){

            @Override
            public Supplier<EnumSet<E>> supplier() {
                return () -> EnumSet.noneOf(enumClass);
            }

            @Override
            public BiConsumer<EnumSet<E>, E> accumulator() {
                return AbstractCollection::add;
            }

            @Override
            public BinaryOperator<EnumSet<E>> combiner() {
                return (a, b) -> {
                    a.addAll(b);
                    return a;
                };
            }

            @Override
            public Function<EnumSet<E>, Set<E>> finisher() {
                return Collections::unmodifiableSet;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return EnumSet.of(Collector.Characteristics.UNORDERED);
            }
        };
    }

    public static <K, T> Collector<T, ?, Map<K, T>> toUnmodifiableMap(final Supplier<Map<K, T>> supplier, final Function<T, K> keyFunction) {
        return new Collector<T, Map<K, T>, Map<K, T>>(){

            @Override
            public Supplier<Map<K, T>> supplier() {
                return supplier;
            }

            @Override
            public BiConsumer<Map<K, T>, T> accumulator() {
                return (m, t) -> m.put(keyFunction.apply(t), t);
            }

            @Override
            public BinaryOperator<Map<K, T>> combiner() {
                return (m1, m2) -> {
                    m1.putAll(m2);
                    return m1;
                };
            }

            @Override
            public Function<Map<K, T>, Map<K, T>> finisher() {
                return Collections::unmodifiableMap;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return EnumSet.of(Collector.Characteristics.UNORDERED);
            }
        };
    }

    public static <T> Collector<T, ?, BitSet> toBitSet(final Function<T, Integer> intMapper) {
        return new Collector<T, BitSet, BitSet>(){

            @Override
            public Supplier<BitSet> supplier() {
                return BitSet::new;
            }

            @Override
            public BiConsumer<BitSet, T> accumulator() {
                return (bs, t) -> bs.set((Integer)intMapper.apply(t));
            }

            @Override
            public BinaryOperator<BitSet> combiner() {
                return (a, b) -> {
                    a.and((BitSet)b);
                    return a;
                };
            }

            @Override
            public Function<BitSet, BitSet> finisher() {
                return bs -> bs;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
            }
        };
    }
}

