/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI.IIOP;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.omg.IIOP.ListenPoint;

public final class ListenerMap {
    private final Set<EndPoint> endPoints = new LinkedHashSet<EndPoint>();

    public void add(String host, short port) {
        this.endPoints.add(new EndPoint(host, port));
    }

    public void remove(String host, short port) {
        this.endPoints.remove(new EndPoint(host, port));
    }

    public ListenPoint[] getListenPoints() {
        ArrayList<ListenPoint> listenPoints = new ArrayList<ListenPoint>();
        for (EndPoint ep : this.endPoints) {
            listenPoints.add(ep.asListenPoint());
        }
        return listenPoints.toArray(new ListenPoint[0]);
    }

    static final class EndPoint {
        static final String _ob_id = "IDL:omg.org/IIOP/ListenPoint:1.0";
        final String host;
        final short port;

        EndPoint(String host, short port) {
            this.host = host;
            this.port = port;
        }

        ListenPoint asListenPoint() {
            return new ListenPoint(this.host, this.port);
        }

        public boolean equals(Object theOther) {
            if (this == theOther) {
                return true;
            }
            if (theOther == null || this.getClass() != theOther.getClass()) {
                return false;
            }
            ListenPoint that = (ListenPoint)theOther;
            return this.port == that.port && Objects.equals(this.host, that.host);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port);
        }
    }
}

