/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.IOP;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.yoko.util.MinorCodes;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.IOP.ServiceContext;

public final class MutableServiceContexts {
    private final Map<Integer, ServiceContext> contexts;

    protected MutableServiceContexts(Map<Integer, ServiceContext> contexts) {
        this.contexts = contexts;
    }

    private static ServiceContext copy(ServiceContext sc) {
        if (sc == null) {
            return null;
        }
        ServiceContext result = new ServiceContext();
        result.context_id = sc.context_id;
        result.context_data = Arrays.copyOf(sc.context_data, sc.context_data.length);
        return result;
    }

    public ServiceContext get(int id) {
        return MutableServiceContexts.copy(this.contexts.get(id));
    }

    public void add(ServiceContext context, boolean okToReplace) {
        if (okToReplace) {
            this.add(context);
        } else if (!this.addIfAbsent(context)) {
            throw MutableServiceContexts.newBadInvOrder(1330446351, context.context_id);
        }
    }

    private boolean addIfAbsent(ServiceContext context) {
        if (this.contexts instanceof ConcurrentMap) {
            return null == ((ConcurrentMap)this.contexts).putIfAbsent(context.context_id, MutableServiceContexts.copy(context));
        }
        if (this.contexts.containsKey(context.context_id)) {
            return false;
        }
        this.contexts.put(context.context_id, MutableServiceContexts.copy(context));
        return true;
    }

    private static BAD_INV_ORDER newBadInvOrder(int minorCode, int id) {
        return new BAD_INV_ORDER(MinorCodes.describeBadInvOrder((int)minorCode) + ": " + id, minorCode, CompletionStatus.COMPLETED_NO);
    }

    public void add(ServiceContext context) {
        this.contexts.put(context.context_id, MutableServiceContexts.copy(context));
    }
}

