/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.objectManager;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.SimplifiedSerialization;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PersistableSlicedData
extends ManagedObject
implements SimplifiedSerialization {
    private static final long serialVersionUID = 1876240915914565653L;
    private static TraceComponent tc = SibTr.register(PersistableSlicedData.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private List<DataSlice> _dataSlices;
    private long _estimatedLength = -1L;
    private static long _estimatedLengthHeader;

    public void setData(List<DataSlice> dataSlices) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setData", (Object)("DataSlices=" + dataSlices));
        }
        this._dataSlices = dataSlices;
        this._estimatedLength = -1L;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setData");
        }
    }

    public List<DataSlice> getData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getData");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getData", (Object)("return=" + this._dataSlices));
        }
        return this._dataSlices;
    }

    @Override
    public void becomeCloneOf(ManagedObject clone) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"becomeCloneOf", (Object)("Clone=" + clone));
        }
        PersistableSlicedData object = (PersistableSlicedData)clone;
        this._dataSlices = object._dataSlices;
        this._estimatedLength = -1L;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"becomeCloneOf");
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append("(PersistableSlicedData[ BINARYDATA ])");
        return buffer.toString();
    }

    @Override
    public long estimatedLength() {
        if (this._estimatedLength == -1L) {
            this._estimatedLength = _estimatedLengthHeader + 12L;
            if (this._dataSlices != null) {
                for (DataSlice slice : this._dataSlices) {
                    this._estimatedLength += 4L;
                    this._estimatedLength += (long)slice.getLength();
                }
            }
        }
        return this._estimatedLength;
    }

    @Override
    public void writeObject(DataOutputStream dataOutputStream) throws ObjectManagerException, IOException {
        super.writeObject(dataOutputStream);
        dataOutputStream.writeLong(1876240915914565653L);
        if (this._dataSlices != null) {
            dataOutputStream.writeInt(this._dataSlices.size());
            for (DataSlice slice : this._dataSlices) {
                dataOutputStream.writeInt(slice.getLength());
                dataOutputStream.write(slice.getBytes(), slice.getOffset(), slice.getLength());
            }
        } else {
            dataOutputStream.writeInt(0);
        }
    }

    @Override
    public void readObject(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException, IOException {
        super.readObject(dataInputStream, objectManagerState);
        dataInputStream.readLong();
        int count = dataInputStream.readInt();
        this._dataSlices = new ArrayList<DataSlice>(count);
        for (int i = 0; i < count; ++i) {
            int length = dataInputStream.readInt();
            byte[] bytes = new byte[length];
            dataInputStream.readFully(bytes, 0, length);
            DataSlice slice = new DataSlice(bytes, 0, length);
            this._dataSlices.add(slice);
        }
    }

    static {
        try {
            _estimatedLengthHeader = new PersistableSlicedData().getSerializedBytesLength();
            _estimatedLengthHeader += 64L;
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Exception caught initialising _estimatedLengthHeader!", (Object)e);
            }
            _estimatedLengthHeader = 150L;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("_estimatedLengthHeader=" + _estimatedLengthHeader));
        }
    }
}

