/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager.utils;

import com.ibm.ws.objectManager.utils.AbstractTrace;
import com.ibm.ws.objectManager.utils.NLS;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.TraceFactory;
import com.ibm.ws.objectManager.utils.TraceImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class AbstractTraceFactory
extends TraceFactory {
    private static final Class cclass = AbstractTraceFactory.class;
    final Map activeTrace = new HashMap();

    public AbstractTraceFactory(NLS nls) {
        super(nls);
        this.setPrintWriter(new PrintWriter(System.out, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Trace getTrace(Class sourceClass, String traceGroup) {
        Map map = this.activeTrace;
        synchronized (map) {
            TraceImpl traceImpl = new TraceImpl(sourceClass, traceGroup, this);
            this.activeTrace.put(sourceClass, traceImpl);
            try {
                this.applyActiveTrace();
            }
            catch (IOException exception) {
                System.out.println(cclass + ":getTrace() exception" + exception);
                exception.printStackTrace();
            }
            return traceImpl;
        }
    }

    @Override
    public final void setActiveTrace(String activeNames, int traceLevel) throws IOException {
        super.setActiveTrace(activeNames, traceLevel);
        this.applyActiveTrace();
    }

    void applyActiveTrace() throws IOException {
        String[] names = activeNames.split(":");
        for (AbstractTrace abstractTrace : this.activeTrace.values()) {
            int traceLevelToSet = 5;
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                if (name.equals("*")) {
                    name = ".*";
                }
                if (!Pattern.matches(name, abstractTrace.getSourceClass().getName())) continue;
                traceLevelToSet = traceLevel;
            }
            abstractTrace.setLevel(traceLevelToSet);
        }
    }
}

