/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.AbstractMapEntry;
import com.ibm.ws.objectManager.AbstractTreeMap;
import com.ibm.ws.objectManager.ClassNotFoundException;
import com.ibm.ws.objectManager.CollectionNotEmptyException;
import com.ibm.ws.objectManager.DuplicateKeyException;
import com.ibm.ws.objectManager.InternalTransaction;
import com.ibm.ws.objectManager.InvalidStateException;
import com.ibm.ws.objectManager.Iterator;
import com.ibm.ws.objectManager.LogFileFullException;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ManagedObjectInputStream;
import com.ibm.ws.objectManager.Map;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.ObjectStore;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.SimplifiedSerialization;
import com.ibm.ws.objectManager.SimplifiedSerializationSizeException;
import com.ibm.ws.objectManager.SortedMap;
import com.ibm.ws.objectManager.StateErrorException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.TransactionAddLogRecord;
import com.ibm.ws.objectManager.TransactionLock;
import com.ibm.ws.objectManager.TransactionOptimisticReplaceLogRecord;
import com.ibm.ws.objectManager.utils.Printable;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;

public class TreeMap
extends AbstractTreeMap
implements SortedMap,
SimplifiedSerialization,
Printable {
    private static final Class cclass = TreeMap.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerMaps");
    private static final long serialVersionUID = -9183890410133257833L;
    private static final long logSpaceForAdd = TransactionOptimisticReplaceLogRecord.maximumSerializedSize() + 4L + TreeMap.maximumSerializedSize() + 64L * Entry.maximumSerializedSize() + TransactionOptimisticReplaceLogRecord.maximumSerializedSize() + 4L + Token.maximumSerializedSize() * 65L;
    private static final long logSpaceForDelete = TransactionOptimisticReplaceLogRecord.maximumSerializedSize() + 4L + Token.maximumSerializedSize() * 1L + TreeMap.maximumSerializedSize() + 64L * Entry.maximumSerializedSize() + TransactionOptimisticReplaceLogRecord.maximumSerializedSize() + 4L + Token.maximumSerializedSize() * 66L;
    protected transient long availableSize;
    private transient Set managedObjectsToAdd;
    private transient Set managedObjectsToReplace;
    private transient Set tokensToNotify;
    transient long reservedSpaceInStore;
    private static final byte SimpleSerialVersion = 0;

    public TreeMap(Transaction transaction, ObjectStore objectStore) throws ObjectManagerException {
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{transaction, objectStore});
        }
        objectStore.allocate(this);
        this.reserveAndAdd(transaction, objectStore);
        this.managedObjectsToAdd = new HashSet(1);
        this.managedObjectsToReplace = new HashSet();
        this.tokensToNotify = new HashSet(1);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    void reserveAndAdd(Transaction transaction, ObjectStore objectStore) throws ObjectManagerException {
        this.reservedSpaceInStore = TreeMap.maximumSerializedSize() + (long)this.owningToken.objectStore.getAddSpaceOverhead();
        this.owningToken.objectStore.reserve((int)this.reservedSpaceInStore, true);
        transaction.add(this);
        this.owningToken.objectStore.reserve(-((int)this.reservedSpaceInStore), false);
    }

    public TreeMap(Comparator comparator, Transaction transaction, ObjectStore objectStore) throws ObjectManagerException {
        super(comparator);
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{comparator, transaction, objectStore});
        }
        objectStore.allocate(this);
        this.reservedSpaceInStore = TreeMap.maximumSerializedSize() + (long)this.owningToken.objectStore.getAddSpaceOverhead();
        this.owningToken.objectStore.reserve((int)this.reservedSpaceInStore, true);
        transaction.add(this);
        this.owningToken.objectStore.reserve(-((int)this.reservedSpaceInStore), false);
        this.managedObjectsToAdd = new HashSet(1);
        this.managedObjectsToReplace = new HashSet();
        this.tokensToNotify = new HashSet(1);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    public TreeMap(SortedMap map, Transaction transaction, ObjectStore objectStore) throws ObjectManagerException {
        this(transaction, objectStore);
        this.putAll(map, transaction);
    }

    @Override
    AbstractTreeMap.Entry makeEntry(Object key) throws ObjectManagerException {
        throw new UnsupportedOperationException("makeEntry not supported");
    }

    @Override
    AbstractTreeMap.Entry makeEntry(Object key, Token value) throws ObjectManagerException {
        throw new UnsupportedOperationException("makeEntry not supported");
    }

    @Override
    Iterator makeTreeMapIterator(AbstractMapEntry.Type value) throws ObjectManagerException {
        return new TreeMapIterator(value);
    }

    @Override
    Iterator makeTreeMapIterator(AbstractMapEntry.Type value, AbstractTreeMap.Entry startNode, boolean checkEnd, Object end) throws ObjectManagerException {
        return new TreeMapIterator(value, startNode, checkEnd, end);
    }

    @Override
    AbstractTreeMap.SubMap makeSubMap(Object start, Object end) {
        return new SubMap(start, this, end);
    }

    long storeSpaceForRemove() {
        return TreeMap.maximumSerializedSize() + 64L * Entry.maximumSerializedSize() + (long)(65 * this.owningToken.objectStore.getAddSpaceOverhead());
    }

    long storeSpaceForAdd() {
        return TreeMap.maximumSerializedSize() + 64L * Entry.maximumSerializedSize() + (long)(65 * this.owningToken.objectStore.getAddSpaceOverhead()) + this.storeSpaceForRemove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size(Transaction transaction) throws ObjectManagerException {
        long sizeFound;
        TreeMap treeMap = this;
        synchronized (treeMap) {
            sizeFound = this.availableSize;
            if (transaction != null) {
                Entry entry = this.firstEntry(transaction);
                while (entry != null) {
                    if (entry.state == 2 && entry.lockedBy(transaction)) {
                        ++sizeFound;
                    }
                    entry = this.successor(entry, transaction);
                }
            }
        }
        return sizeFound;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public synchronized boolean isEmpty(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "isEmpty", new Object[]{transaction});
        }
        boolean returnValue = this.firstEntry(transaction) == null;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "isEmpty", new Object[]{new Boolean(returnValue)});
        }
        return returnValue;
    }

    @Override
    public synchronized boolean containsKey(Object key, Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "get", new Object[]{key, transaction});
        }
        boolean returnValue = false;
        if (this.getEntry(key, transaction) != null) {
            returnValue = true;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "containsKey", "returns " + returnValue + "(boolean)");
        }
        return returnValue;
    }

    @Override
    public synchronized Token get(Object key, Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "get", new Object[]{key, transaction});
        }
        Entry entry = this.getEntry(key, transaction);
        Token value = null;
        if (entry != null) {
            value = entry.getValue();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "get", new Object[]{entry, value});
        }
        return value;
    }

    private synchronized Entry getEntry(Object key, Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "getEntry", new Object[]{key, transaction});
        }
        Entry entry = this.getEntry(key);
        long transactionUnlockPoint = Long.MAX_VALUE;
        if (transaction != null) {
            transactionUnlockPoint = transaction.getTransactionUnlockSequence();
        }
        while (!(entry == null || entry.state == 3 && !entry.wasLocked(transactionUnlockPoint) || entry.state == 2 && transaction != null && entry.lockedBy(transaction))) {
            if ((entry = (Entry)TreeMap.successor(entry)) == null || this.compare(key, entry.key) == 0) continue;
            entry = null;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getEntry", new Object[]{entry});
        }
        return entry;
    }

    @Override
    public synchronized Object firstKey(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "firstKey", new Object[]{transaction});
        }
        Entry entry = this.firstEntry(transaction);
        Object returnKey = entry.getKey();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "firstKey", new Object[]{returnKey});
        }
        return returnKey;
    }

    @Override
    public synchronized Object lastKey(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "lastKey", new Object[]{transaction});
        }
        Entry entry = this.lastEntry(transaction);
        Object returnKey = entry.getKey();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "lastKey", new Object[]{returnKey});
        }
        return returnKey;
    }

    @Override
    public void putAll(Map otherMap, Transaction transaction) throws ObjectManagerException {
        long transactionUnlockPoint = Long.MAX_VALUE;
        if (transaction != null) {
            transactionUnlockPoint = transaction.getTransactionUnlockSequence();
        }
        Iterator iterator = otherMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if ((entry.state != 3 || entry.wasLocked(transactionUnlockPoint)) && (entry.state != 2 || !entry.lockedBy(transaction))) continue;
            this.put(entry.getKey(), entry.getValue(), transaction);
        }
    }

    private Entry getEntry(Object key) throws ObjectManagerException {
        Entry entry;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "getEntry", new Object[]{key});
        }
        if ((entry = (Entry)super.find(key)) != null) {
            Entry predecessor;
            while ((predecessor = (Entry)TreeMap.predecessor(entry)) != null && this.compare(key, predecessor.key) == 0) {
                entry = predecessor;
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getEntry", new Object[]{entry});
        }
        return entry;
    }

    @Override
    public synchronized Token put(Object key, Token value, Transaction transaction) throws ObjectManagerException {
        return this.put(key, value, transaction, false);
    }

    public synchronized void putDuplicate(Object key, Token value, Transaction transaction) throws ObjectManagerException {
        this.put(key, value, transaction, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token put(Object key, Token value, Transaction transaction, boolean allowDuplicates) throws ObjectManagerException {
        String methodName = "put";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "put", new Object[]{key, value, transaction, new Boolean(allowDuplicates)});
        }
        Token returnValue = null;
        boolean mustBeDeleted = false;
        InternalTransaction internalTransaction = transaction.internalTransaction;
        synchronized (internalTransaction) {
            TreeMap treeMap = this;
            synchronized (treeMap) {
                if (!(this.state == 8 || this.state == 2 && this.lockedBy(transaction))) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "put", new Object[]{new Integer(this.state), stateNames[this.state]});
                    }
                    throw new InvalidStateException((Object)this, this.state, stateNames[this.state]);
                }
                this.managedObjectsToReplace.clear();
                this.reservedSpaceInStore = this.storeSpaceForAdd() + this.storeSpaceForRemove();
                this.owningToken.objectStore.reserve((int)this.reservedSpaceInStore, false);
                try {
                    if (this.root == null) {
                        Entry newEntry = new Entry(this, key, value, null, transaction);
                        transaction.add(newEntry, logSpaceForAdd + logSpaceForDelete);
                        this.setRoot(newEntry);
                        ++this.size;
                    } else {
                        Entry currentEntry = (Entry)this.getRoot();
                        while (true) {
                            Entry newEntry;
                            int comparison = this.compare(key, currentEntry.key);
                            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                                trace.debug((Object)this, cclass, "put", new Object[]{currentEntry});
                            }
                            if (comparison == 0) {
                                if (allowDuplicates) {
                                    this.add(key, value, currentEntry, transaction, logSpaceForAdd + logSpaceForDelete);
                                    break;
                                }
                                if (currentEntry.state == 3 || currentEntry.state == 2 && currentEntry.lockedBy(transaction)) {
                                    transaction.delete(currentEntry, logSpaceForAdd + 2L * logSpaceForDelete + TransactionAddLogRecord.maximumSerializedSize());
                                    currentEntry.requestDelete(transaction);
                                    if (currentEntry.state == 5) {
                                        --this.availableSize;
                                    } else {
                                        mustBeDeleted = true;
                                    }
                                    returnValue = currentEntry.getValue();
                                    this.add(key, value, currentEntry, transaction, -TransactionAddLogRecord.maximumSerializedSize());
                                    break;
                                }
                                if (currentEntry.willBeDeleted(transaction)) {
                                    Entry nextEntry = (Entry)TreeMap.successor(currentEntry);
                                    if (nextEntry != null && this.compare(key, nextEntry.key) == 0) {
                                        currentEntry = nextEntry;
                                        continue;
                                    }
                                    this.add(key, value, currentEntry, transaction, logSpaceForAdd + logSpaceForDelete);
                                    break;
                                }
                                InternalTransaction lockingTransaction = null;
                                TransactionLock transactionLock = currentEntry.getTransactionLock();
                                if (transactionLock != null && transactionLock.isLocked()) {
                                    lockingTransaction = transactionLock.getLockingTransaction();
                                }
                                this.undoPut();
                                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                    trace.exit((Object)this, cclass, "put", "via DuplicateKeyException currentEntry.state =" + currentEntry.state + "(int) " + stateNames[currentEntry.state] + "(String)");
                                }
                                throw new DuplicateKeyException(this, key, currentEntry, lockingTransaction);
                            }
                            if (comparison < 0) {
                                if (currentEntry.left == null) {
                                    newEntry = new Entry(this, key, value, currentEntry, transaction);
                                    transaction.add(newEntry, logSpaceForAdd + logSpaceForDelete);
                                    ++this.size;
                                    currentEntry.setLeft(newEntry);
                                    this.balance(newEntry);
                                    break;
                                }
                                currentEntry = (Entry)currentEntry.getLeft();
                                continue;
                            }
                            if (currentEntry.right == null) {
                                newEntry = new Entry(this, key, value, currentEntry, transaction);
                                transaction.add(newEntry, logSpaceForAdd + logSpaceForDelete);
                                ++this.size;
                                currentEntry.setRight(newEntry);
                                this.balance(newEntry);
                                break;
                            }
                            currentEntry = (Entry)currentEntry.getRight();
                        }
                    }
                    this.managedObjectsToReplace.add(this);
                    transaction.optimisticReplace(null, new ArrayList(this.managedObjectsToReplace), null, null, -logSpaceForAdd);
                    if (returnValue == null || mustBeDeleted) {
                        this.owningToken.objectStore.reserve((int)(this.storeSpaceForRemove() - this.reservedSpaceInStore), false);
                    } else {
                        this.owningToken.objectStore.reserve((int)(this.storeSpaceForRemove() * 2L - this.reservedSpaceInStore), false);
                    }
                }
                catch (InvalidStateException exception) {
                    this.undoPut();
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "put", exception);
                    }
                    throw exception;
                }
                catch (LogFileFullException exception) {
                    this.undoPut();
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "put", exception);
                    }
                    throw exception;
                }
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "put", new Object[]{returnValue});
        }
        return returnValue;
    }

    private void add(Object key, Token value, Entry currentEntry, Transaction transaction, long logSpaceDelta) throws ObjectManagerException {
        Entry newEntry;
        String methodName = "add";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "add", new Object[]{key, value, currentEntry, transaction, new Long(logSpaceDelta)});
        }
        while (true) {
            if (this.compare(key, currentEntry.key) < 0) {
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "add", new Object[]{"Less than branch.", currentEntry.key});
                }
                if (currentEntry.left == null) {
                    newEntry = new Entry(this, key, value, currentEntry, transaction);
                    transaction.add(newEntry, logSpaceDelta);
                    currentEntry.setLeft(newEntry);
                    break;
                }
                currentEntry = (Entry)currentEntry.getLeft();
                continue;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "add", new Object[]{"Greater than branch.", currentEntry.key});
            }
            if (currentEntry.right == null) {
                newEntry = new Entry(this, key, value, currentEntry, transaction);
                transaction.add(newEntry, logSpaceDelta);
                currentEntry.setRight(newEntry);
                break;
            }
            currentEntry = (Entry)currentEntry.getRight();
        }
        ++this.size;
        this.balance(newEntry);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "add");
        }
    }

    private void undoPut() throws ObjectManagerException {
        String methodName = "undoPut";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "undoPut");
        }
        this.owningToken.objectStore.reserve((int)(-this.reservedSpaceInStore), false);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "undoPut");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Token remove(Object key, Transaction transaction) throws ObjectManagerException {
        String methodName = "remove";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "remove", new Object[]{key, transaction});
        }
        Token returnValue = null;
        Entry entry = this.getEntry(key);
        if (entry != null) {
            boolean spaceReserved = false;
            long transactionUnlockPoint = Long.MAX_VALUE;
            if (transaction != null) {
                transactionUnlockPoint = transaction.getTransactionUnlockSequence();
            }
            try {
                InternalTransaction internalTransaction = transaction.internalTransaction;
                synchronized (internalTransaction) {
                    TreeMap treeMap = this;
                    synchronized (treeMap) {
                        while (entry != null && this.compare(key, entry.key) == 0) {
                            if (entry.state == 2 && entry.lockedBy(transaction)) {
                                transaction.delete(entry, logSpaceForDelete);
                                returnValue = entry.getValue();
                                entry.requestDelete(transaction);
                                break;
                            }
                            if (entry.state == 3 && !entry.wasLocked(transactionUnlockPoint)) {
                                this.owningToken.objectStore.reserve((int)this.storeSpaceForRemove(), false);
                                spaceReserved = true;
                                transaction.delete(entry, logSpaceForDelete);
                                returnValue = entry.getValue();
                                entry.requestDelete(transaction);
                                --this.availableSize;
                                break;
                            }
                            entry = (Entry)TreeMap.successor(entry);
                        }
                    }
                }
            }
            catch (LogFileFullException exception) {
                if (spaceReserved) {
                    this.owningToken.objectStore.reserve(-((int)this.storeSpaceForRemove()), false);
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "remove", exception);
                }
                throw exception;
            }
            catch (InvalidStateException exception) {
                ObjectManager.ffdc.processException(this, cclass, "remove", exception, "1:1057:1.44");
                if (spaceReserved) {
                    this.owningToken.objectStore.reserve(-((int)this.storeSpaceForRemove()), false);
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "remove", exception);
                }
                throw exception;
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "remove", new Object[]{returnValue});
        }
        return returnValue;
    }

    @Override
    public synchronized void clear(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "cleartransaction=" + transaction + "(Transaction)");
        }
        Entry entry = this.firstEntry(transaction);
        while (entry != null) {
            entry.remove(transaction);
            entry = this.successor(entry, transaction);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "clear");
        }
    }

    @Override
    public Iterator iterator() throws ObjectManagerException {
        return this.values().iterator();
    }

    private int compare(Object key1, Object key2) {
        if (this.comparator == null) {
            return ((Comparable)key1).compareTo(key2);
        }
        return this.comparator.compare(key1, key2);
    }

    private Entry findAfter(Object key, Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "findAfter", new Object[]{key, transaction});
        }
        Entry entry = (Entry)this.findAfter(key);
        long transactionUnlockPoint = Long.MAX_VALUE;
        if (transaction != null) {
            transactionUnlockPoint = transaction.getTransactionUnlockSequence();
        }
        while (!(entry == null || entry.state == 3 && !entry.wasLocked(transactionUnlockPoint) || entry.state == 2 && entry.lockedBy(transaction))) {
            entry = (Entry)TreeMap.successor(entry);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "findAfter", new Object[]{entry});
        }
        return entry;
    }

    private Entry findBefore(Object key, Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "findBefore", new Object[]{key, transaction});
        }
        Entry entry = (Entry)this.findBefore(key);
        long transactionUnlockPoint = Long.MAX_VALUE;
        if (transaction != null) {
            transactionUnlockPoint = transaction.getTransactionUnlockSequence();
        }
        while (!(entry == null || entry.state == 3 && !entry.wasLocked(transactionUnlockPoint) || entry.state == 2 && entry.lockedBy(transaction))) {
            entry = (Entry)TreeMap.predecessor(entry);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "firstBefore", new Object[]{entry});
        }
        return entry;
    }

    private Entry firstEntry(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "firstEntry", new Object[]{transaction});
        }
        Entry entry = null;
        if (this.root != null) {
            entry = (Entry)TreeMap.minimum(this.getRoot());
        }
        long transactionUnlockPoint = Long.MAX_VALUE;
        if (transaction != null) {
            transactionUnlockPoint = transaction.getTransactionUnlockSequence();
        }
        while (!(entry == null || entry.state == 3 && !entry.wasLocked(transactionUnlockPoint) || entry.state == 2 && entry.lockedBy(transaction))) {
            entry = (Entry)TreeMap.successor(entry);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "firstEntry", "returns entry=" + entry + "(Entry)");
        }
        return entry;
    }

    private Entry lastEntry(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "lastEntry", new Object[]{transaction});
        }
        Entry entry = null;
        if (this.root != null) {
            entry = (Entry)TreeMap.maximum(this.getRoot());
        }
        long transactionUnlockPoint = Long.MAX_VALUE;
        if (transaction != null) {
            transactionUnlockPoint = transaction.getTransactionUnlockSequence();
        }
        while (!(entry == null || entry.state == 3 && !entry.wasLocked(transactionUnlockPoint) || entry.state == 2 && entry.lockedBy(transaction))) {
            entry = (Entry)TreeMap.predecessor(entry);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "lastEntry", new Object[]{entry});
        }
        return entry;
    }

    private Entry successor(Entry entry, Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "successor", new Object[]{entry, transaction});
        }
        long transactionUnlockPoint = Long.MAX_VALUE;
        if (transaction != null) {
            transactionUnlockPoint = transaction.getTransactionUnlockSequence();
        }
        while (!(entry == null || (entry = (Entry)TreeMap.successor(entry)) == null || entry.state == 3 && !entry.wasLocked(transactionUnlockPoint) || entry.state == 2 && transaction != null && entry.lockedBy(transaction))) {
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "successor", new Object[]{entry});
        }
        return entry;
    }

    private Entry predecessor(Entry entry, Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "predecessor", new Object[]{entry, transaction});
        }
        long transactionUnlockPoint = Long.MAX_VALUE;
        if (transaction != null) {
            transactionUnlockPoint = transaction.getTransactionUnlockSequence();
        }
        while (!(entry == null || (entry = (Entry)TreeMap.predecessor(entry)) == null || entry.state == 3 && !entry.wasLocked(transactionUnlockPoint) || entry.state == 2 && transaction != null && entry.lockedBy(transaction))) {
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "predecessor", "returns entry=" + entry + "(Entry)");
        }
        return entry;
    }

    private synchronized void deleteEntry(Entry entry, Transaction transaction) throws ObjectManagerException {
        String methodName = "deleteEntry";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "deleteEntry", new Object[]{entry, transaction});
        }
        this.managedObjectsToReplace.clear();
        this.tokensToNotify.clear();
        this.reservedSpaceInStore = (int)this.storeSpaceForRemove();
        this.rbDelete(entry);
        this.managedObjectsToReplace.add(this);
        this.tokensToNotify.add(entry.getToken());
        transaction.optimisticReplace(null, new ArrayList(this.managedObjectsToReplace), null, new ArrayList(this.tokensToNotify), -logSpaceForDelete);
        if (transaction.getObjectManagerStateState() != 2) {
            this.owningToken.objectStore.reserve(-((int)this.reservedSpaceInStore), false);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "deleteEntry");
        }
    }

    void rbDelete(Entry z) throws ObjectManagerException {
        Entry y = z.getLeft() == null || z.getRight() == null ? z : TreeMap.successor(z);
        AbstractTreeMap.Entry x = y.getLeft() != null ? y.getLeft() : y.getRight();
        boolean yWasLeftChild = false;
        boolean yWasRightChild = false;
        if (x != null) {
            x.setParent(y.getParent());
        }
        if (y.getParent() == null) {
            this.setRoot(x);
        } else if (y == y.getParent().getLeft()) {
            y.getParent().setLeft(x);
            yWasLeftChild = true;
        } else {
            y.getParent().setRight(x);
            yWasRightChild = true;
        }
        ++this.modCount;
        boolean yOldColor = y.getColor();
        Entry yOldParent = (Entry)y.getParent();
        if (y != z) {
            this.move(y, z);
        }
        if (!yOldColor && this.root != null) {
            if (x == null) {
                if (yOldParent == z) {
                    z.setParent(y);
                } else {
                    z.setParent(yOldParent);
                }
                z.setColor(false);
                if (yWasLeftChild) {
                    yOldParent.setLeft(z);
                }
                if (yWasRightChild) {
                    yOldParent.setRight(z);
                }
                this.fixup(z);
                if (yWasLeftChild) {
                    yOldParent.setLeft(null);
                }
                if (yWasRightChild) {
                    yOldParent.setRight(null);
                }
            } else {
                this.fixup(x);
            }
        }
        --this.size;
    }

    void move(AbstractTreeMap.Entry x, AbstractTreeMap.Entry y) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "move", new Object[]{x, y});
        }
        Entry yParent = (Entry)y.getParent();
        x.setParent(yParent);
        if (yParent == null) {
            this.setRoot(x);
        } else if (yParent.getRight() == y) {
            yParent.setRight(x);
        } else {
            yParent.setLeft(x);
        }
        x.setLeft(y.getLeft());
        x.setRight(y.getRight());
        if (y.getLeft() != null) {
            y.getLeft().setParent(x);
        }
        if (y.getRight() != null) {
            y.getRight().setParent(x);
        }
        x.setColor(y.getColor());
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "move", new Object[]{x});
        }
    }

    public synchronized Object clone(Transaction transaction, ObjectStore objectStore) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "clone", new Object[]{transaction, objectStore});
        }
        TreeMap clonedMap = new TreeMap(this.comparator, transaction, objectStore);
        Entry entry = this.firstEntry(transaction);
        while (entry != null) {
            clonedMap.put(entry.getKey(), entry.getValue(), transaction);
            entry = this.successor(entry, transaction);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "clone", new Object[]{clonedMap});
        }
        return clonedMap;
    }

    @Override
    public synchronized void print(PrintWriter printWriter) {
        printWriter.println("Dump of TreeMap size=" + this.size + "(long)");
        try {
            Iterator iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                printWriter.println((this.indexLabel(entry) + "                    ").substring(0, 20) + (entry.getColor() ? " RED  " : " BLACK") + " Entry=" + entry);
            }
        }
        catch (ObjectManagerException objectManagerException) {
            printWriter.println("Caught objectManagerException=" + objectManagerException);
            objectManagerException.printStackTrace(printWriter);
        }
    }

    public synchronized boolean validate(PrintStream printStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "validate", new Object[]{printStream});
        }
        boolean valid = true;
        int logSizePlus1 = 0;
        for (long sizePlus1 = this.size + 1L; sizePlus1 != 0L; sizePlus1 >>>= 1) {
            ++logSizePlus1;
        }
        int maximumLeafDepth = 2 * logSizePlus1;
        int firstBlackDepth = 0;
        long numberFound = 0L;
        Iterator iterator = this.entrySet().iterator();
        Entry previous = null;
        if (iterator.hasNext()) {
            ++numberFound;
            previous = (Entry)iterator.next();
        }
        while (iterator.hasNext()) {
            ++numberFound;
            Entry entry = (Entry)iterator.next();
            if (this.compare(entry.getKey(), previous.getKey()) < 0) {
                valid = false;
                printStream.println("key=" + previous.getKey() + " < following key=" + entry.getKey());
            }
            previous = entry;
            if (entry.getColor() && (entry.getLeft() != null && entry.getLeft().getColor() || entry.getRight() != null && entry.getRight().getColor())) {
                printStream.println((this.indexLabel(entry) + "                    ").substring(0, 20) + " Key=" + entry.getKey() + " Value=" + entry.getValue() + " Red node without two BLACK/null chideren left=" + entry.getLeft() + " right=" + entry.getRight());
            }
            if (entry.getLeft() != null && entry.getRight() != null) continue;
            int blackDepth = 0;
            int depth = 0;
            for (Entry parent = entry; parent != this.getRoot(); parent = (Entry)parent.getParent()) {
                ++depth;
                if (parent.getColor()) continue;
                ++blackDepth;
            }
            if (firstBlackDepth == 0) {
                firstBlackDepth = blackDepth;
            }
            if (depth > maximumLeafDepth) {
                valid = false;
                printStream.println((this.indexLabel(entry) + "                    ").substring(0, 20) + " Key=" + entry.getKey() + " Value=" + entry.getValue() + " Leaf depth=" + depth + ">" + maximumLeafDepth);
            }
            if (blackDepth == firstBlackDepth) continue;
            valid = false;
            printStream.println((this.indexLabel(entry) + "                    ").substring(0, 20) + " Key=" + entry.getKey() + " Value=" + entry.getValue() + " blackDepth=" + blackDepth + " != " + firstBlackDepth);
        }
        if (numberFound != this.size()) {
            printStream.println(" Number of Entries found=" + numberFound + " != size()" + this.size());
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "validate", new Object[]{new Boolean(valid)});
        }
        return valid;
    }

    private String indexLabel(Entry child) throws ObjectManagerException {
        String indexLabel = "";
        Entry parent = (Entry)child.getParent();
        while (parent != null) {
            indexLabel = parent.getLeft() == child ? "L," + indexLabel : (parent.getRight() == child ? "R," + indexLabel : "Invalid," + indexLabel);
            child = parent;
            parent = (Entry)child.getParent();
        }
        return indexLabel;
    }

    @Override
    void reserveSpaceInStore(ObjectManagerByteArrayOutputStream byteArrayOutputStream) throws ObjectManagerException {
        if (this.owningToken.getObjectStore().getObjectManagerState().getObjectManagerStateState() == 2) {
            super.reserveSpaceInStore(byteArrayOutputStream);
        } else {
            int currentSerializedSize = byteArrayOutputStream.getCount() + this.owningToken.objectStore.getAddSpaceOverhead();
            if (currentSerializedSize > this.latestSerializedSize) {
                this.latestSerializedSizeDelta = currentSerializedSize - this.latestSerializedSize;
                this.reservedSpaceInStore -= (long)this.latestSerializedSizeDelta;
                this.latestSerializedSize = currentSerializedSize;
            }
        }
    }

    @Override
    public void becomeCloneOf(ManagedObject other) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "becomeCloneOf", new Object[]{other});
        }
        TreeMap otherTree = (TreeMap)other;
        this.root = otherTree.root;
        this.size = otherTree.size;
        if (!this.backingOut) {
            this.availableSize = otherTree.availableSize;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "becomeCloneOf");
        }
    }

    @Override
    public synchronized void preDelete(Transaction transaction) throws ObjectManagerException {
        String methodName = "preDelete";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "preDelete", new Object[]{transaction});
        }
        Entry entry = null;
        if (this.root != null) {
            entry = (Entry)AbstractTreeMap.minimum(this.getRoot());
        }
        while (entry != null) {
            if (entry.willBeDeleted(transaction)) {
                entry = (Entry)TreeMap.successor(entry);
                continue;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "preDelete", "via CollentionNotEmptyExceptionsize=" + this.size + "(long) entry.state=" + entry.state + "(int) " + Entry.stateNames[entry.state] + "\n entry.getTransactionLock=" + entry.getTransactionLock() + "(TransactionLock)");
            }
            throw new CollectionNotEmptyException((Object)this, this.size, transaction);
        }
        super.preDelete(transaction);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "preDelete");
        }
    }

    TreeMap() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "<init>");
        }
        this.managedObjectsToAdd = new HashSet(1);
        this.managedObjectsToReplace = new HashSet();
        this.tokensToNotify = new HashSet(1);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    public static final long maximumSerializedSize() {
        return 1L + ManagedObject.maximumSerializedSize() + 2L + 2L * Entry.maximumSerializedSize() + 8L;
    }

    @Override
    public int getSignature() {
        return 10;
    }

    @Override
    public final void writeObject(DataOutputStream dataOutputStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "writeObject", new Object[]{dataOutputStream});
        }
        try {
            dataOutputStream.writeByte(0);
            super.writeObject(dataOutputStream);
            if (this.comparator == null) {
                dataOutputStream.writeByte(0);
            } else {
                dataOutputStream.writeByte(1);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(dataOutputStream);
                objectOutputStream.writeObject(this.comparator);
                objectOutputStream.close();
            }
            if (this.root == null) {
                dataOutputStream.writeByte(0);
            } else {
                dataOutputStream.writeByte(1);
                this.root.writeObject(dataOutputStream);
            }
            dataOutputStream.writeLong(this.size);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "writeObject", exception, "1:2341:1.44");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "writeObject", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if ((long)dataOutputStream.size() > TreeMap.maximumSerializedSize()) {
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "writeObject", new Object[]{new Long(TreeMap.maximumSerializedSize()), new Integer(dataOutputStream.size())});
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "writeObject", "via SimplifiedSerializationSizeException");
            }
            throw new SimplifiedSerializationSizeException((Object)this, TreeMap.maximumSerializedSize(), dataOutputStream.size());
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "writeObject");
        }
    }

    @Override
    public void readObject(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
        String methodName = "readObject";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readObject", new Object[]{dataInputStream, objectManagerState});
        }
        try {
            byte version = dataInputStream.readByte();
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "readObject", new Object[]{new Byte(version)});
            }
            super.readObject(dataInputStream, objectManagerState);
            if (dataInputStream.readByte() == 1) {
                ManagedObjectInputStream objectInputStream = new ManagedObjectInputStream(dataInputStream, objectManagerState);
                this.comparator = (Comparator)objectInputStream.readObject();
                objectInputStream.close();
            }
            if (dataInputStream.readByte() == 1) {
                this.root = Token.restore(dataInputStream, objectManagerState);
            }
            this.size = dataInputStream.readLong();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "readObject", exception, "1:2412:1.44");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "readObject", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        catch (java.lang.ClassNotFoundException exception) {
            ObjectManager.ffdc.processException(this, cclass, "readObject", exception, "1:2420:1.44");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "readObject", new Object[]{"ClassNotFoundException:2423", exception});
            }
            throw new ClassNotFoundException((Object)this, exception);
        }
        this.availableSize = this.size;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "readObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStreamIn) throws IOException, java.lang.ClassNotFoundException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readObject", "objectInputStreamIn=" + objectInputStreamIn + "(java.io.ObjectInputStream)");
        }
        objectInputStreamIn.defaultReadObject();
        this.availableSize = this.size;
        this.managedObjectsToAdd = new HashSet(1);
        this.managedObjectsToReplace = new HashSet();
        this.tokensToNotify = new HashSet(1);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "readObject");
        }
    }

    static class Entry
    extends AbstractTreeMap.Entry
    implements Map.Entry,
    SimplifiedSerialization {
        private static final Class cclass = Entry.class;
        private static final long serialVersionUID = 8326113960040570428L;
        static final int stateError = 0;
        static final int stateConstructed = 1;
        static final int stateToBeAdded = 2;
        static final int stateAdded = 3;
        static final int stateNotAdded = 4;
        static final int stateToBeDeleted = 5;
        static final int stateMustBeDeleted = 6;
        static final int stateRemoved = 7;
        static final int stateDeleted = 8;
        static final String[] stateNames = new String[]{"Error", "Constructed", "ToBeAdded", "Added", "NotAdded", "ToBeDeleted", "MustBeDeleted", "Removed", "Deleted"};
        static final int[] nextStateForRequestAdd = new int[]{0, 2, 2, 2, 0, 0, 0, 0, 0};
        static final int[] nextStateForRequestDelete = new int[]{0, 0, 6, 5, 0, 5, 6, 0, 0};
        static final int[] nextStateForRemove = new int[]{0, 0, 4, 7, 0, 7, 7, 0, 0};
        static final int[] nextStateForCommit = new int[]{0, 0, 3, 0, 0, 0, 0, 8, 0};
        static final int[] nextStateForBackout = new int[]{0, 0, 0, 0, 8, 3, 0, 8, 0};
        static final int[] nextStateForError = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        transient int state;
        private transient int previousState;
        private Token treeToken;
        private transient TreeMap treeMap;
        transient Token uncommitedValue;
        private static final byte SimpleSerialVersion = 0;

        protected Entry(TreeMap treeMap, Object key, Token value, Entry parent, Transaction transaction) throws ObjectManagerException {
            super(key, value);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "<init>", new Object[]{treeMap, key, value, parent, transaction});
            }
            this.treeToken = treeMap.owningToken;
            this.treeMap = treeMap;
            if (parent != null) {
                this.parent = parent.getToken();
            }
            this.state = 1;
            this.previousState = -1;
            this.treeToken.getObjectStore().allocate(this);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        @Override
        void setLeft(AbstractTreeMap.Entry newLeft) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "setLeft", new Object[]{newLeft, this.left});
            }
            super.setLeft(newLeft);
            this.treeMap.managedObjectsToReplace.add(this);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "setLeft");
            }
        }

        @Override
        void setRight(AbstractTreeMap.Entry newRight) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "setRight", new Object[]{newRight, this.right});
            }
            super.setRight(newRight);
            this.treeMap.managedObjectsToReplace.add(this);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "setRight");
            }
        }

        @Override
        void setParent(AbstractTreeMap.Entry newParent) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "setParent", new Object[]{newParent, this.parent});
            }
            super.setParent(newParent);
            this.treeMap.managedObjectsToReplace.add(this);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "setParent");
            }
        }

        @Override
        void setColor(boolean newColor) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "setColor", new Object[]{new Boolean(newColor), newColor ? "RED" : "BLACK", new Boolean(this.color), this.color ? "RED" : "BLACK"});
            }
            super.setColor(newColor);
            this.treeMap.managedObjectsToReplace.add(this);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "setColor");
            }
        }

        protected void requestDelete(Transaction transaction) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "requestDelete", "transaction=" + transaction + "(Transaction)");
            }
            this.setState(nextStateForRequestDelete);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "requestDelete", "state =" + this.state + "(int) " + stateNames[this.state] + "(String)");
            }
        }

        private final boolean willBeDeleted(Transaction transaction) {
            return (this.state == 5 || this.state == 6) && this.lockedBy(transaction);
        }

        @Override
        void reserveSpaceInStore(ObjectManagerByteArrayOutputStream byteArrayOutputStream) throws ObjectManagerException {
            if (this.owningToken.getObjectStore().getObjectManagerState().getObjectManagerStateState() == 2) {
                super.reserveSpaceInStore(byteArrayOutputStream);
            } else {
                int currentSerializedSize = byteArrayOutputStream.getCount() + this.owningToken.objectStore.getAddSpaceOverhead();
                if (currentSerializedSize > this.latestSerializedSize) {
                    this.latestSerializedSizeDelta = currentSerializedSize - this.latestSerializedSize;
                    this.treeMap.reservedSpaceInStore -= (long)this.latestSerializedSizeDelta;
                    this.latestSerializedSize = currentSerializedSize;
                }
            }
        }

        @Override
        public void becomeCloneOf(ManagedObject other) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "becomeCloneOf", new Object[]{other});
            }
            if (!this.backingOut) {
                Entry otherEntry = (Entry)other;
                this.treeToken = otherEntry.treeToken;
                this.treeMap = otherEntry.treeMap;
                this.key = otherEntry.key;
                this.value = otherEntry.value;
                this.left = otherEntry.left;
                this.right = otherEntry.right;
                this.parent = otherEntry.parent;
                this.color = otherEntry.color;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "becomeCloneOf");
            }
        }

        @Override
        public void postAdd(Transaction transaction, boolean logged) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "postAdd", "transaction=" + transaction + "(Transaction) logged=" + logged + "(boolean)");
            }
            super.postAdd(transaction, logged);
            if (logged) {
                this.setState(nextStateForRequestAdd);
                transaction.requestCallback(this.owningToken);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "postAdd", "treemap.Size=" + this.treeMap.size + "(long) treeMap.availableSize=" + this.treeMap.availableSize + "(long)");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void postDelete(Transaction transaction, boolean logged) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "postDelete", new Object[]{transaction, new Boolean(logged)});
            }
            super.postDelete(transaction, logged);
            if (logged) {
                if (transaction.getObjectManagerStateState() == 2) {
                    TreeMap treeMap = this.treeMap;
                    synchronized (treeMap) {
                        this.setState(nextStateForRequestDelete);
                    }
                }
                transaction.requestCallback(this.owningToken);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "postDelete", "treemap.Size=" + this.treeMap.size + "(long) treeMap.availableSize=" + this.treeMap.availableSize + "(long)");
            }
        }

        @Override
        public void optimisticReplaceLogged(Transaction transaction) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "optimisticReplaceLogged", "transaction=" + transaction + "(Transaction)");
            }
            super.optimisticReplaceLogged(transaction);
            this.setState(nextStateForRemove);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "optimisticReplaceLogged");
            }
        }

        @Override
        public void preCommit(Transaction transaction) throws ObjectManagerException {
            String methodName = "preCommit";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "preCommit", new Object[]{transaction, new Integer(this.state), stateNames[this.state]});
            }
            super.preCommit(transaction);
            switch (this.state) {
                case 2: {
                    if (transaction.getObjectManagerStateState() == 2) break;
                    this.owningToken.objectStore.reserve(-((int)this.treeMap.storeSpaceForRemove()), false);
                    break;
                }
                case 5: 
                case 6: {
                    this.treeMap.deleteEntry(this, transaction);
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    this.setState(nextStateForError);
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "preCommit", new Object[]{new Integer(this.state), stateNames[this.state]});
            }
        }

        @Override
        public void preBackout(Transaction transaction) throws ObjectManagerException {
            String methodName = "preBackout";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "preBackout", new Object[]{transaction, new Integer(this.state), stateNames[this.state]});
            }
            super.preBackout(transaction);
            switch (this.state) {
                case 2: 
                case 6: {
                    this.treeMap.deleteEntry(this, transaction);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    if (transaction.getObjectManagerStateState() == 2) break;
                    this.owningToken.objectStore.reserve(-((int)this.treeMap.storeSpaceForRemove()), false);
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    this.setState(nextStateForError);
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "preBackout", new Object[]{new Integer(this.state), stateNames[this.state]});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit(Transaction transaction, ObjectManagerByteArrayOutputStream serializedBytes, long logSequenceNumber, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "commit", new Object[]{transaction, serializedBytes, new Long(logSequenceNumber), new Boolean(requiresCurrentCheckpoint)});
            }
            super.commit(transaction, serializedBytes, logSequenceNumber, requiresCurrentCheckpoint);
            switch (this.state) {
                case 2: {
                    this.setState(nextStateForCommit);
                    TreeMap treeMap = this.treeMap;
                    synchronized (treeMap) {
                        if (transaction.getObjectManagerStateState() != 2) {
                            ++this.treeMap.availableSize;
                        }
                        break;
                    }
                }
                default: {
                    this.setState(nextStateForCommit);
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "commit", new Object[]{new Long(this.treeMap.size), new Long(this.treeMap.availableSize)});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void backout(Transaction transaction, long logSequenceNumber, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "backout", new Object[]{transaction, new Long(logSequenceNumber), new Boolean(requiresCurrentCheckpoint)});
            }
            super.backout(transaction, logSequenceNumber, requiresCurrentCheckpoint);
            switch (this.state) {
                case 5: {
                    TreeMap treeMap = this.treeMap;
                    synchronized (treeMap) {
                        this.setState(nextStateForBackout);
                        if (transaction.getObjectManagerStateState() != 2) {
                            ++this.treeMap.availableSize;
                        }
                        break;
                    }
                }
                default: {
                    this.setState(nextStateForBackout);
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "backout", new Object[]{new Long(this.treeMap.size), new Long(this.treeMap.availableSize)});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void recoveryCompleted(Transaction transaction) throws ObjectManagerException {
            String methodName = "recoveryCompleted";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "recoveryCompleted", new Object[]{transaction, new Integer(this.state), stateNames[this.state]});
            }
            TreeMap treeMap = this.treeMap;
            synchronized (treeMap) {
                switch (this.state) {
                    case 2: {
                        --this.treeMap.availableSize;
                        this.owningToken.objectStore.reserve((int)this.treeMap.storeSpaceForRemove(), false);
                        break;
                    }
                    case 5: 
                    case 6: {
                        --this.treeMap.availableSize;
                        this.owningToken.objectStore.reserve((int)this.treeMap.storeSpaceForRemove(), false);
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        this.setState(nextStateForError);
                    }
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "recoveryCompleted");
            }
        }

        private void testState(int[] nextState) throws InvalidStateException {
            int newState;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "testState", new Object[]{nextState, new Integer(this.state), stateNames[this.state]});
            }
            if ((newState = nextState[this.state]) == 0) {
                InvalidStateException invalidStateException = new InvalidStateException((Object)this, this.state, stateNames[this.state]);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "testState", new Object[]{invalidStateException, new Integer(newState), stateNames[newState]});
                }
                throw invalidStateException;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "testState");
            }
        }

        private void setState(int[] nextState) throws StateErrorException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "setState", new Object[]{nextState, new Integer(this.state), stateNames[this.state]});
            }
            this.previousState = this.state;
            this.state = nextState[this.state];
            if (this.state == 0) {
                StateErrorException stateErrorException = new StateErrorException((Object)this, this.previousState, stateNames[this.previousState]);
                ObjectManager.ffdc.processException(this, cclass, "setState", stateErrorException, "1:3283:1.44");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "setState", new Object[]{stateErrorException, new Integer(this.state), stateNames[this.state]});
                }
                throw stateErrorException;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "setState", new Object[]{new Integer(this.state), stateNames[this.state]});
            }
        }

        @Override
        public Token setValue(Token newValue, Transaction transaction) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "setValue", new Object[]{newValue, transaction, this.value});
            }
            System.out.println("setValue not working!!!");
            throw new UnsupportedOperationException("setValue not supported");
        }

        @Override
        public int getEntryState() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "getEntryState");
            }
            int[] entryStateMap = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
            int stateToReturn = entryStateMap[this.state];
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "getEntryState", "returns statetoReturn=" + stateToReturn + "(int) " + stateNames[stateToReturn] + "(String)");
            }
            return stateToReturn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(Transaction transaction) throws ObjectManagerException {
            String methodName = "remove";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "remove", new Object[]{transaction});
            }
            boolean spaceReserved = false;
            try {
                InternalTransaction internalTransaction = transaction.internalTransaction;
                synchronized (internalTransaction) {
                    TreeMap treeMap = this.treeMap;
                    synchronized (treeMap) {
                        if (this.state == 2 && this.lockedBy(transaction)) {
                            transaction.delete(this, logSpaceForDelete);
                            this.requestDelete(transaction);
                        } else if (this.state == 3) {
                            this.owningToken.objectStore.reserve((int)this.treeMap.storeSpaceForRemove(), false);
                            spaceReserved = true;
                            transaction.delete(this, logSpaceForDelete);
                            this.requestDelete(transaction);
                            --this.treeMap.availableSize;
                        } else {
                            InvalidStateException invalidStateException = new InvalidStateException((Object)this, this.state, stateNames[this.state]);
                            ObjectManager.ffdc.processException(this, cclass, "remove", invalidStateException, "1:3410:1.44");
                            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                trace.exit((Object)this, cclass, "remove", new Object[]{"Invalid State 3412", invalidStateException});
                            }
                            throw invalidStateException;
                        }
                    }
                }
            }
            catch (LogFileFullException exception) {
                if (spaceReserved) {
                    this.owningToken.objectStore.reserve(-((int)this.treeMap.storeSpaceForRemove()), false);
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "remove", exception);
                }
                throw exception;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "remove");
            }
        }

        Entry() throws ObjectManagerException {
            super(null, null);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "<init>");
            }
            this.previousState = -1;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        public static final long maximumSerializedSize() {
            return 1L + ManagedObject.maximumSerializedSize() + 3L + 99L + 5L * Token.maximumSerializedSize() + 4L;
        }

        @Override
        public int getSignature() {
            return 11;
        }

        @Override
        public final void writeObject(DataOutputStream dataOutputStream) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "writeObject", new Object[]{dataOutputStream});
            }
            try {
                dataOutputStream.writeByte(0);
                super.writeObject(dataOutputStream);
                this.treeToken.writeObject(dataOutputStream);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(dataOutputStream);
                objectOutputStream.writeObject(this.key);
                objectOutputStream.close();
                this.value.writeObject(dataOutputStream);
                if (this.left == null) {
                    dataOutputStream.writeByte(0);
                } else {
                    dataOutputStream.writeByte(1);
                    this.left.writeObject(dataOutputStream);
                }
                if (this.right == null) {
                    dataOutputStream.writeByte(0);
                } else {
                    dataOutputStream.writeByte(1);
                    this.right.writeObject(dataOutputStream);
                }
                if (this.parent == null) {
                    dataOutputStream.writeByte(0);
                } else {
                    dataOutputStream.writeByte(1);
                    this.parent.writeObject(dataOutputStream);
                }
                dataOutputStream.writeInt(this.color ? 0 : 1);
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(this, cclass, "writeObject", exception, "1:3560:1.44");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "writeObject", "via PermanentIOException");
                }
                throw new PermanentIOException((Object)this, exception);
            }
            if ((long)dataOutputStream.size() > Entry.maximumSerializedSize()) {
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "writeObject", new Object[]{new Long(Entry.maximumSerializedSize()), new Integer(dataOutputStream.size())});
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "writeObject", "via SimplifiedSerializationSizeException");
                }
                throw new SimplifiedSerializationSizeException((Object)this, Entry.maximumSerializedSize(), dataOutputStream.size());
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "writeObject");
            }
        }

        @Override
        public void readObject(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "readObject", "dataInputStream=" + dataInputStream + "(java.io.DataInputStream) objectManagerState=" + objectManagerState + "(ObjectManagerState)");
            }
            try {
                byte version = dataInputStream.readByte();
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "readObject", "version=" + version + "(byte)");
                }
                super.readObject(dataInputStream, objectManagerState);
                this.treeToken = Token.restore(dataInputStream, objectManagerState);
                ManagedObjectInputStream managedObjectInputStream = new ManagedObjectInputStream(dataInputStream, objectManagerState);
                this.key = managedObjectInputStream.readObject();
                managedObjectInputStream.close();
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(this, cclass, "readObject", exception, "1:3633:1.44");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "readObject", "via PermanentIOException");
                }
                throw new PermanentIOException((Object)this, exception);
            }
            catch (java.lang.ClassNotFoundException exception) {
                ObjectManager.ffdc.processException(this, cclass, "readObject", exception, "1:3646:1.44");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "readObject", "via ClassNotFoundException");
                }
                throw new ClassNotFoundException((Object)this, exception);
            }
            this.value = Token.restore(dataInputStream, objectManagerState);
            try {
                if (dataInputStream.readByte() == 1) {
                    this.left = Token.restore(dataInputStream, objectManagerState);
                }
                if (dataInputStream.readByte() == 1) {
                    this.right = Token.restore(dataInputStream, objectManagerState);
                }
                if (dataInputStream.readByte() == 1) {
                    this.parent = Token.restore(dataInputStream, objectManagerState);
                }
                this.color = dataInputStream.readInt() == 0;
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(this, cclass, "readObject", exception, "1:3676:1.44");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "readObject", "via PermanentIOException");
                }
                throw new PermanentIOException((Object)this, exception);
            }
            this.treeMap = (TreeMap)this.treeToken.getManagedObject();
            if (this.treeMap == null) {
                this.treeMap = new TreeMap();
            }
            this.state = 3;
            this.previousState = -1;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "readObject");
            }
        }

        private void readObject(ObjectInputStream objectInputStreamIn) throws IOException, java.lang.ClassNotFoundException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "readObject", "objectInputStreamIn=" + objectInputStreamIn + "(java.io.ObjectInputStream)");
            }
            objectInputStreamIn.defaultReadObject();
            try {
                this.treeMap = (TreeMap)this.treeToken.getManagedObject();
                if (this.treeMap == null) {
                    this.treeMap = new TreeMap();
                }
            }
            catch (ObjectManagerException exception) {
                ObjectManager.ffdc.processException(this, cclass, "readObject", exception, "1:3733:1.44");
                throw new java.lang.ClassNotFoundException();
            }
            this.state = 3;
            this.previousState = -1;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "readObject");
            }
        }

        @Override
        public String toString() {
            return new String("TreeMap:(key=" + this.key + " value=" + this.value + "/" + stateNames[this.state] + " " + super.toString() + ")");
        }
    }

    private class TreeMapIterator
    implements Iterator {
        private Entry currentEntry = null;
        private Entry nextEntry = null;
        private Entry firstExcludedEntry = null;
        boolean beyondEndOfTree = false;
        AbstractMapEntry.Type type;

        TreeMapIterator(AbstractMapEntry.Type type) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "<init>", new Object[]{type});
            }
            this.type = type;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        TreeMapIterator(AbstractMapEntry.Type type, AbstractTreeMap.Entry startNode, boolean checkEnd, Object endKey) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "<init>", new Object[]{type, startNode, new Boolean(checkEnd), endKey});
            }
            if (startNode != null) {
                this.currentEntry = (Entry)AbstractTreeMap.predecessor(startNode);
            }
            this.type = type;
            if (endKey != null) {
                this.firstExcludedEntry = (Entry)TreeMap.this.findAfter(endKey);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean hasNext(Transaction transaction) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "hasNext", new Object[]{transaction});
            }
            boolean returnValue = false;
            TreeMap treeMap = TreeMap.this;
            synchronized (treeMap) {
                Entry nextAvailableEntry;
                if (!this.beyondEndOfTree && (nextAvailableEntry = this.nextAvailable(transaction)) != null && nextAvailableEntry != this.firstExcludedEntry) {
                    returnValue = true;
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "hasNext", new Object[]{new Boolean(returnValue)});
            }
            return returnValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean hasNext() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "hasNext");
            }
            boolean returnValue = false;
            TreeMap treeMap = TreeMap.this;
            synchronized (treeMap) {
                Entry nextAvailableEntry;
                if (!this.beyondEndOfTree && (nextAvailableEntry = this.nextAvailable()) != null && nextAvailableEntry != this.firstExcludedEntry) {
                    returnValue = true;
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "hasNext", new Object[]{new Boolean(returnValue)});
            }
            return returnValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Object next(Transaction transaction) throws ObjectManagerException {
            Object returnObject;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "next", new Object[]{transaction});
            }
            TreeMap treeMap = TreeMap.this;
            synchronized (treeMap) {
                if (!this.beyondEndOfTree) {
                    this.currentEntry = this.nextAvailable(transaction);
                    this.nextEntry = null;
                    if (this.currentEntry == null || this.currentEntry == this.firstExcludedEntry) {
                        this.beyondEndOfTree = true;
                    }
                }
                if (this.beyondEndOfTree) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "next", "via java.util.NoSuchElementException");
                    }
                    throw new NoSuchElementException();
                }
                returnObject = this.type.get(this.currentEntry);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "next", new Object[]{returnObject});
            }
            return returnObject;
        }

        private Entry nextAvailable(Transaction transaction) throws ObjectManagerException {
            Entry nextAvailableEntry;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "nextAvailable", new Object[]{this.currentEntry, this.nextEntry, transaction});
            }
            if (this.nextEntry != null) {
                if (this.nextEntry.state == 3 || this.nextEntry.state == 2 && this.nextEntry.lockedBy(transaction)) {
                    nextAvailableEntry = this.nextEntry;
                } else {
                    if (this.nextEntry.state == 7 || this.nextEntry.state == 8) {
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit((Object)this, cclass, "nextAvailable", "via java.util.ConcurrentModificationException");
                        }
                        throw new ConcurrentModificationException();
                    }
                    nextAvailableEntry = TreeMap.this.successor(this.nextEntry, transaction);
                }
            } else if (this.currentEntry == null) {
                nextAvailableEntry = TreeMap.this.firstEntry(transaction);
            } else {
                if (this.currentEntry.state == 7 || this.currentEntry.state == 8) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "nextAvailable", "via java.util.ConcurrentModificationException");
                    }
                    throw new ConcurrentModificationException();
                }
                nextAvailableEntry = TreeMap.this.successor(this.currentEntry, transaction);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "nextAvailable", new Object[]{nextAvailableEntry});
            }
            return nextAvailableEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Object next() throws ObjectManagerException {
            Object returnObject;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "next");
            }
            TreeMap treeMap = TreeMap.this;
            synchronized (treeMap) {
                if (!this.beyondEndOfTree) {
                    this.currentEntry = this.nextAvailable();
                    this.nextEntry = null;
                    if (this.currentEntry == null || this.currentEntry == this.firstExcludedEntry) {
                        this.beyondEndOfTree = true;
                    }
                }
                if (this.beyondEndOfTree) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "next", "via java.util.NoSuchElementException");
                    }
                    throw new NoSuchElementException();
                }
                returnObject = this.type.get(this.currentEntry);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "next", new Object[]{returnObject});
            }
            return returnObject;
        }

        private Entry nextAvailable() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "nextAvailable", new Object[]{this.currentEntry, this.nextEntry});
            }
            Entry nextAvailableEntry = null;
            if (this.nextEntry != null) {
                if (this.nextEntry.state == 7 || this.nextEntry.state == 8) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "nextAvailable", "via java.util.ConcurrentModificationException");
                    }
                    throw new ConcurrentModificationException();
                }
                nextAvailableEntry = this.nextEntry;
            } else if (this.currentEntry == null) {
                if (TreeMap.this.root != null) {
                    nextAvailableEntry = (Entry)AbstractTreeMap.minimum(TreeMap.this.getRoot());
                }
            } else {
                if (this.currentEntry.state == 7 || this.currentEntry.state == 8) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "nextAvailable", "via java.util.ConcurrentModificationException");
                    }
                    throw new ConcurrentModificationException();
                }
                nextAvailableEntry = (Entry)AbstractTreeMap.successor(this.currentEntry);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "nextAvailable", new Object[]{nextAvailableEntry});
            }
            return nextAvailableEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Object remove(Transaction transaction) throws ObjectManagerException {
            String methodName = "remove";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "remove", new Object[]{transaction});
            }
            if (this.currentEntry == null || this.beyondEndOfTree) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "remove", new Object[]{"via IllegalStateException"});
                }
                throw new IllegalStateException();
            }
            InternalTransaction internalTransaction = transaction.internalTransaction;
            synchronized (internalTransaction) {
                TreeMap treeMap = TreeMap.this;
                synchronized (treeMap) {
                    this.currentEntry.remove(transaction);
                    this.nextEntry = (Entry)AbstractTreeMap.successor(this.currentEntry);
                    if (this.nextEntry == null) {
                        this.beyondEndOfTree = true;
                    }
                }
            }
            Object returnObject = this.type.get(this.currentEntry);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "remove", new Object[]{returnObject});
            }
            return returnObject;
        }
    }

    private class SubMap
    extends AbstractTreeMap.SubMap {
        SubMap(Object start, TreeMap treeMap2, Object end) {
            super(start, TreeMap.this, end);
        }

        @Override
        public boolean containsKey(Object key, Transaction transaction) throws ObjectManagerException {
            if (this.checkRange(key, this.hasStart, this.hasEnd)) {
                return this.backingMap.containsKey(key, transaction);
            }
            return false;
        }

        @Override
        public Token get(Object key, Transaction transaction) throws ObjectManagerException {
            if (this.checkRange(key, this.hasStart, this.hasEnd)) {
                return this.backingMap.get(key, transaction);
            }
            return null;
        }

        @Override
        public Token put(Object key, Token value, Transaction transaction) throws ObjectManagerException {
            if (this.checkRange(key, this.hasStart, this.hasEnd)) {
                throw new IllegalArgumentException("key not in SubMap range");
            }
            return this.backingMap.put(key, value, transaction);
        }

        @Override
        public Object firstKey(Transaction transaction) throws ObjectManagerException {
            if (!this.hasStart) {
                return TreeMap.this.firstKey(transaction);
            }
            Entry node = TreeMap.this.findAfter(this.startKey, transaction);
            if (node != null && this.checkRange(node.getKey(), false, this.hasEnd)) {
                return node.getKey();
            }
            throw new NoSuchElementException();
        }

        @Override
        public Object lastKey(Transaction transaction) throws ObjectManagerException {
            if (!this.hasEnd) {
                return TreeMap.this.lastKey(transaction);
            }
            Entry node = TreeMap.this.findBefore(this.endKey, transaction);
            if (node != null && this.checkRange(node.key, this.hasStart, false)) {
                return node.key;
            }
            throw new NoSuchElementException();
        }

        @Override
        public Iterator iterator() throws ObjectManagerException {
            return this.values().iterator();
        }
    }
}

