/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorization.jacc.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.jacc.JaccService;
import com.ibm.ws.security.authorization.jacc.PolicyConfigurationManager;
import com.ibm.ws.security.authorization.jacc.common.PolicyContextUtil;
import com.ibm.ws.security.authorization.jacc.common.PolicyProxy;
import com.ibm.ws.security.authorization.jacc.common.ProviderServiceProxy;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={JaccService.class}, name="com.ibm.ws.security.authorization.jacc", configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JaccServiceImpl
implements JaccService {
    private static final TraceComponent tc = Tr.register(JaccServiceImpl.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.internal.resources.JaccAuthorizationMessages");
    private static final String KEY_JACC_PROVIDER_SERVICE_PROXY = "jaccProviderServiceProxy";
    private static final String KEY_LOCATION_ADMIN = "locationAdmin";
    private final AtomicServiceReference<ProviderServiceProxy> jaccProviderServiceProxy = new AtomicServiceReference("jaccProviderServiceProxy");
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    private final PolicyConfigurationManager pcm;
    private String policyName = null;
    private String factoryName = null;
    private PolicyProxy policyProxy = null;
    private PolicyConfigurationFactory pcf = null;
    static final long serialVersionUID = 1296825760167532000L;

    @Activate
    public JaccServiceImpl(@Reference PolicyConfigurationManager pcm) {
        this.pcm = pcm;
    }

    @Reference(service=ProviderServiceProxy.class, policy=ReferencePolicy.DYNAMIC, name="jaccProviderServiceProxy")
    protected void setJaccProviderServiceProxy(ServiceReference<ProviderServiceProxy> reference) {
        this.jaccProviderServiceProxy.setReference(reference);
    }

    protected void unsetJaccProviderServiceProxy(ServiceReference<ProviderServiceProxy> reference) {
        this.jaccProviderServiceProxy.unsetReference(reference);
    }

    @Reference(service=WsLocationAdmin.class, name="locationAdmin")
    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> reference) {
        this.locationAdminRef.setReference(reference);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> reference) {
        this.locationAdminRef.unsetReference(reference);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.jaccProviderServiceProxy.activate(cc);
        ProviderServiceProxy serviceProxy = (ProviderServiceProxy)this.jaccProviderServiceProxy.getService();
        if (serviceProxy != null) {
            this.policyName = serviceProxy.getPolicyName();
            this.factoryName = serviceProxy.getFactoryName();
        }
        Tr.info((TraceComponent)tc, (String)"JACC_SERVICE_STARTING", (Object[])new Object[]{this.policyName, this.factoryName});
        this.locationAdminRef.activate(cc);
        if (this.loadClasses()) {
            Tr.info((TraceComponent)tc, (String)"JACC_SERVICE_STARTED", (Object[])new Object[]{this.policyName, this.factoryName});
        } else {
            Tr.info((TraceComponent)tc, (String)"JACC_SERVICE_START_FAILURE", (Object[])new Object[]{this.policyName, this.factoryName});
        }
    }

    @Modified
    protected void modify(Map<String, Object> props) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.locationAdminRef.deactivate(cc);
        this.jaccProviderServiceProxy.deactivate(cc);
        Tr.info((TraceComponent)tc, (String)"JACC_SERVICE_STOPPED", (Object[])new Object[]{this.policyName});
    }

    public boolean loadClasses() {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = -5422570454035875426L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public Boolean run() {
                JaccServiceImpl.this.policyProxy = ((ProviderServiceProxy)JaccServiceImpl.this.jaccProviderServiceProxy.getService()).getPolicyProxy(JaccServiceImpl.this.pcm);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("policy object" + JaccServiceImpl.this.policyProxy), (Object[])new Object[0]);
                }
                if (JaccServiceImpl.this.policyProxy == null) {
                    Exception e = new Exception("Policy object is null.");
                    Tr.error((TraceComponent)tc, (String)"JACC_POLICY_INSTANTIATION_FAILURE", (Object[])new Object[]{JaccServiceImpl.this.policyName, e});
                    return Boolean.FALSE;
                }
                try {
                    JaccServiceImpl.this.policyProxy.setPolicy();
                    JaccServiceImpl.this.policyProxy.refresh();
                }
                catch (ClassCastException e) {
                    void cce;
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authorization.jacc.internal.JaccServiceImpl$1", (String)"133", (Object)this, (Object[])new Object[0]);
                    Tr.error((TraceComponent)tc, (String)"JACC_POLICY_INSTANTIATION_FAILURE", (Object[])new Object[]{JaccServiceImpl.this.policyName, cce});
                    return Boolean.FALSE;
                }
                JaccServiceImpl.this.pcf = ((ProviderServiceProxy)JaccServiceImpl.this.jaccProviderServiceProxy.getService()).getPolicyConfigFactory();
                if (JaccServiceImpl.this.pcf != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("factory object : " + JaccServiceImpl.this.pcf), (Object[])new Object[0]);
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)"JACC_FACTORY_INSTANTIATION_FAILURE", (Object[])new Object[]{JaccServiceImpl.this.factoryName});
                    return Boolean.FALSE;
                }
                JaccServiceImpl.this.pcm.initialize(JaccServiceImpl.this.policyProxy, JaccServiceImpl.this.pcf);
                return Boolean.TRUE;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authorization.jacc.internal.JaccServiceImpl$1", 1.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.internal.resources.JaccAuthorizationMessages");
            }
        });
        return result;
    }

    @Override
    public String getContextId(String applicationName, String moduleName) {
        WsLocationAdmin locationAdmin = (WsLocationAdmin)this.locationAdminRef.getService();
        return PolicyContextUtil.getContextId(locationAdmin, applicationName, moduleName);
    }

    @Override
    public PolicyConfigurationFactory getPolicyConfigurationFactory() {
        return this.pcf;
    }

    @Override
    public PolicyConfigurationManager getPolicyConfigurationManager() {
        return this.pcm;
    }

    @Override
    public PolicyProxy getPolicyProxy() {
        return this.policyProxy;
    }

    @Override
    public String getProviderServiceProperty(String propertyName) {
        Object obj;
        ProviderServiceProxy reference = (ProviderServiceProxy)this.jaccProviderServiceProxy.getService();
        String value = null;
        if (reference != null && (obj = reference.getProperty(propertyName)) instanceof String) {
            value = (String)obj;
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void resetPolicyContextHandlerInfo() {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                    static final long serialVersionUID = 8751902586534159171L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Object run() {
                        PolicyContext.setHandlerData(null);
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authorization.jacc.internal.JaccServiceImpl$2", 2.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.internal.resources.JaccAuthorizationMessages");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.authorization.jacc.internal.JaccServiceImpl", (String)"198", (Object)this, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Exception when resetting setHandlerData. Ignoring.. " + e.getException()), (Object[])new Object[0]);
            }
        }
    }
}

