/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webserver.plugin.utility.tasks;

import com.ibm.ws.product.utility.ExecutionContext;
import com.ibm.ws.webserver.plugin.utility.tasks.BasePluginConfigCommandTask;
import com.ibm.ws.webserver.plugin.utility.tasks.GeneratePluginForCollective;
import com.ibm.ws.webserver.plugin.utility.tasks.GeneratePluginForServer;
import com.ibm.ws.webserver.plugin.utility.utils.ParseLoginAddress;
import com.ibm.ws.webserver.plugin.utility.utils.PluginMBeanConnection;
import com.ibm.ws.webserver.plugin.utility.utils.PluginUtilityConsole;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;

public class GeneratePluginTask
extends BasePluginConfigCommandTask {
    static final String ARG_CLUSTER_NAME = "--cluster";
    static final String ARG_SERVER_ADDRESS = "--server";
    static final String ARG_OPT_TARGET_PATH = "--targetPath";
    static final String MISSING_VALUE_MSG = "missingValue";
    static final String PLUGIN_CFG_FILE_NAME = "plugin-cfg.xml";
    static final String PLUGIN_CFG_FILE_DIR = File.separator + "logs" + File.separator + "state" + File.separator;
    protected PluginUtilityConsole commandConsole;
    protected PluginMBeanConnection connection;

    public GeneratePluginTask(String scriptName, PluginUtilityConsole cmdConsole) {
        super(scriptName);
        this.commandConsole = cmdConsole;
        this.connection = new PluginMBeanConnection(this.commandConsole);
    }

    public String getTaskName() {
        return "generate";
    }

    public String getTaskHelp() {
        String[] Descs = new String[]{"GeneratePluginTask.required-option-desc.serverLoginAddress", "GeneratePluginTask.required-option-desc.serverLoginAddressLocal1", "GeneratePluginTask.required-option-desc.serverLoginAddressLocal2", "GeneratePluginTask.required-option-desc.serverLoginAddressRemote1", "GeneratePluginTask.required-option-desc.serverLoginAddressRemote2", "GeneratePluginTask.required-option-desc.serverLoginAddressRemote2.User", "GeneratePluginTask.required-option-desc.serverLoginAddressRemote2.Password", "GeneratePluginTask.required-option-desc.serverLoginAddressRemote2.Host", "GeneratePluginTask.required-option-desc.serverLoginAddressRemote2.Port"};
        String footer = NL + this.getOption("global.options", new Object[0]) + this.buildScriptOptions("GeneratePluginTask.required-option-key.serverLoginAddress", Descs) + this.buildScriptOptions("GeneratePluginTask.required-option-key.cluster", "GeneratePluginTask.required-option-desc.cluster") + this.buildScriptOptions("GeneratePluginTask.optional-option-key.targetPath", "GeneratePluginTask.optional-option-desc.targetPath") + NL;
        return this.getTaskHelp("GeneratePluginTask.desc", "GeneratePluginTask.usage.options", null, null, null, footer, this.scriptName);
    }

    public String getTaskDescription() {
        StringBuilder scriptHelp = new StringBuilder();
        String UseOption = this.getOption("GeneratePluginTask.usage.options", new Object[0]);
        UseOption = "\t" + UseOption.substring(5);
        scriptHelp.append(UseOption);
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption("GeneratePluginTask.desc", new Object[0]));
        scriptHelp.append(NL);
        return scriptHelp.toString();
    }

    public Set<String> getSupportedOptions() {
        return null;
    }

    public void execute(ExecutionContext context) {
        String[] args = context.getArguments();
        String clusterValue = this.getArgumentValue(ARG_CLUSTER_NAME, args, null);
        if (clusterValue != null) {
            this.createCollectiveArgumentsValues();
            this.validateArgumentList(args, true);
            String serverValues = this.getArgumentValue(ARG_SERVER_ADDRESS, args, null);
            if (serverValues == null) {
                throw new IllegalArgumentException(this.getMessage(MISSING_VALUE_MSG, "[--server]"));
            }
            String targetPathValue = this.getArgumentValue(ARG_OPT_TARGET_PATH, args, null);
            GeneratePluginForCollective collectiveTask = new GeneratePluginForCollective(serverValues, clusterValue, targetPathValue, this.commandConsole);
            ParseLoginAddress controllerAddress = null;
            controllerAddress = collectiveTask.parseCollectiveAddressValue();
            this.invokeGeneratePluginCfgMBean(controllerAddress, collectiveTask.getCluster(), targetPathValue, "collective");
        } else {
            this.createServerArgumentsValues();
            String serverValues = this.getArgumentValue(ARG_SERVER_ADDRESS, args, null);
            if (serverValues == null) {
                throw new IllegalArgumentException(this.getMessage(MISSING_VALUE_MSG, "[--server]"));
            }
            this.validateArgumentList(args, true);
            String targetPathValue = this.getArgumentValue(ARG_OPT_TARGET_PATH, args, null);
            GeneratePluginForServer serverTask = new GeneratePluginForServer(serverValues, targetPathValue, this.commandConsole);
            ParseLoginAddress serverAddress = null;
            serverAddress = serverTask.parseServerAddressValue();
            this.invokeGeneratePluginCfgMBean(serverAddress, null, targetPathValue, "server");
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean invokeGeneratePluginCfgMBean(ParseLoginAddress loginAddress, String clusterName, String targetPath, String option) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createServerArgumentsValues() {
        this.knownArgs.add(ARG_SERVER_ADDRESS);
        this.knownArgs.add(ARG_OPT_TARGET_PATH);
    }

    private void createCollectiveArgumentsValues() {
        this.knownArgs.add(ARG_CLUSTER_NAME);
        this.reqArgs.add(ARG_SERVER_ADDRESS);
        this.knownArgs.add(ARG_OPT_TARGET_PATH);
        this.knownArgs.addAll(this.reqArgs);
    }

    private boolean copyFileToTargetPath(ParseLoginAddress loginAddress, String clusterName, String tgtPath) throws Exception {
        boolean result;
        block10: {
            String strTargetDir = System.getProperty("user.dir");
            String targetFileName = tgtPath;
            result = true;
            String fileName = PLUGIN_CFG_FILE_NAME;
            if (clusterName != null) {
                fileName = clusterName + "-" + fileName;
            }
            if (targetFileName == null) {
                targetFileName = strTargetDir + File.separator + fileName;
            } else {
                File targetPathFile = new File(targetFileName);
                if (targetPathFile.exists() && targetPathFile.isDirectory()) {
                    targetFileName = targetFileName + File.separator + fileName;
                }
            }
            if (loginAddress.isLocal()) {
                try {
                    String generatedFileName = System.getenv("WLP_OUTPUT_DIR");
                    generatedFileName = generatedFileName + File.separator + loginAddress.getServerName();
                    generatedFileName = generatedFileName + PLUGIN_CFG_FILE_DIR;
                    generatedFileName = generatedFileName + fileName;
                    File generatedFile = new File(generatedFileName);
                    if (generatedFile.exists() && !generatedFile.isDirectory()) {
                        File targetFile = new File(targetFileName);
                        if (targetFile.exists() && !targetFile.delete()) {
                            throw new Exception("Cannot delete existing target file : " + generatedFileName);
                        }
                        this.copyFile(generatedFile, targetFile);
                        break block10;
                    }
                    this.commandConsole.printlnErrorMessage(this.getMessage("generateWebServerPluginTask.fail.server", new Object[0]));
                }
                catch (Exception exc) {
                    this.commandConsole.printlnErrorMessage(this.getMessage("error", exc.getMessage()));
                    result = false;
                }
            } else {
                result = this.remoteCopy(clusterName, targetFileName);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File sourceFile, File destFile) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            int length;
            is = new FileInputStream(sourceFile);
            os = new FileOutputStream(destFile);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    private boolean remoteCopy(String clusterName, String targetFile) {
        return this.connection.remoteCopy(clusterName, targetFile);
    }
}

