/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.spi;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;

public abstract class ConfigProviderResolver {
    private static volatile ConfigProviderResolver instance = null;

    protected ConfigProviderResolver() {
    }

    public abstract Config getConfig();

    public abstract Config getConfig(ClassLoader var1);

    public abstract ConfigBuilder getBuilder();

    public abstract void registerConfig(Config var1, ClassLoader var2);

    public abstract void releaseConfig(Config var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigProviderResolver instance() {
        if (instance != null) return instance;
        Class<ConfigProviderResolver> clazz = ConfigProviderResolver.class;
        synchronized (ConfigProviderResolver.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            instance = ConfigProviderResolver.loadSpi(ConfigProviderResolver.class.getClassLoader());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static ConfigProviderResolver loadSpi(ClassLoader cl) {
        ServiceLoader<ConfigProviderResolver> sl = ServiceLoader.load(ConfigProviderResolver.class, cl);
        Iterator<ConfigProviderResolver> iterator = sl.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new IllegalStateException("No ConfigProviderResolver implementation found!");
    }

    public static void setInstance(ConfigProviderResolver resolver) {
        instance = resolver;
    }
}

