/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.destination;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.AnycastOutputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.items.AOValue;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AIContainerItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AOContainerItemStream;
import com.ibm.ws.sib.processor.runtime.impl.AnycastInputControl;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class RemotePtoPSupport
extends AbstractRemoteSupport {
    private static final TraceComponent tc = SibTr.register(RemotePtoPSupport.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public RemotePtoPSupport(BaseDestinationHandler myBaseDestinationHandler, MessageProcessor messageProcessor) {
        super(myBaseDestinationHandler, messageProcessor);
    }

    @Override
    public int reconstituteLocalQueuePoint(int startMode) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteLocalQueuePoint", (Object)new Object[]{startMode});
        }
        NonLockingCursor cursor = this._baseDestinationHandler.newNonLockingItemStreamCursor(new ClassEqualsFilter(AOContainerItemStream.class));
        int aoCount = 0;
        AOContainerItemStream aoTempItemStream = null;
        do {
            if ((aoTempItemStream = (AOContainerItemStream)cursor.next()) == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && aoTempItemStream.getDurablePseudoDestID() != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstituteLocalQueuePoint", (Object)"SIResourceException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.destination.RemotePtoPSupport", "1:138:1.8.1.5", null}, null));
            }
            ++aoCount;
            this._aoContainerItemStream = aoTempItemStream;
            if ((startMode & 1) == 1 && (startMode & 2) == 0) {
                this.getAnycastOutputHandler((DestinationDefinition)this._baseDestinationHandler.getDefinition(), true);
                continue;
            }
            this.getAnycastOutputHandler((DestinationDefinition)this._baseDestinationHandler.getDefinition(), false);
        } while (aoTempItemStream != null);
        cursor.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteLocalQueuePoint", (Object)aoCount);
        }
        return aoCount;
    }

    @Override
    public AnycastInputHandler getAnycastInputHandlerByPseudoDestId(SIBUuid12 destID) {
        return null;
    }

    @Override
    public AnycastOutputHandler getAnycastOutputHandlerByPseudoDestId(SIBUuid12 destID) {
        return null;
    }

    @Override
    public Object[] getPostReconstitutePseudoIds() {
        return null;
    }

    @Override
    public void closeConsumers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeConsumers");
        }
        Iterator i = this._anycastInputHandlers.keySet().iterator();
        while (i.hasNext()) {
            AnycastInputHandler next = (AnycastInputHandler)this._anycastInputHandlers.get(i.next());
            RemoteConsumerDispatcher rcd = next.getRCD();
            rcd.closeAllConsumersForDelete(this._baseDestinationHandler);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeConsumers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyReceiveAllowedRCD(DestinationHandler destinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveAllowedRCD", (Object)new Object[]{destinationHandler});
        }
        HashMap hashMap = this._anycastInputHandlers;
        synchronized (hashMap) {
            for (String key : this._anycastInputHandlers.keySet()) {
                AnycastInputHandler aih = (AnycastInputHandler)this._anycastInputHandlers.get(key);
                if (aih == null) continue;
                RemoteConsumerDispatcher rcd = aih.getRCD();
                rcd.notifyReceiveAllowed(destinationHandler);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveAllowedRCD");
        }
    }

    public boolean cleanupLocalisations() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupLocalisations");
        }
        boolean allCleanedUp = true;
        if (this._anycastOutputHandler != null || this._aoContainerItemStream != null) {
            try {
                boolean aohCleanup = false;
                if (this._anycastOutputHandler != null && (aohCleanup = this._anycastOutputHandler.cleanup(true, true))) {
                    this._anycastOutputHandler = null;
                }
                if (aohCleanup) {
                    LocalTransaction siTran = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(true);
                    if (this._aoContainerItemStream != null) {
                        this._aoContainerItemStream.removeAll((Transaction)siTran);
                        this._aoContainerItemStream = null;
                    }
                    siTran.commit();
                }
                if (allCleanedUp) {
                    allCleanedUp = aohCleanup;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.RemotePtoPSupport.cleanupLocalisations", (String)"1:303:1.8.1.5", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"cleanupLocalisations", (Object)"SIResourceException");
                }
                if (allCleanedUp) {
                    allCleanedUp = false;
                }
                throw new SIResourceException((Throwable)e);
            }
        }
        Iterator i = this._anycastInputHandlers.keySet().iterator();
        boolean anycastCleanUp = true;
        while (i.hasNext()) {
            String key = (String)i.next();
            AnycastInputHandler aih = (AnycastInputHandler)this._anycastInputHandlers.get(key);
            if (!aih.destinationDeleted()) {
                anycastCleanUp = false;
                continue;
            }
            if (this.removeAnycastInputHandlerAndRCD(key)) continue;
            anycastCleanUp = false;
        }
        if (allCleanedUp) {
            allCleanedUp = anycastCleanUp;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupLocalisations", (Object)allCleanedUp);
        }
        return allCleanedUp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<AnycastInputControl> getAIControlAdapterIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAIControlAdapterIterator");
        }
        ArrayList<AnycastInputControl> controlAdapters = new ArrayList<AnycastInputControl>();
        HashMap hashMap = this._anycastInputHandlers;
        synchronized (hashMap) {
            Iterator it = this._anycastInputHandlers.values().iterator();
            while (it.hasNext()) {
                controlAdapters.add(new AnycastInputControl((AnycastInputHandler)it.next()));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAIControlAdapterIterator", controlAdapters);
        }
        return controlAdapters.iterator();
    }

    @Override
    public Iterator<ControlAdapter> getAOControlAdapterIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAOControlAdapterIterator");
        }
        Iterator<ControlAdapter> it = this.getAnycastOutputHandler((DestinationDefinition)this._baseDestinationHandler.getDefinition(), false).getAOControlAdapterIterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAOControlAdapterIterator", it);
        }
        return it;
    }

    public void reconstituteIMELinks(ArrayList<AOValue> valueTicks) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteIMELinks", valueTicks);
        }
        for (AOValue val : valueTicks) {
            String key = SIMPUtils.getRemoteGetKey(val.getSourceMEUuid(), null);
            AIContainerItemStream stream = (AIContainerItemStream)((Object)this._aiContainerItemStreams.get(key));
            if (stream == null) continue;
            stream.addAOLink(val);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteIMELinks");
        }
    }
}

