/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine.processor;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.injectionengine.annotation.ResourceImpl;
import com.ibm.ws.injectionengine.factory.EnvEntryObjectFactory;
import com.ibm.ws.injectionengine.processor.ResourceProcessor;
import com.ibm.ws.injectionengine.processor.ResourceXMLType;
import com.ibm.ws.javaee.dd.common.EnvEntry;
import com.ibm.ws.javaee.dd.common.InjectionTarget;
import com.ibm.ws.javaee.dd.common.MessageDestinationRef;
import com.ibm.ws.javaee.dd.common.ResourceEnvRef;
import com.ibm.ws.javaee.dd.common.ResourceRef;
import com.ibm.ws.resource.ResourceRefConfig;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Resource;
import javax.naming.Reference;

public class ResourceInjectionBinding
extends InjectionBinding<Resource> {
    private static final String CLASS_NAME;
    private static final TraceComponent tc;
    private static final Method svResourceLookupMethod;
    String ivEnvValue = null;
    String ivLink = null;
    ResourceXMLType ivXMLType;
    String ivLookup;
    boolean ivLookupInXml;
    String ivBindingName;
    String ivBindingValue;
    ResourceRefConfig ivResRefConfig;
    String ivApplication;
    String ivModule;
    String ivComponent;
    private boolean ivMergeCompleted = false;
    private static final Class<?>[] ENV_ENTRY_TYPES;

    private static String getResourceLookup(Resource resource) {
        if (svResourceLookupMethod == null) {
            return "";
        }
        try {
            return (String)svResourceLookupMethod.invoke((Object)resource, (Object[])null);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public ResourceInjectionBinding(Resource annotation, ComponentNameSpaceConfiguration nameSpaceConfig) throws InjectionException {
        super(annotation, nameSpaceConfig);
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init> ", (Object[])new Object[0]);
        }
        this.setJndiName(annotation.name());
        this.setInjectionClassType(annotation.type());
        this.ivApplication = nameSpaceConfig.getApplicationName();
        this.ivModule = nameSpaceConfig.getModuleName();
        this.ivComponent = nameSpaceConfig.getDisplayName();
        this.ivXMLType = ResourceXMLType.UNKNOWN;
        this.ivLookup = ResourceInjectionBinding.getResourceLookup(annotation);
        if (this.ivLookup.isEmpty()) {
            this.ivLookup = null;
        }
        this.ivLookupInXml = false;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("<init> : " + this));
        }
    }

    public ResourceInjectionBinding(Resource annotation, String injectionClassTypeName, String lookup, ResourceXMLType xmlType, ComponentNameSpaceConfiguration nameSpaceConfig) throws InjectionException {
        super(annotation, nameSpaceConfig);
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init> ", (Object[])new Object[0]);
        }
        this.setJndiName(annotation.name());
        this.setInjectionClassType(annotation.type());
        this.setInjectionClassTypeName(injectionClassTypeName);
        this.ivApplication = nameSpaceConfig.getApplicationName();
        this.ivModule = nameSpaceConfig.getModuleName();
        this.ivComponent = nameSpaceConfig.getDisplayName();
        this.ivXMLType = xmlType;
        this.ivLookup = lookup;
        boolean bl = this.ivLookupInXml = this.ivLookup != null;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("<init> : " + this));
        }
    }

    public ResourceInjectionBinding(ResourceImpl annotation, EnvEntry envEntry, ComponentNameSpaceConfiguration nameSpaceConfig) throws InjectionException {
        super(annotation, nameSpaceConfig);
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("<init> : " + envEntry), (Object[])new Object[0]);
        }
        this.setJndiName(envEntry.getName());
        this.ivApplication = nameSpaceConfig.getApplicationName();
        this.ivModule = nameSpaceConfig.getModuleName();
        this.ivComponent = nameSpaceConfig.getDisplayName();
        this.ivXMLType = ResourceXMLType.ENV_ENTRY;
        this.ivEnvValue = envEntry.getValue();
        this.ivLookup = envEntry.getLookupName();
        if (this.ivLookup != null) {
            this.ivLookup = this.ivLookup.trim();
        }
        this.ivLookupInXml = this.ivLookup != null;
        Object type = this.getEnvEntryType(envEntry);
        if (type != null) {
            this.setEnvEntryType(annotation, type);
        }
        if (this.ivEnvValue != null && this.ivLookup != null) {
            String elementType = "env-entry";
            Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "env-entry-value/lookup-name", elementType, "env-entry-name", this.getJndiName(), this.ivEnvValue, this.ivLookup});
            String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting env-entry-value/lookup-name element values exist for multiple " + elementType + " elements with the same env-entry-name element value : " + this.getJndiName() + ". The conflicting env-entry-value/lookup-name element values are \"" + this.ivEnvValue + "\" and \"" + this.ivLookup + "\".";
            throw new InjectionConfigurationException(exMsg);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("<init> : " + this));
        }
    }

    public ResourceInjectionBinding(Resource annotation, MessageDestinationRef ref, String lookup, ComponentNameSpaceConfiguration nameSpaceConfig) throws InjectionException {
        super(annotation, nameSpaceConfig);
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("<init> : " + ref), (Object[])new Object[0]);
        }
        this.setJndiName(annotation.name());
        this.setInjectionClassType(annotation.type());
        this.setInjectionClassTypeName(ref.getType());
        this.ivLink = ref.getLink();
        this.ivApplication = nameSpaceConfig.getApplicationName();
        this.ivModule = nameSpaceConfig.getModuleName();
        this.ivComponent = nameSpaceConfig.getDisplayName();
        this.ivXMLType = ResourceXMLType.MESSAGE_DESTINATION_REF;
        this.ivLookup = lookup;
        boolean bl = this.ivLookupInXml = this.ivLookup != null;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("<init> : " + this));
        }
    }

    @Override
    public void merge(Resource annotation, Class<?> instanceClass, Member member) throws InjectionException {
        String lookup;
        Resource currentAnnotation;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("merge : " + this.ivMergeCompleted), (Object[])new Object[0]);
        }
        if ((currentAnnotation = (Resource)this.getAnnotation()) instanceof ResourceImpl && !this.ivMergeCompleted && !this.isComplete()) {
            if (((ResourceImpl)currentAnnotation).ivIsSetType) {
                if (!InjectionBinding.isClassesCompatible(annotation.type(), currentAnnotation.type())) {
                    Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_ANNOTATION_VALUES_CWNEN0053E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, this.ivXMLType.type_element(), "type", this.ivXMLType, "@Resource", this.ivXMLType.name_element(), "name", this.getJndiName(), currentAnnotation.type().getName(), annotation.type().getName()});
                    String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data between the XML deployment descriptor and source code annotations. Conflicting " + this.ivXMLType.type_element() + " element values or type attribute values exist for multiple " + (Object)((Object)this.ivXMLType) + " elements or @Resource annotations with the same " + this.ivXMLType.name_element() + " element value or name attribute value : " + this.getJndiName() + ". The conflicting " + this.ivXMLType.type_element() + " element values or type attribute values are " + currentAnnotation.type().getName() + " and " + annotation.type().getName() + ".";
                    throw new InjectionConfigurationException(exMsg);
                }
            } else {
                ((ResourceImpl)currentAnnotation).ivType = annotation.type();
                this.setInjectionClassType(annotation.type());
            }
            if (!((ResourceImpl)currentAnnotation).ivIsSetAuthenticationType) {
                ((ResourceImpl)currentAnnotation).ivAuthenticationType = annotation.authenticationType();
            }
            if (!((ResourceImpl)currentAnnotation).ivIsSetShareable) {
                ((ResourceImpl)currentAnnotation).ivShareable = annotation.shareable();
            }
            if (!((ResourceImpl)currentAnnotation).ivIsSetMappedName) {
                ((ResourceImpl)currentAnnotation).ivMappedName = annotation.mappedName();
            }
            if (!((ResourceImpl)currentAnnotation).ivIsSetDescription) {
                ((ResourceImpl)currentAnnotation).ivDescription = annotation.description();
            }
            this.ivMergeCompleted = true;
        } else if (currentAnnotation instanceof ResourceImpl) {
            if (!((ResourceImpl)currentAnnotation).ivIsSetType && !currentAnnotation.type().equals(annotation.type())) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_ANNOTATION_VALUES_CWNEN0053E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, this.ivXMLType.type_element(), "type", this.ivXMLType, "@Resource", this.ivXMLType.name_element(), "name", this.getJndiName(), currentAnnotation.type().getName(), annotation.type().getName()});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data between the XML deployment descriptor and source code annotations. Conflicting " + this.ivXMLType.type_element() + " element values or type attribute values exist for multiple " + (Object)((Object)this.ivXMLType) + " elements or @Resource annotations with the same " + this.ivXMLType.name_element() + " element value or name attribute value : " + this.getJndiName() + ". The conflicting " + this.ivXMLType.type_element() + " element values or type attribute values are " + currentAnnotation.type().getName() + " and " + annotation.type().getName() + ".";
                throw new InjectionConfigurationException(exMsg);
            }
            if (!((ResourceImpl)currentAnnotation).ivIsSetAuthenticationType && !currentAnnotation.authenticationType().equals((Object)annotation.authenticationType())) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_ANNOTATION_VALUES_CWNEN0053E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "res-auth", "authenticationType", this.ivXMLType, "@Resource", this.ivXMLType.name_element(), "name", this.getJndiName(), currentAnnotation.authenticationType(), annotation.authenticationType()});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data between the XML deployment descriptor and source code annotations. Conflicting res-auth element values or authenticationType attribute values exist for multiple " + (Object)((Object)this.ivXMLType) + " elements or @Resource annotations with the same " + this.ivXMLType.name_element() + " element value or name attribute value : " + this.getJndiName() + ". The conflicting res-auth element values or authenticationType attribute values are " + currentAnnotation.authenticationType() + " and " + annotation.authenticationType() + ".";
                throw new InjectionConfigurationException(exMsg);
            }
            if (!((ResourceImpl)currentAnnotation).ivIsSetShareable && currentAnnotation.shareable() != annotation.shareable()) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_ANNOTATION_VALUES_CWNEN0053E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "res-sharing-scope", "shareable", this.ivXMLType, "@Resource", this.ivXMLType.name_element(), "name", this.getJndiName(), currentAnnotation.shareable(), annotation.shareable()});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data between the XML deployment descriptor and source code annotations. Conflicting res-sharing-scope element values or shareable attribute values exist for multiple " + (Object)((Object)this.ivXMLType) + " elements or @Resource annotations with the same " + this.ivXMLType.name_element() + " element value or name attribute value : " + this.getJndiName() + ". The conflicting res-sharing-scope element values or shareable attribute values are " + currentAnnotation.shareable() + " and " + annotation.shareable() + ".";
                throw new InjectionConfigurationException(exMsg);
            }
            if (!((ResourceImpl)currentAnnotation).ivIsSetMappedName && !currentAnnotation.mappedName().equals(annotation.mappedName())) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_ANNOTATION_VALUES_CWNEN0053E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "mapped-name", "mappedName", this.ivXMLType, "@Resource", this.ivXMLType.name_element(), "name", this.getJndiName(), currentAnnotation.mappedName(), annotation.mappedName()});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data between the XML deployment descriptor and source code annotations. Conflicting mapped-name element values or mappedName attribute values exist for multiple " + (Object)((Object)this.ivXMLType) + " elements or @Resource annotations with the same " + this.ivXMLType.name_element() + " element value or name attribute value : " + this.getJndiName() + ". The conflicting mapped-name element values or mappedName attribute values are " + currentAnnotation.mappedName() + " and " + annotation.mappedName() + ".";
                throw new InjectionConfigurationException(exMsg);
            }
        } else {
            if (!currentAnnotation.type().equals(annotation.type())) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_ANNOTATION_VALUES_CWNEN0054E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "type", "@Resource", "name", this.getJndiName(), currentAnnotation.type().getName(), annotation.type().getName()});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in source code annotations. Conflicting type attribute values exist for multiple @Resource annotations with the same name attribute value : " + this.getJndiName() + ". The conflicting type attribute values are " + currentAnnotation.type().getName() + " and " + annotation.type().getName() + ".";
                throw new InjectionConfigurationException(exMsg);
            }
            if (!currentAnnotation.authenticationType().equals((Object)annotation.authenticationType())) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_ANNOTATION_VALUES_CWNEN0054E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "authenticationType", "@Resource", "name", this.getJndiName(), currentAnnotation.authenticationType(), annotation.authenticationType()});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in source code annotations. Conflicting authenticationType attribute values exist for multiple @Resource annotations with the same name attribute value : " + this.getJndiName() + ". The conflicting authenticationType attribute values are " + currentAnnotation.authenticationType() + " and " + annotation.authenticationType() + ".";
                throw new InjectionConfigurationException(exMsg);
            }
            if (currentAnnotation.shareable() != annotation.shareable()) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_ANNOTATION_VALUES_CWNEN0054E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "shareable", "@Resource", "name", this.getJndiName(), currentAnnotation.shareable(), annotation.shareable()});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in source code annotations. Conflicting shareable attribute values exist for multiple @Resource annotations with the same name attribute value : " + this.getJndiName() + ". The conflicting shareable attribute values are " + currentAnnotation.shareable() + " and " + annotation.shareable() + ".";
                throw new InjectionConfigurationException(exMsg);
            }
            if (!currentAnnotation.mappedName().equals(annotation.mappedName())) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_ANNOTATION_VALUES_CWNEN0054E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "mappedName", "@Resource", "name", this.getJndiName(), currentAnnotation.mappedName(), annotation.mappedName()});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in source code annotations. Conflicting mappedName attribute values exist for multiple @Resource annotations with the same name attribute value : " + this.getJndiName() + ". The conflicting mappedName attribute values are " + currentAnnotation.mappedName() + " and " + annotation.mappedName() + ".";
                throw new InjectionConfigurationException(exMsg);
            }
        }
        if (!this.ivLookupInXml && this.ivEnvValue == null && (lookup = ResourceInjectionBinding.getResourceLookup(annotation)) != null && !lookup.equals("")) {
            if (!this.isComplete() && (this.ivLookup == null || this.ivLookup.equals(""))) {
                this.ivLookup = lookup;
            } else if (!lookup.equals(this.ivLookup)) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_ANNOTATION_VALUES_CWNEN0054E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "lookup", "@Resource", "name", this.getJndiName(), this.ivLookup, lookup});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in source code annotations. Conflicting lookup attribute values exist for multiple @Resource annotations with the same name attribute value : " + this.getJndiName() + ". The conflicting lookup attribute values are " + this.ivLookup + " and " + lookup + ".";
                throw new InjectionConfigurationException(exMsg);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"merge", (Object)this);
        }
    }

    public void merge(EnvEntry envEntry) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("merge : " + envEntry), (Object[])new Object[0]);
        }
        ResourceImpl curAnnotation = (ResourceImpl)this.getAnnotation();
        String jndiName = envEntry.getName();
        String curJndiName = curAnnotation.name();
        String mappedName = envEntry.getMappedName();
        String curMappedName = curAnnotation.mappedName();
        String value = envEntry.getValue();
        String curValue = this.ivEnvValue;
        Object type = this.getEnvEntryType(envEntry);
        String lookup = envEntry.getLookupName();
        if (lookup != null) {
            lookup = lookup.trim();
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("new=" + jndiName + ":" + mappedName + ":" + value + ":" + type + ":" + lookup), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("cur=" + curJndiName + ":" + curMappedName + ":" + curValue + ":" + this.getInjectionClassTypeName() + ":" + this.ivLookup), (Object[])new Object[0]);
        }
        if (curAnnotation.ivIsSetMappedName && mappedName != null) {
            if (!curMappedName.equals(mappedName)) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "mapped-name", "env-entry", "env-entry-name", this.getJndiName(), curMappedName, mappedName});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting mapped-name element values exist for multiple env-entry elements with the same env-entry-name element value : " + this.getJndiName() + ". The conflicting mapped-name element values are " + curMappedName + " and " + mappedName + ".";
                throw new InjectionConfigurationException(exMsg);
            }
        } else if (mappedName != null && !curAnnotation.ivIsSetMappedName) {
            curAnnotation.ivMappedName = mappedName;
            curAnnotation.ivIsSetMappedName = true;
        }
        if (curAnnotation.ivIsSetType && envEntry.getTypeName() != null) {
            if (!this.isEnvEntryTypeCompatible(type)) {
                Class<?> curType = this.getInjectionClassType();
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "env-entry-type", "env-entry", "env-entry-name", this.getJndiName(), curType, type});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting env-entry-type element values exist for multiple env-entry elements with the same env-entry-name element value : " + this.getJndiName() + ". The conflicting env-entry-type element values are " + curType + " and " + type + ".";
                throw new InjectionConfigurationException(exMsg);
            }
        } else if (type != null && !curAnnotation.ivIsSetType) {
            this.setEnvEntryType(curAnnotation, type);
        }
        if (curValue != null && value != null) {
            if (!curValue.equals(value)) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "env-entry-value", "env-entry", "env-entry-name", this.getJndiName(), curValue, value});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting env-entry-value element values exist for multiple env-entry elements with the same env-entry-name element value : " + this.getJndiName() + ". The conflicting env-entry-value element values are " + curValue + " and " + value + ".";
                throw new InjectionConfigurationException(exMsg);
            }
        } else if (value != null) {
            this.ivEnvValue = value;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("env-value = " + this.ivEnvValue), (Object[])new Object[0]);
            }
        }
        if (lookup != null) {
            if (this.ivLookupInXml) {
                if (!lookup.equals(this.ivLookup)) {
                    Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "lookup-name", "env-entry", "env-entry-name", jndiName, this.ivLookup, lookup});
                    String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting lookup-name element values exist for multiple env-entry elements with the same env-entry-name element value : " + jndiName + ". The conflicting lookup-name element values are \"" + this.ivLookup + "\" and \"" + lookup + "\".";
                    throw new InjectionConfigurationException(exMsg);
                }
            } else {
                this.ivLookup = lookup;
                this.ivLookupInXml = true;
                curAnnotation.ivLookup = lookup;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ivLookup = " + this.ivLookup), (Object[])new Object[0]);
                }
            }
        }
        if (this.ivEnvValue != null && this.ivLookup != null) {
            String elementType = "env-entry";
            Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "env-entry-value/lookup-name", elementType, "env-entry-name", this.getJndiName(), this.ivEnvValue, this.ivLookup});
            String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting env-entry-value/lookup-name element values exist for multiple " + elementType + " elements with the same env-entry-name element value : " + this.getJndiName() + ". The conflicting env-entry-value/lookup-name element values are \"" + this.ivEnvValue + "\" and \"" + this.ivLookup + "\".";
            throw new InjectionConfigurationException(exMsg);
        }
        List targets = envEntry.getInjectionTargets();
        String targetName = null;
        String targetClassName = null;
        Class<?> injectionType = this.getInjectionClassType();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("targetType : " + injectionType), (Object[])new Object[0]);
        }
        if (!targets.isEmpty()) {
            for (InjectionTarget target : targets) {
                targetClassName = target.getInjectionTargetClassName();
                targetName = target.getInjectionTargetName();
                this.addInjectionTarget(injectionType, targetName, targetClassName);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("merge : " + this));
        }
    }

    public void merge(MessageDestinationRef msgDestRef) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"merge", (Object[])new Object[]{msgDestRef});
        }
        ResourceImpl curAnnotation = (ResourceImpl)this.getAnnotation();
        String jndiName = msgDestRef.getName();
        String curJndiName = curAnnotation.name();
        String mappedName = msgDestRef.getMappedName();
        String curMappedName = curAnnotation.mappedName();
        String typeName = msgDestRef.getType();
        String link = msgDestRef.getLink();
        String curLink = this.ivLink;
        String lookup = msgDestRef.getLookupName();
        if (lookup != null) {
            lookup = lookup.trim();
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("new=" + jndiName + ":" + mappedName + ":" + typeName + ":" + link + ":" + lookup), (Object[])new Object[0]);
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cur=" + curJndiName + ":" + curMappedName + ":" + this.getInjectionClassTypeName() + ":" + curLink + ":" + this.ivLookup), (Object[])new Object[0]);
        }
        if (curAnnotation.ivIsSetMappedName && mappedName != null) {
            if (!curMappedName.equals(mappedName)) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "mapped-name", "message-destination-ref", "message-destination-ref-name", this.getJndiName(), curMappedName, mappedName});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting mapped-name element values exist for multiple message-destination-ref elements with the same message-destination-ref-name element value : " + this.getJndiName() + ". The conflicting mapped-name element values are " + curMappedName + " and " + mappedName + ".";
                throw new InjectionConfigurationException(exMsg);
            }
        } else if (mappedName != null && !curAnnotation.ivIsSetMappedName) {
            curAnnotation.ivMappedName = mappedName;
            curAnnotation.ivIsSetMappedName = true;
        }
        this.setXMLType(typeName, "message-destination-ref", "message-destination-ref-name", "message-destination-type");
        if (curLink != null && link != null) {
            if (!curLink.equals(link)) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "message-destination-link", "message-destination-ref", "message-destination-ref-name", this.getJndiName(), curLink, link});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting message-destination-link element values exist for multiple message-destination-ref elements with the same message-destination-ref-name element value : " + this.getJndiName() + ". The conflicting message-destination-link element values are " + curLink + " and " + link + ".";
                throw new InjectionConfigurationException(exMsg);
            }
        } else if (link != null && curLink == null) {
            this.ivLink = link;
        }
        if (lookup != null) {
            if (this.ivLookupInXml) {
                if (!lookup.equals(this.ivLookup)) {
                    Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "lookup-name", "message-destination-ref", "message-destination-ref-name", jndiName, this.ivLookup, lookup});
                    String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting lookup-name element values exist for multiple message-destination-ref elements with the same message-destination-ref-name element value : " + jndiName + ". The conflicting lookup-name element values are \"" + this.ivLookup + "\" and \"" + lookup + "\".";
                    throw new InjectionConfigurationException(exMsg);
                }
            } else {
                this.ivLookup = lookup;
                this.ivLookupInXml = true;
                curAnnotation.ivLookup = lookup;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ivLookup = " + this.ivLookup), (Object[])new Object[0]);
                }
            }
        }
        List targets = msgDestRef.getInjectionTargets();
        String targetName = null;
        String targetClassName = null;
        Class<?> injectionType = this.getInjectionClassType();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("targetType : " + injectionType), (Object[])new Object[0]);
        }
        if (!targets.isEmpty()) {
            for (InjectionTarget target : targets) {
                targetClassName = target.getInjectionTargetClassName();
                targetName = target.getInjectionTargetName();
                this.addInjectionTarget(injectionType, targetName, targetClassName);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"merge", (Object)this);
        }
    }

    public void merge(ResourceEnvRef resourceEnvRef) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"merge", (Object[])new Object[]{resourceEnvRef});
        }
        ResourceImpl curAnnotation = (ResourceImpl)this.getAnnotation();
        String jndiName = resourceEnvRef.getName();
        String curJndiName = curAnnotation.name();
        String mappedName = resourceEnvRef.getMappedName();
        String curMappedName = curAnnotation.mappedName();
        String typeName = resourceEnvRef.getTypeName();
        String lookup = resourceEnvRef.getLookupName();
        if (lookup != null) {
            lookup = lookup.trim();
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("new=" + jndiName + ":" + mappedName + ":" + typeName + ":" + lookup), (Object[])new Object[0]);
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cur=" + curJndiName + ":" + curMappedName + ":" + this.getInjectionClassTypeName() + ":" + this.ivLookup), (Object[])new Object[0]);
        }
        if (curAnnotation.ivIsSetMappedName && mappedName != null) {
            if (!curMappedName.equals(mappedName)) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "mapped-name", "resource-env-ref", "resource-env-ref-name", this.getJndiName(), curMappedName, mappedName});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting mapped-name element values exist for multiple resource-env-ref elements with the same resource-env-ref-name element value : " + this.getJndiName() + ". The conflicting mapped-name element values are " + curMappedName + " and " + mappedName + ".";
                throw new InjectionConfigurationException(exMsg);
            }
        } else if (mappedName != null && !curAnnotation.ivIsSetMappedName) {
            curAnnotation.ivMappedName = mappedName;
            curAnnotation.ivIsSetMappedName = true;
        }
        this.setXMLType(typeName, "resource-env-ref", "resource-env-ref-name", "resource-env-ref-type");
        if (lookup != null) {
            if (this.ivLookupInXml) {
                if (!lookup.equals(this.ivLookup)) {
                    Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "lookup-name", "resource-env-ref", "resource-env-ref-name", jndiName, this.ivLookup, lookup});
                    String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting lookup-name element values exist for multiple resource-env-ref elements with the same resource-env-ref-name element value : " + jndiName + ". The conflicting lookup-name element values are \"" + this.ivLookup + "\" and \"" + lookup + "\".";
                    throw new InjectionConfigurationException(exMsg);
                }
            } else {
                this.ivLookup = lookup;
                this.ivLookupInXml = true;
                curAnnotation.ivLookup = lookup;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ivLookup = " + this.ivLookup), (Object[])new Object[0]);
                }
            }
        }
        List targets = resourceEnvRef.getInjectionTargets();
        String targetName = null;
        String targetClassName = null;
        Class<?> injectionType = this.getInjectionClassType();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("targetType : " + injectionType), (Object[])new Object[0]);
        }
        if (!targets.isEmpty()) {
            for (InjectionTarget target : targets) {
                targetClassName = target.getInjectionTargetClassName();
                targetName = target.getInjectionTargetName();
                this.addInjectionTarget(injectionType, targetName, targetClassName);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"merge", (Object)this);
        }
    }

    public void merge(ResourceRef resourceRef) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"merge", (Object[])new Object[]{resourceRef});
        }
        ResourceImpl curAnnotation = (ResourceImpl)this.getAnnotation();
        String jndiName = resourceRef.getName();
        String curJndiName = curAnnotation.name();
        String mappedName = resourceRef.getMappedName();
        String curMappedName = curAnnotation.mappedName();
        String typeName = resourceRef.getType();
        boolean curShareable = curAnnotation.shareable();
        int resAuthType = resourceRef.getAuthValue();
        int resSharingScope = resourceRef.getSharingScopeValue();
        boolean shareable = resSharingScope == 0;
        Resource.AuthenticationType authenticationType = ResourceProcessor.convertAuthToEnum(resAuthType);
        Resource.AuthenticationType curAuthenticationType = curAnnotation.authenticationType();
        String lookup = resourceRef.getLookupName();
        if (lookup != null) {
            lookup = lookup.trim();
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("new=" + jndiName + ":" + mappedName + ":" + authenticationType + ":" + shareable + ":" + typeName + ":" + lookup), (Object[])new Object[0]);
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cur=" + curJndiName + ":" + curMappedName + ":" + curAuthenticationType + ":" + curShareable + ":" + this.getInjectionClassTypeName() + ":" + this.ivLookup), (Object[])new Object[0]);
        }
        if (curAnnotation.ivIsSetMappedName && mappedName != null) {
            if (!curMappedName.equals(mappedName)) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "mapped-name", "resource-ref", "res-ref-name", this.getJndiName(), curMappedName, mappedName});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting mapped-name element values exist for multiple resource-ref elements with the same res-ref-name element value : " + this.getJndiName() + ". The conflicting mapped-name element values are " + curMappedName + " and " + mappedName + ".";
                throw new InjectionConfigurationException(exMsg);
            }
        } else if (mappedName != null && !curAnnotation.ivIsSetMappedName) {
            curAnnotation.ivMappedName = mappedName;
            curAnnotation.ivIsSetMappedName = true;
        }
        this.setXMLType(typeName, "resource-ref", "res-ref-name", "res-type");
        if (curAnnotation.ivIsSetAuthenticationType && resAuthType != -1) {
            if (curAnnotation.authenticationType() != authenticationType) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "res-auth", "resource-ref", "res-ref-name", this.getJndiName(), curAnnotation.authenticationType(), authenticationType});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting res-auth element values exist for multiple resource-ref elements with the same res-ref-name element value : " + this.getJndiName() + ". The conflicting res-auth element values are " + curAnnotation.authenticationType() + " and " + authenticationType + ".";
                throw new InjectionConfigurationException(exMsg);
            }
        } else if (resAuthType != -1 && !curAnnotation.ivIsSetAuthenticationType) {
            curAnnotation.ivAuthenticationType = authenticationType;
            curAnnotation.ivIsSetAuthenticationType = true;
        }
        if (curAnnotation.ivIsSetShareable && resSharingScope != -1) {
            if (curAnnotation.shareable() != shareable) {
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "res-sharing-scope", "resource-ref", "res-ref-name", this.getJndiName(), curAnnotation.shareable(), shareable});
                String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting res-sharing-scope element values exist for multiple resource-ref elements with the same res-ref-name element value : " + this.getJndiName() + ". The conflicting res-sharing-scope element values are " + curAnnotation.shareable() + " and " + shareable + ".";
                throw new InjectionConfigurationException(exMsg);
            }
        } else if (resSharingScope != -1 && !curAnnotation.ivIsSetShareable) {
            curAnnotation.ivShareable = shareable;
            curAnnotation.ivIsSetShareable = true;
        }
        if (lookup != null) {
            if (this.ivLookupInXml) {
                if (!lookup.equals(this.ivLookup)) {
                    Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, "lookup-name", "resource-ref", "res-ref-name", jndiName, this.ivLookup, lookup});
                    String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting lookup-name element values exist for multiple resource-ref elements with the same res-ref-name element value : " + jndiName + ". The conflicting lookup-name element values are \"" + this.ivLookup + "\" and \"" + lookup + "\".";
                    throw new InjectionConfigurationException(exMsg);
                }
            } else {
                this.ivLookup = lookup;
                this.ivLookupInXml = true;
                curAnnotation.ivLookup = lookup;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ivLookup = " + this.ivLookup), (Object[])new Object[0]);
                }
            }
        }
        List targets = resourceRef.getInjectionTargets();
        String targetName = null;
        String targetClassName = null;
        Class<?> injectionType = this.loadClass(resourceRef.getType());
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("targetType : " + injectionType), (Object[])new Object[0]);
        }
        if (!targets.isEmpty()) {
            for (InjectionTarget target : targets) {
                targetClassName = target.getInjectionTargetClassName();
                targetName = target.getInjectionTargetName();
                this.addInjectionTarget(injectionType, targetName, targetClassName);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"merge", (Object)this);
        }
    }

    @Override
    public void mergeSaved(InjectionBinding<Resource> injectionBinding) throws InjectionException {
        ResourceInjectionBinding resourceBinding = (ResourceInjectionBinding)injectionBinding;
        Resource resourceBindingAnn = (Resource)resourceBinding.getAnnotation();
        Resource ann = (Resource)this.getAnnotation();
        this.mergeSavedValue(this.getInjectionClassTypeName(), resourceBinding.getInjectionClassTypeName(), "type");
        this.mergeSavedValue(this.ivLink, resourceBinding.ivLink, "message-destination-link");
        this.mergeSavedValue(this.ivLookup, resourceBinding.ivLookup, "lookup");
        this.mergeSavedValue(ann.authenticationType(), resourceBindingAnn.authenticationType(), "authentication-type");
        this.mergeSavedValue(ann.shareable(), resourceBindingAnn.shareable(), "shareable");
        this.mergeSavedValue(this.ivBindingName, resourceBinding.ivBindingName, "binding-name");
        this.mergeSavedValue(this.ivBindingValue, resourceBinding.ivBindingValue, "value");
        List conflicts = this.ivResRefConfig.compareBindingsAndExtensions(resourceBinding.ivResRefConfig);
        ResourceRefConfig.MergeConflict primaryConflict = null;
        for (ResourceRefConfig.MergeConflict conflict : conflicts) {
            if (conflict.getAttributeName().equals("binding-name")) continue;
            primaryConflict = conflict;
            Tr.error((TraceComponent)tc, (String)"CONFLICTING_REFERENCES_CWNEN0062E", (Object[])new Object[]{this.ivComponent, resourceBinding.ivComponent, this.ivModule, this.ivApplication, conflict.getAttributeName(), this.getJndiName(), conflict.getValue1(), conflict.getValue2()});
        }
        if (primaryConflict != null) {
            throw new InjectionConfigurationException("The " + this.getJndiName() + " reference has conflicting values for the " + primaryConflict.getAttributeName() + " attribute: " + primaryConflict.getValue1() + " and " + primaryConflict.getValue2());
        }
    }

    @Override
    public void setInjectionClassType(Class<?> type) throws InjectionException {
        if (type != null && type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                type = Boolean.class;
            } else if (type == Byte.TYPE) {
                type = Byte.class;
            } else if (type == Character.TYPE) {
                type = Character.class;
            } else if (type == Short.TYPE) {
                type = Short.class;
            } else if (type == Integer.TYPE) {
                type = Integer.class;
            } else if (type == Long.TYPE) {
                type = Long.class;
            } else if (type == Float.TYPE) {
                type = Float.class;
            } else if (type == Double.TYPE) {
                type = Double.class;
            }
        }
        super.setInjectionClassType(type);
    }

    private void setXMLType(String typeName, String element, String nameElement, String typeElement) throws InjectionConfigurationException {
        if (this.ivNameSpaceConfig.getClassLoader() == null) {
            this.setInjectionClassTypeName(typeName);
        } else {
            Class<?> type = this.loadClass(typeName);
            if (type != null) {
                ResourceImpl curAnnotation = (ResourceImpl)this.getAnnotation();
                if (curAnnotation.ivIsSetType) {
                    Class<?> curType = this.getInjectionClassType();
                    Class<?> mostSpecificClass = ResourceInjectionBinding.mostSpecificClass(type, curType);
                    if (mostSpecificClass == null) {
                        Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivComponent, this.ivModule, this.ivApplication, typeElement, element, nameElement, this.getJndiName(), curType, type});
                        String exMsg = "The " + this.ivComponent + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting " + typeElement + " element values exist for multiple " + element + " elements with the same " + nameElement + " element value : " + this.getJndiName() + ". The conflicting " + typeElement + " element values are " + curType + " and " + type + ".";
                        throw new InjectionConfigurationException(exMsg);
                    }
                    curAnnotation.ivType = mostSpecificClass;
                } else {
                    curAnnotation.ivType = type;
                    curAnnotation.ivIsSetType = true;
                }
            }
        }
    }

    private boolean isEnvEntryTypeCompatible(Object newType) {
        Class<?> curType = this.getInjectionClassType();
        if (curType == null) {
            return true;
        }
        return ResourceInjectionBinding.isClassesCompatible((Class)newType, this.getInjectionClassType());
    }

    public void setEnvEntryType(ResourceImpl annotation, Object type) throws InjectionException {
        if (type instanceof String) {
            this.setInjectionClassTypeName((String)type);
        } else {
            Class classType;
            annotation.ivType = classType = (Class)type;
            annotation.ivIsSetType = true;
            this.setInjectionClassType(classType);
        }
    }

    Object getEnvEntryType(EnvEntry envEntry) throws InjectionConfigurationException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        Class<?> type = null;
        String typeName = envEntry.getTypeName();
        if (typeName != null) {
            for (Class<?> typeClass : ENV_ENTRY_TYPES) {
                if (!typeName.equals(typeClass.getName())) continue;
                type = typeClass;
                break;
            }
            if (type == null) {
                if (this.ivNameSpaceConfig.getClassLoader() == null) {
                    type = typeName;
                } else {
                    Class<?> classType = this.loadClass(typeName);
                    if (classType == null || !classType.isEnum()) {
                        Tr.error((TraceComponent)tc, (String)"INVALID_ENV_ENTRY_TYPE_CWNEN0064E", (Object[])new Object[]{envEntry.getName(), this.ivModule, this.ivApplication, typeName});
                        throw new InjectionConfigurationException("A type, which is not valid, has been specified for the " + envEntry.getName() + " simple environment entry in the " + this.ivModule + " module of the " + this.ivApplication + " application: '" + typeName + "'.");
                    }
                    type = classType;
                }
            }
        } else if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"EnvEntry XML type is not set.", (Object[])new Object[0]);
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("env-entry-type = " + (type == null ? "null" : type.getClass().getName())), (Object[])new Object[0]);
        }
        return type;
    }

    private boolean isEnvEntryType(Class<?> resolverType) {
        Class<?> injectType = this.getInjectionClassType();
        return injectType == null ? resolverType.getName().equals(this.getInjectionClassTypeName()) : resolverType == injectType;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final Object resolveEnvEntryValue(String value) throws InjectionConfigurationException {
        void var2_16;
        if (value == null) {
            return null;
        }
        Object var2_2 = null;
        if (this.isEnvEntryType(String.class)) {
            String string = value;
            return var2_16;
        } else if (this.isEnvEntryType(Integer.class)) {
            try {
                Integer n = Integer.valueOf(value);
                return var2_16;
            }
            catch (NumberFormatException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".resolveEnvEntryValue"), (String)"337", (Object)this, (Object[])new Object[]{value});
                Tr.warning((TraceComponent)tc, (String)"NUMBER_FORMAT_EXCEPTION_CWNEN0013W", (Object[])new Object[]{this.getJndiName(), value, e});
                if (!this.isValidationFailable()) return var2_16;
                throw new InjectionConfigurationException("The " + value + " value for the " + this.getJndiName() + " simple environment entry in the " + this.ivModule + " module of the " + this.ivApplication + " application cannot be converted to an integer.", e);
            }
        } else {
            if (this.isEnvEntryType(Boolean.class)) {
                Boolean bl = Boolean.valueOf(value);
                if (bl.booleanValue() || value.equalsIgnoreCase("false")) return var2_16;
                Tr.warning((TraceComponent)tc, (String)"INVALID_BOOLEAN_FORMAT_CWNEN0014W", (Object[])new Object[]{this.getJndiName(), value});
                if (!this.isValidationFailable()) return var2_16;
                throw new InjectionConfigurationException("The " + value + " value for the " + this.getJndiName() + " simple environment entry in the " + this.ivModule + " module of the " + this.ivApplication + " application is not a proper boolean value.");
            }
            if (this.isEnvEntryType(Double.class)) {
                try {
                    Double d = Double.valueOf(value);
                    return var2_16;
                }
                catch (NumberFormatException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".resolveEnvEntryValue"), (String)"369", (Object)this, (Object[])new Object[]{value});
                    Tr.warning((TraceComponent)tc, (String)"NUMBER_FORMAT_EXCEPTION_CWNEN0013W", (Object[])new Object[]{this.getJndiName(), value, e});
                    if (!this.isValidationFailable()) return var2_16;
                    throw new InjectionConfigurationException("The " + value + " value for the " + this.getJndiName() + " simple environment entry in the " + this.ivModule + " module of the " + this.ivApplication + " application cannot be converted to a double.", e);
                }
            } else if (this.isEnvEntryType(Byte.class)) {
                try {
                    Byte by = Byte.valueOf(value);
                    return var2_16;
                }
                catch (NumberFormatException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".resolveEnvEntryValue"), (String)"386", (Object)this, (Object[])new Object[]{value});
                    Tr.warning((TraceComponent)tc, (String)"NUMBER_FORMAT_EXCEPTION_CWNEN0013W", (Object[])new Object[]{this.getJndiName(), value, e});
                    if (!this.isValidationFailable()) return var2_16;
                    throw new InjectionConfigurationException("The " + value + " value for the " + this.getJndiName() + " simple environment entry in the " + this.ivModule + " module of the " + this.ivApplication + " application cannot be converted to a byte.", e);
                }
            } else if (this.isEnvEntryType(Short.class)) {
                try {
                    Short s = Short.valueOf(value);
                    return var2_16;
                }
                catch (NumberFormatException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".resolveEnvEntryValue"), (String)"403", (Object)this, (Object[])new Object[]{value});
                    Tr.warning((TraceComponent)tc, (String)"NUMBER_FORMAT_EXCEPTION_CWNEN0013W", (Object[])new Object[]{this.getJndiName(), value, e});
                    if (!this.isValidationFailable()) return var2_16;
                    throw new InjectionConfigurationException("The " + value + " value for the " + this.getJndiName() + " simple environment entry in the " + this.ivModule + " module of the " + this.ivApplication + " application cannot be converted to a short.", e);
                }
            } else if (this.isEnvEntryType(Long.class)) {
                try {
                    Long l = Long.valueOf(value);
                    return var2_16;
                }
                catch (NumberFormatException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".resolveEnvEntryValue"), (String)"366", (Object)this, (Object[])new Object[]{value});
                    Tr.warning((TraceComponent)tc, (String)"NUMBER_FORMAT_EXCEPTION_CWNEN0013W", (Object[])new Object[]{this.getJndiName(), value, e});
                    if (!this.isValidationFailable()) return var2_16;
                    throw new InjectionConfigurationException("The " + value + " value for the " + this.getJndiName() + " simple environment entry in the " + this.ivModule + " module of the " + this.ivApplication + " application cannot be converted to a long.", e);
                }
            } else if (this.isEnvEntryType(Float.class)) {
                try {
                    Float f = Float.valueOf(value);
                    return var2_16;
                }
                catch (NumberFormatException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".resolveEnvEntryValue"), (String)"437", (Object)this, (Object[])new Object[]{value});
                    Tr.warning((TraceComponent)tc, (String)"NUMBER_FORMAT_EXCEPTION_CWNEN0013W", (Object[])new Object[]{this.getJndiName(), value, e});
                    if (!this.isValidationFailable()) return var2_16;
                    throw new InjectionConfigurationException("The " + value + " value for the " + this.getJndiName() + " simple environment entry in the " + this.ivModule + " module of the " + this.ivApplication + " application cannot be converted to a float.", e);
                }
            } else if (this.isEnvEntryType(Character.class)) {
                try {
                    Character c = Character.valueOf(value.charAt(0));
                    return var2_16;
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".resolveEnvEntryValue"), (String)"454", (Object)this, (Object[])new Object[]{value});
                    Tr.warning((TraceComponent)tc, (String)"THROWABLE_WHILE_CONSTRUCTING_JAVA_COMP_ENV_CWNEN0015W", (Object[])new Object[]{this.getJndiName(), value, e});
                    if (!this.isValidationFailable()) return var2_16;
                    throw new InjectionConfigurationException("The " + value + " value for the " + this.getJndiName() + " simple environment entry in the " + this.ivModule + " module of the " + this.ivApplication + " application cannot be converted to a character.", e);
                }
            } else if (this.isEnvEntryType(Class.class)) {
                if (this.ivNameSpaceConfig.getClassLoader() == null) {
                    Reference reference = EnvEntryObjectFactory.createClassReference(this.getJndiName(), this.ivNameSpaceConfig, value);
                    return var2_16;
                } else {
                    Class<?> clazz = this.loadClass(value);
                }
                return var2_16;
            } else if (this.ivNameSpaceConfig.getClassLoader() == null) {
                String className = this.getInjectionClassTypeName();
                if (className == null) {
                    if (this.isValidationLoggable()) {
                        this.invalidEnvEntryType(null);
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"missing env-entry-type: ", (Object[])new Object[]{this.toString()});
                    }
                }
                Reference reference = EnvEntryObjectFactory.createEnumReference(this.getJndiName(), this.ivNameSpaceConfig, this.getInjectionClassTypeName(), value);
                return var2_16;
            } else {
                Class<?> type = this.getInjectionClassType();
                if (type != null && type.isEnum()) {
                    try {
                        Object enumValue;
                        Object obj = enumValue = Enum.valueOf(type, value);
                        return var2_16;
                    }
                    catch (IllegalArgumentException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".resolveEnvEntryValue"), (String)"1946", (Object)this, (Object[])new Object[]{value});
                        Tr.error((TraceComponent)tc, (String)"INVALID_ENUM_IDENTIFIER_CWNEN0063E", (Object[])new Object[]{this.getJndiName(), this.ivModule, this.ivApplication, type.getName(), value});
                        throw new InjectionConfigurationException("CWNEN0063E: The " + this.getJndiName() + " simple environment entry in the " + this.ivModule + " module of the " + this.ivApplication + " application, which is the " + type.getName() + " Enum type, is not set to a valid Enum identifier: '" + value + "'.");
                    }
                } else {
                    this.invalidEnvEntryType(type == null ? null : type.toString());
                }
            }
        }
        return var2_16;
    }

    private void invalidEnvEntryType(String typeName) throws InjectionConfigurationException {
        Tr.warning((TraceComponent)tc, (String)"INVALID_TYPE_IN_JAVA_COMP_ENV_CWNEN0016W", (Object[])new Object[]{typeName, this.getJndiName(), this.ivComponent, this.ivModule});
        if (this.isValidationFailable()) {
            throw new InjectionConfigurationException("The " + typeName + " type, which is not valid, has been specified for the " + this.getJndiName() + " simple environment entry in the " + this.ivComponent + " component in the " + this.ivModule + " module of the " + this.ivApplication + " application.");
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(Util.identity((Object)this));
        sb.append("[name=").append(this.getJndiName());
        Class<?> type = this.getInjectionClassType();
        if (type != null && type != Object.class) {
            sb.append(", type=").append(type.getName());
        } else {
            String typeName = this.getInjectionClassTypeName();
            if (typeName != null) {
                sb.append(", typeName=").append(typeName);
            }
        }
        Resource ann = (Resource)this.getAnnotation();
        if (ann != null) {
            sb.append(", auth-type=").append(ann.authenticationType());
            sb.append(", shareable=").append(ann.shareable());
        }
        if (this.ivLink != null) {
            sb.append(", msg-link=").append(this.ivLink);
        }
        if (this.ivEnvValue != null) {
            sb.append(", env-entry-value=").append(this.ivEnvValue);
        }
        if (this.ivLookup != null) {
            sb.append(", lookup=").append(this.ivLookup);
        }
        return sb.append(']').toString();
    }

    static {
        Method resourceLookupMethod;
        CLASS_NAME = ResourceInjectionBinding.class.getName();
        tc = Tr.register(ResourceInjectionBinding.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
        try {
            resourceLookupMethod = Resource.class.getMethod("lookup", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            resourceLookupMethod = null;
        }
        svResourceLookupMethod = resourceLookupMethod;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("javax.annotation.Resource.lookup = " + resourceLookupMethod), (Object[])new Object[0]);
        }
        ENV_ENTRY_TYPES = new Class[]{String.class, Integer.class, Boolean.class, Double.class, Byte.class, Short.class, Long.class, Float.class, Character.class, Class.class};
    }
}

