/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.support;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxws.metadata.JaxWsModuleMetaData;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionMetaData;
import com.ibm.wsspi.injectionengine.InjectionMetaDataListener;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxWsInjectionMetaDataListener
implements InjectionMetaDataListener {
    private static final TraceComponent tc = Tr.register(JaxWsInjectionMetaDataListener.class, (String)"JaxWsClientContainer", (String)"com.ibm.ws.jaxws.clientcontainer.internal.resources.JaxWsClientContainerMessages");
    static final long serialVersionUID = 1217934967759622434L;

    public void injectionMetaDataCreated(InjectionMetaData injectionMetaData) throws InjectionException {
        if (injectionMetaData == null) {
            return;
        }
        ModuleMetaData mmd = injectionMetaData.getModuleMetaData();
        if (mmd == null) {
            return;
        }
        JaxWsModuleMetaData jaxWsmoduleMetaData = JaxWsMetaDataManager.getJaxWsModuleMetaData(mmd);
        if (jaxWsmoduleMetaData == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unsupported Module, no JaxWsModuleMetaData is created for " + mmd.getName() + ", Injection Processing for web service is ignored"), (Object[])new Object[0]);
            }
            return;
        }
        if (!jaxWsmoduleMetaData.getJ2EEName().equals(mmd.getJ2EEName())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Not main module for the JaxWsModuleMetaData {0} or the jaxWsModuleMetaData has been initialized, Injection Processing for web service is ignored", (Object[])new Object[]{mmd.getName()});
            }
            return;
        }
        List injectionClasses = injectionMetaData.getComponentNameSpaceConfiguration().getInjectionClasses();
        if (injectionClasses != null) {
            for (Class clazz : injectionClasses) {
                jaxWsmoduleMetaData.setReferenceContext(clazz, injectionMetaData.getReferenceContext());
            }
        }
    }
}

