/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.values;

import com.ibm.ws.http.channel.internal.values.AccessLogData;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.util.Objects;

public class AccessLogRemoteHost
extends AccessLogData {
    public AccessLogRemoteHost() {
        super("%h");
    }

    @Override
    public boolean set(StringBuilder accessLogEntry, HttpResponseMessage response, HttpRequestMessage request, Object data) {
        String hostAddress = AccessLogRemoteHost.getRemoteHostAddress(response, request, data);
        if (hostAddress != null) {
            accessLogEntry.append(hostAddress);
        } else {
            accessLogEntry.append("-");
        }
        return Boolean.TRUE;
    }

    public static String getRemoteHostAddress(HttpResponseMessage response, HttpRequestMessage request, Object data) {
        String hostAddress = null;
        if (Objects.nonNull(request)) {
            HttpInboundServiceContext serviceContext;
            HttpInboundServiceContext httpInboundServiceContext = serviceContext = request.getServiceContext() instanceof HttpInboundServiceContext ? (HttpInboundServiceContext)request.getServiceContext() : null;
            if (Objects.nonNull(serviceContext)) {
                String string = hostAddress = serviceContext.useForwardedHeadersInAccessLog() ? serviceContext.getForwardedRemoteHost() : null;
                if (Objects.isNull(hostAddress)) {
                    hostAddress = serviceContext.getRemoteAddr().getHostAddress();
                }
            }
        }
        return hostAddress;
    }
}

