/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.io.Serializable;
import java.time.Instant;

public class SessionLogEntry
implements Serializable {
    private static final String EMPTY_MESSAGE = "";
    private String sessionId;
    protected transient Thread thread;
    private final Integer connectionId;
    protected String message;
    protected Throwable throwable;
    protected int level;
    protected String nameSpace;
    protected Object[] parameters;
    protected boolean shouldTranslate;
    protected String sourceClassName;
    protected String sourceMethodName;
    private Instant timeStamp;

    private SessionLogEntry(int level, String nameSpace, String sessionId, String message, Object[] parameters, Integer connectionId, boolean shouldTranslate, Throwable throwable) {
        this.sessionId = sessionId;
        this.thread = Thread.currentThread();
        this.connectionId = connectionId;
        this.message = message != null ? message : EMPTY_MESSAGE;
        this.throwable = throwable;
        this.level = level;
        this.nameSpace = nameSpace;
        this.parameters = parameters;
        this.shouldTranslate = shouldTranslate;
        this.sourceClassName = null;
        this.sourceMethodName = null;
        this.timeStamp = Instant.now();
    }

    public SessionLogEntry(int level, String category, String sessionId, String message, Object[] params, Integer connectionId, boolean shouldTranslate) {
        this(level, category, sessionId, message, params, connectionId, shouldTranslate, null);
    }

    public SessionLogEntry(int level, String category, String sessionId, String message, Throwable throwable) {
        this(level, category, sessionId, message, null, null, false, throwable);
    }

    public Integer getConnectionId() {
        return this.connectionId;
    }

    public Instant getTimeStamp() {
        return this.timeStamp;
    }

    public Throwable getException() {
        return this.throwable;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Thread getThread() {
        return this.thread;
    }

    public int getLevel() {
        return this.level;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public String getSourceClassName() {
        return this.sourceClassName;
    }

    public String getSourceMethodName() {
        return this.sourceMethodName;
    }

    public boolean shouldTranslate() {
        return this.shouldTranslate;
    }

    public boolean hasException() {
        return this.getException() != null;
    }

    public boolean hasMessage() {
        return this.getMessage() != null && !this.getMessage().isEmpty();
    }

    public void setTimeStamp(Instant timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setException(Throwable throwable) {
        this.throwable = throwable;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public void setParameters(Object[] params) {
        this.parameters = params;
    }

    public void setShouldTranslate(boolean shouldTranslate) {
        this.shouldTranslate = shouldTranslate;
    }

    public void setSourceClassName(String sourceClassName) {
        this.sourceClassName = sourceClassName;
    }

    public void setSourceMethodName(String sourceMethodName) {
        this.sourceMethodName = sourceMethodName;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getMessage() + ")";
    }
}

