/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc.v42;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.impl.StatementCacheKey;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcWrapper;
import com.ibm.ws.rsadapter.jdbc.v41.WSJdbc41PreparedStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.util.Arrays;

public class WSJdbc42PreparedStatement
extends WSJdbc41PreparedStatement
implements PreparedStatement {
    private static final TraceComponent tc = Tr.register(WSJdbc42PreparedStatement.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");

    public WSJdbc42PreparedStatement() {
    }

    public WSJdbc42PreparedStatement(PreparedStatement pstmtImplObject, WSJdbcConnection connWrapper, int theHoldability, String pstmtSQL) throws SQLException {
        super(pstmtImplObject, connWrapper, theHoldability, pstmtSQL);
    }

    public WSJdbc42PreparedStatement(PreparedStatement pstmtImplObject, WSJdbcConnection connWrapper, int theHoldability, String pstmtSQL, StatementCacheKey pstmtKey) throws SQLException {
        super(pstmtImplObject, connWrapper, theHoldability, pstmtSQL, pstmtKey);
    }

    public long getCompatibleUpdateCount() throws SQLException {
        if (this.mcf.jdbcDriverSpecVersion >= 42 && this.mcf.supportsGetLargeUpdateCount) {
            try {
                return this.stmtImpl.getLargeUpdateCount();
            }
            catch (UnsupportedOperationException | SQLFeatureNotSupportedException notSupp) {
                this.mcf.supportsGetLargeUpdateCount = false;
            }
        }
        return this.stmtImpl.getUpdateCount();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        try {
            return this.stmtImpl.getLargeUpdateCount();
        }
        catch (SQLException x) {
            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"699", (Object)this);
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)x);
        }
        catch (NullPointerException x) {
            throw this.runtimeXIfNotClosed(x);
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setLargeMaxRows", (Object[])new Object[]{max});
        }
        try {
            this.stmtImpl.setLargeMaxRows(max);
        }
        catch (SQLException x) {
            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"1041", (Object)this);
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)x);
        }
        catch (NullPointerException x) {
            throw this.runtimeXIfNotClosed(x);
        }
        this.haveStatementPropertiesChanged = true;
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        try {
            return this.stmtImpl.getLargeMaxRows();
        }
        catch (SQLException x) {
            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"691", (Object)this);
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)x);
        }
        catch (NullPointerException x) {
            throw this.runtimeXIfNotClosed(x);
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        long[] results;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"executeLargeBatch", (Object[])new Object[0]);
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            results = this.stmtImpl.executeLargeBatch();
            this.hasBatchParameters = false;
        }
        catch (SQLException sqlX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeBatch", (Object)sqlX);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)sqlX);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeBatch", (Object)nullX);
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeBatch", (Object)Arrays.toString(results));
        }
        return results;
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        long numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object[])new Object[]{sql});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.stmtImpl.executeLargeUpdate(sql);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object)nullX);
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        long numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object[])new Object[]{sql, AdapterUtil.getAutoGeneratedKeyString((int)autoGeneratedKeys)});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.stmtImpl.executeLargeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object)nullX);
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndices) throws SQLException {
        long numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object[])new Object[]{sql, Arrays.toString(columnIndices)});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.stmtImpl.executeLargeUpdate(sql, columnIndices);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object)nullX);
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        long numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object[])new Object[]{sql, Arrays.toString(columnNames)});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.stmtImpl.executeLargeUpdate(sql, columnNames);
        }
        catch (SQLException ex) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object)ex);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object)nullX);
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        long numUpdates;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object[])new Object[0]);
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            numUpdates = this.pstmtImpl.executeLargeUpdate();
        }
        catch (SQLException x) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object)x);
            }
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)x);
        }
        catch (RuntimeException x) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object)x);
            }
            throw x;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"executeLargeUpdate", (Object)numUpdates);
        }
        return numUpdates;
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType sqlType) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setObject #" + parameterIndex), (Object[])new Object[]{sqlType.getName()});
        }
        try {
            this.pstmtImpl.setObject(parameterIndex, x, sqlType);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setObject(int, Object, SQLType)", (String)"2057", (Object)this);
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType sqlType, int scaleOrLength) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setObject #" + parameterIndex), (Object[])new Object[]{sqlType.getName(), scaleOrLength});
        }
        try {
            this.pstmtImpl.setObject(parameterIndex, x, sqlType, scaleOrLength);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setObject(int, Object, SQLType, int)", (String)"2070", (Object)this);
            throw WSJdbcUtil.mapException((WSJdbcWrapper)this, (SQLException)ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }
}

