/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.ext.Providers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.plugins.interceptors.GZIPDecodingInterceptor;
import org.jboss.resteasy.plugins.interceptors.GZIPEncodingInterceptor;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.config.ConfigurationFactory;

public class RegisterBuiltin {
    private static final Map<ClassLoader, ResteasyProviderFactory> configuredClientFactories = new WeakHashMap<ClassLoader, ResteasyProviderFactory>();
    private static final boolean gzipForCachedFactories = RegisterBuiltin.isGZipEnabled();

    public static synchronized ResteasyProviderFactory getClientInitializedResteasyProviderFactory(ClassLoader cl) {
        ResteasyProviderFactory rpf = null;
        boolean gzip = RegisterBuiltin.isGZipEnabled();
        if (gzipForCachedFactories == gzip) {
            rpf = configuredClientFactories.get(cl);
        }
        if (rpf == null) {
            rpf = new ResteasyProviderFactoryImpl(RuntimeType.CLIENT){

                @Override
                public RuntimeType getRuntimeType() {
                    return RuntimeType.CLIENT;
                }
            };
            if (!rpf.isBuiltinsRegistered()) {
                RegisterBuiltin.register(rpf);
            }
            if (gzipForCachedFactories == gzip) {
                configuredClientFactories.put(cl, rpf);
            }
        }
        return rpf;
    }

    public static void register(ResteasyProviderFactory factory) {
        RegisterBuiltin.register(factory, Set.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ResteasyProviderFactory factory, Set<String> disabledProviders) {
        ResteasyProviderFactory monitor;
        ResteasyProviderFactory resteasyProviderFactory = monitor = factory instanceof ThreadLocalResteasyProviderFactory ? ((ThreadLocalResteasyProviderFactory)factory).getDelegate() : factory;
        synchronized (resteasyProviderFactory) {
            if (factory.isBuiltinsRegistered() || !factory.isRegisterBuiltins()) {
                return;
            }
            try {
                RegisterBuiltin.registerProviders(factory, disabledProviders);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            factory.setBuiltinsRegistered(true);
        }
    }

    public static void registerProviders(ResteasyProviderFactory factory) throws Exception {
        RegisterBuiltin.registerProviders(factory, Set.of());
    }

    public static void registerProviders(ResteasyProviderFactory factory, Set<String> disabledProviders) throws Exception {
        Map<String, URL> origins = RegisterBuiltin.scanBuiltins(disabledProviders);
        for (Map.Entry<String, URL> entry : origins.entrySet()) {
            String line = entry.getKey();
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(line);
                factory.registerProvider(clazz, true);
            }
            catch (NoClassDefFoundError e) {
                LogMessages.LOGGER.noClassDefFoundErrorError(line, entry.getValue(), e);
            }
            catch (ClassNotFoundException ex) {
                LogMessages.LOGGER.classNotFoundException(line, entry.getValue(), ex);
            }
        }
        if (RegisterBuiltin.isGZipEnabled()) {
            factory.registerProvider(GZIPDecodingInterceptor.class, true);
            factory.registerProvider(GZIPEncodingInterceptor.class, true);
        }
    }

    public static Map<String, URL> scanBuiltins() throws IOException, PrivilegedActionException {
        return RegisterBuiltin.scanBuiltins(Set.of());
    }

    public static Map<String, URL> scanBuiltins(Set<String> disabledProviders) throws IOException, PrivilegedActionException {
        Enumeration<URL> en = Thread.currentThread().getContextClassLoader().getResources("META-INF/services/" + Providers.class.getName());
        HashMap<String, URL> origins = new HashMap<String, URL>();
        while (en.hasMoreElements()) {
            URL url = en.nextElement();
            InputStream is = url.openStream();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    int commentIdx = line.indexOf(35);
                    if (commentIdx >= 0) {
                        line = line.substring(0, commentIdx);
                    }
                    if ((line = line.trim()).isEmpty()) continue;
                    if (disabledProviders.contains(line)) {
                        LogMessages.LOGGER.debugf("Skipping provider \"%s\" as it is marked as disabled.", line);
                        continue;
                    }
                    origins.put(line, url);
                }
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return origins;
    }

    public static boolean isGZipEnabled() {
        String value = ConfigurationFactory.getInstance().getConfiguration().getOptionalValue("resteasy.allowGzip", String.class).orElse(null);
        if ("".equals(value)) {
            return Boolean.FALSE;
        }
        return Boolean.parseBoolean(value);
    }
}

